/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.ConflationKey;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.internal.cache.DistributedCacheOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.InternalCacheEvent;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class InvalidateOperation
extends DistributedCacheOperation {
    private static final Logger logger = LogService.getLogger();

    public InvalidateOperation(EntryEventImpl event) {
        super(event);
    }

    @Override
    protected DistributedCacheOperation.CacheOperationMessage createMessage() {
        if (this.event.hasClientOrigin()) {
            InvalidateWithContextMessage msgwithContxt = new InvalidateWithContextMessage();
            msgwithContxt.context = this.event.getContext();
            return msgwithContxt;
        }
        return new InvalidateMessage();
    }

    @Override
    protected void initMessage(DistributedCacheOperation.CacheOperationMessage msg, DirectReplyProcessor processor) {
        super.initMessage(msg, processor);
        InvalidateMessage imsg = (InvalidateMessage)msg;
        EntryEventImpl eei = (EntryEventImpl)this.event;
        imsg.key = eei.getKey();
        imsg.eventId = eei.getEventId();
    }

    public static class InvalidateWithContextMessage
    extends InvalidateMessage {
        transient ClientProxyMembershipID context;

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl event = (EntryEventImpl)super.createEvent(rgn);
            event.setContext(this.context);
            return event;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; membershipID=");
            buff.append(this.context == null ? "" : this.context.toString());
        }

        @Override
        public int getDSFID() {
            return 140;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.context = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class InvalidateMessage
    extends DistributedCacheOperation.CacheOperationMessage {
        protected Object key;
        protected EventID eventId = null;

        protected boolean operateOnRegion(CacheEvent event, ClusterDistributionManager dm) throws EntryNotFoundException {
            EntryEventImpl ev = (EntryEventImpl)event;
            DistributedRegion rgn = (DistributedRegion)ev.getRegion();
            try {
                if (!rgn.isCacheContentProxy()) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("InvalidateMessage.operationOnRegion; key={}", ev.getKey());
                    }
                    boolean forceNewEntry = rgn.getDataPolicy().withReplication() && (!rgn.isInitialized() || rgn.getConcurrencyChecksEnabled());
                    boolean invokeCallbacks = rgn.isInitialized();
                    rgn.basicInvalidate(ev, invokeCallbacks, forceNewEntry);
                }
                this.appliedOperation = true;
                return true;
            }
            catch (ConcurrentCacheModificationException e) {
                this.dispatchElidedEvent(rgn, ev);
                return true;
            }
        }

        @Override
        protected InternalCacheEvent createEvent(DistributedRegion rgn) throws EntryNotFoundException {
            EntryEventImpl ev = EntryEventImpl.create((InternalRegion)rgn, this.getOperation(), this.key, null, this.callbackArg, true, this.getSender());
            ev.setEventId(this.eventId);
            this.setOldValueInEvent(ev);
            ev.setVersionTag(this.versionTag);
            if (this.filterRouting != null) {
                ev.setLocalFilterInfo(this.filterRouting.getFilterInfo(rgn.getMyId()));
            }
            ev.setInhibitAllNotifications(this.inhibitAllNotifications);
            return ev;
        }

        @Override
        protected void appendFields(StringBuilder buff) {
            super.appendFields(buff);
            buff.append("; key=");
            buff.append(this.key);
        }

        public int getDSFID() {
            return 101;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.eventId = (EventID)DataSerializer.readObject(in);
            this.key = DataSerializer.readObject(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.eventId, out);
            DataSerializer.writeObject(this.key, out);
        }

        @Override
        public EventID getEventID() {
            return this.eventId;
        }

        @Override
        public ConflationKey getConflationKey() {
            if (!this.regionAllowsConflation || this.getProcessorId() != 0) {
                return null;
            }
            return new ConflationKey(this.key, this.regionPath, false);
        }
    }
}

