/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.QueueStatHelper;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.statistics.StatisticsClock;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class CachePerfStats {
    @Immutable
    private static final StatisticsType type;
    static final int loadsInProgressId;
    static final int loadsCompletedId;
    static final int loadTimeId;
    static final int netloadsInProgressId;
    static final int netloadsCompletedId;
    static final int netloadTimeId;
    static final int netsearchesInProgressId;
    static final int netsearchesCompletedId;
    static final int netsearchTimeId;
    static final int cacheWriterCallsInProgressId;
    static final int cacheWriterCallsCompletedId;
    static final int cacheWriterCallTimeId;
    static final int cacheListenerCallsInProgressId;
    static final int cacheListenerCallsCompletedId;
    static final int cacheListenerCallTimeId;
    static final int getInitialImagesInProgressId;
    static final int getInitialImagesCompletedId;
    static final int deltaGetInitialImagesCompletedId;
    static final int getInitialImageTimeId;
    static final int getInitialImageKeysReceivedId;
    static final int regionsId;
    static final int partitionedRegionsId;
    protected static final int destroysId;
    static final int createsId;
    static final int putsId;
    protected static final int putTimeId;
    static final int putAllsId;
    static final int putAllTimeId;
    static final int removeAllsId;
    private static final int removeAllTimeId;
    protected static final int updatesId;
    static final int updateTimeId;
    static final int invalidatesId;
    static final int getsId;
    protected static final int getTimeId;
    protected static final int eventQueueSizeId;
    static final int eventQueueThrottleTimeId;
    static final int eventQueueThrottleCountId;
    static final int eventThreadsId;
    static final int missesId;
    protected static final int queryExecutionsId;
    static final int queryExecutionTimeId;
    static final int queryResultsHashCollisionsId;
    static final int queryResultsHashCollisionProbeTimeId;
    static final int partitionedRegionQueryRetriesId;
    static final int txSuccessLifeTimeId;
    static final int txFailedLifeTimeId;
    static final int txRollbackLifeTimeId;
    static final int txCommitsId;
    static final int txFailuresId;
    static final int txRollbacksId;
    static final int txCommitTimeId;
    static final int txFailureTimeId;
    static final int txRollbackTimeId;
    static final int txCommitChangesId;
    static final int txFailureChangesId;
    static final int txRollbackChangesId;
    static final int txConflictCheckTimeId;
    static final int reliableQueuedOpsId;
    static final int reliableQueueSizeId;
    static final int reliableQueueMaxId;
    static final int reliableRegionsId;
    static final int reliableRegionsMissingId;
    static final int reliableRegionsQueuingId;
    static final int reliableRegionsMissingFullAccessId;
    static final int reliableRegionsMissingLimitedAccessId;
    static final int reliableRegionsMissingNoAccessId;
    static final int entryCountId;
    protected static final int eventsQueuedId;
    static final int retriesId;
    static final int diskTasksWaitingId;
    static final int evictorJobsStartedId;
    static final int evictorJobsCompletedId;
    static final int evictorQueueSizeId;
    static final int evictWorkTimeId;
    static final int indexUpdateInProgressId;
    static final int indexUpdateCompletedId;
    static final int indexUpdateTimeId;
    static final int clearsId;
    private static final int indexInitializationInProgressId;
    private static final int indexInitializationCompletedId;
    private static final int indexInitializationTimeId;
    static final int metaDataRefreshCountId;
    static final int conflatedEventsId;
    static final int tombstoneCountId;
    static final int tombstoneGCCountId;
    private static final int tombstoneOverhead1Id;
    private static final int tombstoneOverhead2Id;
    static final int clearTimeoutsId;
    static final int deltaUpdatesId;
    private static final int deltaUpdatesTimeId;
    static final int deltaFailedUpdatesId;
    static final int deltasPreparedId;
    private static final int deltasPreparedTimeId;
    static final int deltasSentId;
    static final int deltaFullValuesSentId;
    static final int deltaFullValuesRequestedId;
    static final int importedEntriesCountId;
    static final int importTimeId;
    static final int exportedEntriesCountId;
    static final int exportTimeId;
    static final int compressionCompressTimeId;
    static final int compressionDecompressTimeId;
    static final int compressionCompressionsId;
    static final int compressionDecompressionsId;
    static final int compressionPreCompressedBytesId;
    static final int compressionPostCompressedBytesId;
    @VisibleForTesting
    static final int handlingNetsearchesInProgressId;
    @VisibleForTesting
    static final int handlingNetsearchesCompletedId;
    @VisibleForTesting
    static final int handlingNetsearchesTimeId;
    @VisibleForTesting
    static final int handlingNetsearchesFailedId;
    @VisibleForTesting
    static final int handlingNetsearchesFailedTimeId;
    @VisibleForTesting
    protected static final int previouslySeenEventsId;
    protected final Statistics stats;
    private final StatisticsClock clock;

    public CachePerfStats(StatisticsFactory factory, StatisticsClock clock) {
        this(factory, "cachePerfStats", clock);
    }

    public CachePerfStats(StatisticsFactory factory, String textId, StatisticsClock clock) {
        this.stats = factory == null ? null : factory.createAtomicStatistics(type, textId);
        this.clock = clock;
    }

    public static StatisticsType getStatisticsType() {
        return type;
    }

    public Statistics getStats() {
        return this.stats;
    }

    public long getTime() {
        return this.clock.getTime();
    }

    public long getLoadsCompleted() {
        return this.stats.getLong(loadsCompletedId);
    }

    public long getLoadTime() {
        return this.stats.getLong(loadTimeId);
    }

    public long getNetloadsCompleted() {
        return this.stats.getLong(netloadsCompletedId);
    }

    public long getNetsearchesCompleted() {
        return this.stats.getLong(netsearchesCompletedId);
    }

    public long getNetsearchTime() {
        return this.stats.getLong(netsearchTimeId);
    }

    public long getGetInitialImagesCompleted() {
        return this.stats.getLong(getInitialImagesCompletedId);
    }

    long getDeltaGetInitialImagesCompleted() {
        return this.stats.getLong(deltaGetInitialImagesCompletedId);
    }

    public long getGetInitialImageKeysReceived() {
        return this.stats.getLong(getInitialImageKeysReceivedId);
    }

    public long getRegions() {
        return this.stats.getLong(regionsId);
    }

    public long getDestroys() {
        return this.stats.getLong(destroysId);
    }

    public long getCreates() {
        return this.stats.getLong(createsId);
    }

    public long getPuts() {
        return this.stats.getLong(putsId);
    }

    public long getPutTime() {
        return this.stats.getLong(putTimeId);
    }

    public long getPutAlls() {
        return this.stats.getLong(putAllsId);
    }

    long getRemoveAlls() {
        return this.stats.getLong(removeAllsId);
    }

    public long getUpdates() {
        return this.stats.getLong(updatesId);
    }

    public long getInvalidates() {
        return this.stats.getLong(invalidatesId);
    }

    public long getGets() {
        return this.stats.getLong(getsId);
    }

    public long getGetTime() {
        return this.stats.getLong(getTimeId);
    }

    public long getMisses() {
        return this.stats.getLong(missesId);
    }

    public long getReliableQueuedOps() {
        return this.stats.getLong(reliableQueuedOpsId);
    }

    public void incReliableQueuedOps(long inc) {
        this.stats.incLong(reliableQueuedOpsId, inc);
    }

    public void incReliableQueueSize(long inc) {
        this.stats.incLong(reliableQueueSizeId, inc);
    }

    public void incReliableQueueMax(long inc) {
        this.stats.incLong(reliableQueueMaxId, inc);
    }

    public void incReliableRegions(long inc) {
        this.stats.incLong(reliableRegionsId, inc);
    }

    public long getReliableRegionsMissing() {
        return this.stats.getLong(reliableRegionsMissingId);
    }

    public void incReliableRegionsMissing(long inc) {
        this.stats.incLong(reliableRegionsMissingId, inc);
    }

    public void incReliableRegionsQueuing(long inc) {
        this.stats.incLong(reliableRegionsQueuingId, inc);
    }

    public long getReliableRegionsMissingFullAccess() {
        return this.stats.getLong(reliableRegionsMissingFullAccessId);
    }

    public void incReliableRegionsMissingFullAccess(long inc) {
        this.stats.incLong(reliableRegionsMissingFullAccessId, inc);
    }

    public long getReliableRegionsMissingLimitedAccess() {
        return this.stats.getLong(reliableRegionsMissingLimitedAccessId);
    }

    public void incReliableRegionsMissingLimitedAccess(long inc) {
        this.stats.incLong(reliableRegionsMissingLimitedAccessId, inc);
    }

    public long getReliableRegionsMissingNoAccess() {
        return this.stats.getLong(reliableRegionsMissingNoAccessId);
    }

    public void incReliableRegionsMissingNoAccess(long inc) {
        this.stats.incLong(reliableRegionsMissingNoAccessId, inc);
    }

    public void incQueuedEvents(long inc) {
        this.stats.incLong(eventsQueuedId, inc);
    }

    long getDeltaUpdates() {
        return this.stats.getLong(deltaUpdatesId);
    }

    long getDeltaUpdatesTime() {
        return this.stats.getLong(deltaUpdatesTimeId);
    }

    public long getDeltaFailedUpdates() {
        return this.stats.getLong(deltaFailedUpdatesId);
    }

    long getDeltasPrepared() {
        return this.stats.getLong(deltasPreparedId);
    }

    long getDeltasPreparedTime() {
        return this.stats.getLong(deltasPreparedTimeId);
    }

    public long getDeltasSent() {
        return this.stats.getLong(deltasSentId);
    }

    public long getDeltaFullValuesSent() {
        return this.stats.getLong(deltaFullValuesSentId);
    }

    long getDeltaFullValuesRequested() {
        return this.stats.getLong(deltaFullValuesRequestedId);
    }

    public long getTotalCompressionTime() {
        return this.stats.getLong(compressionCompressTimeId);
    }

    public long getTotalDecompressionTime() {
        return this.stats.getLong(compressionDecompressTimeId);
    }

    public long getTotalCompressions() {
        return this.stats.getLong(compressionCompressionsId);
    }

    public long getTotalDecompressions() {
        return this.stats.getLong(compressionDecompressionsId);
    }

    public long getTotalPreCompressedBytes() {
        return this.stats.getLong(compressionPreCompressedBytesId);
    }

    public long getTotalPostCompressedBytes() {
        return this.stats.getLong(compressionPostCompressedBytesId);
    }

    public long startCompression() {
        this.stats.incLong(compressionCompressionsId, 1L);
        return this.getTime();
    }

    public void endCompression(long startTime, long startSize, long endSize) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(compressionCompressTimeId, this.getTime() - startTime);
        }
        this.stats.incLong(compressionPreCompressedBytesId, startSize);
        this.stats.incLong(compressionPostCompressedBytesId, endSize);
    }

    public long startDecompression() {
        this.stats.incLong(compressionDecompressionsId, 1L);
        return this.getTime();
    }

    public void endDecompression(long startTime) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(compressionDecompressTimeId, this.getTime() - startTime);
        }
    }

    public long startLoad() {
        this.stats.incLong(loadsInProgressId, 1L);
        return NanoTimer.getTime();
    }

    public void endLoad(long start) {
        long ts = NanoTimer.getTime();
        this.stats.incLong(loadTimeId, ts - start);
        this.stats.incLong(loadsInProgressId, -1L);
        this.stats.incLong(loadsCompletedId, 1L);
    }

    public long startNetload() {
        this.stats.incLong(netloadsInProgressId, 1L);
        return this.getTime();
    }

    public void endNetload(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(netloadTimeId, this.getTime() - start);
        }
        this.stats.incLong(netloadsInProgressId, -1L);
        this.stats.incLong(netloadsCompletedId, 1L);
    }

    public long startNetsearch() {
        this.stats.incLong(netsearchesInProgressId, 1L);
        return NanoTimer.getTime();
    }

    public void endNetsearch(long start) {
        long ts = NanoTimer.getTime();
        this.stats.incLong(netsearchTimeId, ts - start);
        this.stats.incLong(netsearchesInProgressId, -1L);
        this.stats.incLong(netsearchesCompletedId, 1L);
    }

    public long startCacheWriterCall() {
        this.stats.incLong(cacheWriterCallsInProgressId, 1L);
        return this.getTime();
    }

    public void endCacheWriterCall(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(cacheWriterCallTimeId, this.getTime() - start);
        }
        this.stats.incLong(cacheWriterCallsInProgressId, -1L);
        this.stats.incLong(cacheWriterCallsCompletedId, 1L);
    }

    long getCacheWriterCallsCompleted() {
        return this.stats.getLong(cacheWriterCallsCompletedId);
    }

    public long startCacheListenerCall() {
        this.stats.incLong(cacheListenerCallsInProgressId, 1L);
        return this.getTime();
    }

    public void endCacheListenerCall(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(cacheListenerCallTimeId, this.getTime() - start);
        }
        this.stats.incLong(cacheListenerCallsInProgressId, -1L);
        this.stats.incLong(cacheListenerCallsCompletedId, 1L);
    }

    long getCacheListenerCallsCompleted() {
        return this.stats.getLong(cacheListenerCallsCompletedId);
    }

    public long startGetInitialImage() {
        this.stats.incLong(getInitialImagesInProgressId, 1L);
        return this.getTime();
    }

    public void endGetInitialImage(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(getInitialImageTimeId, this.getTime() - start);
        }
        this.stats.incLong(getInitialImagesInProgressId, -1L);
        this.stats.incLong(getInitialImagesCompletedId, 1L);
    }

    public void endNoGIIDone(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(getInitialImageTimeId, this.getTime() - start);
        }
        this.stats.incLong(getInitialImagesInProgressId, -1L);
    }

    void incDeltaGIICompleted() {
        this.stats.incLong(deltaGetInitialImagesCompletedId, 1L);
    }

    public void incGetInitialImageKeysReceived() {
        this.stats.incLong(getInitialImageKeysReceivedId, 1L);
    }

    public long startIndexUpdate() {
        this.stats.incLong(indexUpdateInProgressId, 1L);
        return this.getTime();
    }

    public void endIndexUpdate(long start) {
        long ts = this.getTime();
        this.stats.incLong(indexUpdateTimeId, ts - start);
        this.stats.incLong(indexUpdateInProgressId, -1L);
        this.stats.incLong(indexUpdateCompletedId, 1L);
    }

    long getIndexUpdateCompleted() {
        return this.stats.getLong(indexUpdateCompletedId);
    }

    long startIndexInitialization() {
        this.stats.incLong(indexInitializationInProgressId, 1L);
        return this.getTime();
    }

    void endIndexInitialization(long start) {
        long ts = this.getTime();
        this.stats.incLong(indexInitializationTimeId, ts - start);
        this.stats.incLong(indexInitializationInProgressId, -1L);
        this.stats.incLong(indexInitializationCompletedId, 1L);
    }

    public long getIndexInitializationTime() {
        return this.stats.getLong(indexInitializationTimeId);
    }

    public void incRegions(long inc) {
        this.stats.incLong(regionsId, inc);
    }

    public void incPartitionedRegions(long inc) {
        this.stats.incLong(partitionedRegionsId, inc);
    }

    public void incDestroys() {
        this.stats.incLong(destroysId, 1L);
    }

    public void incCreates() {
        this.stats.incLong(createsId, 1L);
    }

    public void incInvalidates() {
        this.stats.incLong(invalidatesId, 1L);
    }

    public long startGet() {
        return this.getTime();
    }

    public void endGet(long start, boolean miss) {
        if (this.clock.isEnabled()) {
            long delta = this.getTime() - start;
            this.stats.incLong(getTimeId, delta);
        }
        this.stats.incLong(getsId, 1L);
        if (miss) {
            this.stats.incLong(missesId, 1L);
        }
    }

    public void endGetForClient(long start, boolean miss) {
    }

    public long endPut(long start, boolean isUpdate) {
        long total = 0L;
        if (isUpdate) {
            this.stats.incLong(updatesId, 1L);
            if (this.clock.isEnabled()) {
                total = this.getTime() - start;
                this.stats.incLong(updateTimeId, total);
            }
        } else {
            this.stats.incLong(putsId, 1L);
            if (this.clock.isEnabled()) {
                total = this.getTime() - start;
                this.stats.incLong(putTimeId, total);
            }
        }
        return total;
    }

    public void endPutAll(long start) {
        this.stats.incLong(putAllsId, 1L);
        if (this.clock.isEnabled()) {
            this.stats.incLong(putAllTimeId, this.getTime() - start);
        }
    }

    public void endRemoveAll(long start) {
        this.stats.incLong(removeAllsId, 1L);
        if (this.clock.isEnabled()) {
            this.stats.incLong(removeAllTimeId, this.getTime() - start);
        }
    }

    public void endQueryExecution(long executionTime) {
        this.stats.incLong(queryExecutionsId, 1L);
        if (this.clock.isEnabled()) {
            this.stats.incLong(queryExecutionTimeId, executionTime);
        }
    }

    public long getQueryExecutions() {
        return this.stats.getLong(queryExecutionsId);
    }

    public void endQueryResultsHashCollisionProbe(long start) {
        if (this.clock.isEnabled()) {
            this.stats.incLong(queryResultsHashCollisionProbeTimeId, this.getTime() - start);
        }
    }

    public void incQueryResultsHashCollisions() {
        this.stats.incLong(queryResultsHashCollisionsId, 1L);
    }

    public long getTxCommits() {
        return this.stats.getLong(txCommitsId);
    }

    public long getTxCommitChanges() {
        return this.stats.getLong(txCommitChangesId);
    }

    public long getTxCommitTime() {
        return this.stats.getLong(txCommitTimeId);
    }

    public long getTxSuccessLifeTime() {
        return this.stats.getLong(txSuccessLifeTimeId);
    }

    public long getTxFailures() {
        return this.stats.getLong(txFailuresId);
    }

    public long getTxFailureChanges() {
        return this.stats.getLong(txFailureChangesId);
    }

    public long getTxFailureTime() {
        return this.stats.getLong(txFailureTimeId);
    }

    public long getTxFailedLifeTime() {
        return this.stats.getLong(txFailedLifeTimeId);
    }

    public long getTxRollbacks() {
        return this.stats.getLong(txRollbacksId);
    }

    public long getTxRollbackChanges() {
        return this.stats.getLong(txRollbackChangesId);
    }

    public long getTxRollbackTime() {
        return this.stats.getLong(txRollbackTimeId);
    }

    public long getTxRollbackLifeTime() {
        return this.stats.getLong(txRollbackLifeTimeId);
    }

    public void incTxConflictCheckTime(long delta) {
        this.stats.incLong(txConflictCheckTimeId, delta);
    }

    public void txSuccess(long opTime, long txLifeTime, long txChanges) {
        this.stats.incLong(txCommitsId, 1L);
        this.stats.incLong(txCommitChangesId, txChanges);
        this.stats.incLong(txCommitTimeId, opTime);
        this.stats.incLong(txSuccessLifeTimeId, txLifeTime);
    }

    public void txFailure(long opTime, long txLifeTime, long txChanges) {
        this.stats.incLong(txFailuresId, 1L);
        this.stats.incLong(txFailureChangesId, txChanges);
        this.stats.incLong(txFailureTimeId, opTime);
        this.stats.incLong(txFailedLifeTimeId, txLifeTime);
    }

    public void txRollback(long opTime, long txLifeTime, long txChanges) {
        this.stats.incLong(txRollbacksId, 1L);
        this.stats.incLong(txRollbackChangesId, txChanges);
        this.stats.incLong(txRollbackTimeId, opTime);
        this.stats.incLong(txRollbackLifeTimeId, txLifeTime);
    }

    void endDeltaUpdate(long start) {
        this.stats.incLong(deltaUpdatesId, 1L);
        if (this.clock.isEnabled()) {
            this.stats.incLong(deltaUpdatesTimeId, this.getTime() - start);
        }
    }

    public void incDeltaFailedUpdates() {
        this.stats.incLong(deltaFailedUpdatesId, 1L);
    }

    public void endDeltaPrepared(long start) {
        this.stats.incLong(deltasPreparedId, 1L);
        if (this.clock.isEnabled()) {
            this.stats.incLong(deltasPreparedTimeId, this.getTime() - start);
        }
    }

    public void incDeltasSent() {
        this.stats.incLong(deltasSentId, 1L);
    }

    public void incDeltaFullValuesSent() {
        this.stats.incLong(deltaFullValuesSentId, 1L);
    }

    public void incDeltaFullValuesRequested() {
        this.stats.incLong(deltaFullValuesRequestedId, 1L);
    }

    protected void close() {
        this.stats.close();
    }

    public boolean isClosed() {
        return this.stats.isClosed();
    }

    public long getEventQueueSize() {
        return this.stats.getLong(eventQueueSizeId);
    }

    public void incEventQueueSize(long items) {
        this.stats.incLong(eventQueueSizeId, items);
    }

    public void incEventQueueThrottleCount(long items) {
        this.stats.incLong(eventQueueThrottleCountId, items);
    }

    protected void incEventQueueThrottleTime(long nanos) {
        this.stats.incLong(eventQueueThrottleTimeId, nanos);
    }

    protected void incEventThreads(long items) {
        this.stats.incLong(eventThreadsId, items);
    }

    public void incEntryCount(long delta) {
        this.stats.incLong(entryCountId, delta);
    }

    public void incRetries() {
        this.stats.incLong(retriesId, 1L);
    }

    public long getRetries() {
        return this.stats.getLong(retriesId);
    }

    public void incDiskTasksWaiting() {
        this.stats.incLong(diskTasksWaitingId, 1L);
    }

    public void decDiskTasksWaiting() {
        this.stats.incLong(diskTasksWaitingId, -1L);
    }

    long getDiskTasksWaiting() {
        return this.stats.getLong(diskTasksWaitingId);
    }

    public void decDiskTasksWaiting(long count) {
        this.stats.incLong(diskTasksWaitingId, -count);
    }

    public void incEvictorJobsStarted() {
        this.stats.incLong(evictorJobsStartedId, 1L);
    }

    long getEvictorJobsStarted() {
        return this.stats.getLong(evictorJobsStartedId);
    }

    public void incEvictorJobsCompleted() {
        this.stats.incLong(evictorJobsCompletedId, 1L);
    }

    long getEvictorJobsCompleted() {
        return this.stats.getLong(evictorJobsCompletedId);
    }

    public void incEvictorQueueSize(long delta) {
        this.stats.incLong(evictorQueueSizeId, delta);
    }

    public void incEvictWorkTime(long delta) {
        this.stats.incLong(evictWorkTimeId, delta);
    }

    public PoolStatHelper getEventPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                CachePerfStats.this.incEventThreads(1L);
            }

            @Override
            public void endJob() {
                CachePerfStats.this.incEventThreads(-1L);
            }
        };
    }

    public long getClearCount() {
        return this.stats.getLong(clearsId);
    }

    public void incClearCount() {
        this.stats.incLong(clearsId, 1L);
    }

    public long getConflatedEventsCount() {
        return this.stats.getLong(conflatedEventsId);
    }

    public void incConflatedEventsCount() {
        this.stats.incLong(conflatedEventsId, 1L);
    }

    public long getTombstoneCount() {
        return this.stats.getLong(tombstoneCountId);
    }

    public void incTombstoneCount(long amount) {
        this.stats.incLong(tombstoneCountId, amount);
    }

    public long getTombstoneGCCount() {
        return this.stats.getLong(tombstoneGCCountId);
    }

    public void incTombstoneGCCount() {
        this.stats.incLong(tombstoneGCCountId, 1L);
    }

    void setReplicatedTombstonesSize(long size) {
        this.stats.setLong(tombstoneOverhead1Id, size);
    }

    void setNonReplicatedTombstonesSize(long size) {
        this.stats.setLong(tombstoneOverhead2Id, size);
    }

    public long getClearTimeouts() {
        return this.stats.getLong(clearTimeoutsId);
    }

    public void incClearTimeouts() {
        this.stats.incLong(clearTimeoutsId, 1L);
    }

    public void incPRQueryRetries() {
        this.stats.incLong(partitionedRegionQueryRetriesId, 1L);
    }

    long getPRQueryRetries() {
        return this.stats.getLong(partitionedRegionQueryRetriesId);
    }

    public QueueStatHelper getEvictionQueueStatHelper() {
        return new QueueStatHelper(){

            @Override
            public void add() {
                CachePerfStats.this.incEvictorQueueSize(1L);
            }

            @Override
            public void remove() {
                CachePerfStats.this.incEvictorQueueSize(-1L);
            }

            @Override
            public void remove(long count) {
                CachePerfStats.this.incEvictorQueueSize(count * -1L);
            }
        };
    }

    public void incMetaDataRefreshCount() {
        this.stats.incLong(metaDataRefreshCountId, 1L);
    }

    long getMetaDataRefreshCount() {
        return this.stats.getLong(metaDataRefreshCountId);
    }

    public void endImport(long entryCount, long start) {
        this.stats.incLong(importedEntriesCountId, entryCount);
        if (this.clock.isEnabled()) {
            this.stats.incLong(importTimeId, this.getTime() - start);
        }
    }

    public void endExport(long entryCount, long start) {
        this.stats.incLong(exportedEntriesCountId, entryCount);
        if (this.clock.isEnabled()) {
            this.stats.incLong(exportTimeId, this.getTime() - start);
        }
    }

    public long startHandlingNetsearch() {
        this.stats.incLong(handlingNetsearchesInProgressId, 1L);
        return this.getTime();
    }

    public void endHandlingNetsearch(long start, boolean success) {
        long ts = this.getTime();
        if (success) {
            this.stats.incLong(handlingNetsearchesCompletedId, 1L);
            this.stats.incLong(handlingNetsearchesTimeId, ts - start);
        } else {
            this.stats.incLong(handlingNetsearchesFailedId, 1L);
            this.stats.incLong(handlingNetsearchesFailedTimeId, ts - start);
        }
        this.stats.incLong(handlingNetsearchesInProgressId, -1L);
    }

    public long getHandlingNetsearchesCompleted() {
        return this.stats.getLong(handlingNetsearchesCompletedId);
    }

    public long getHandlingNetsearchesFailed() {
        return this.stats.getLong(handlingNetsearchesFailedId);
    }

    public long getPreviouslySeenEvents() {
        return this.stats.getLong(previouslySeenEventsId);
    }

    public void incPreviouslySeenEvents() {
        this.stats.incLong(previouslySeenEventsId, 1L);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String loadsInProgressDesc = "Current number of threads in this cache doing a cache load.";
        String loadsCompletedDesc = "Total number of times a load on this cache has completed (as a result of either a local get() or a remote netload).";
        String loadTimeDesc = "Total time spent invoking loaders on this cache.";
        String netloadsInProgressDesc = "Current number of threads doing a network load initiated by a get() in this cache.";
        String netloadsCompletedDesc = "Total number of times a network load initiated on this cache has completed.";
        String netloadTimeDesc = "Total time spent doing network loads on this cache.";
        String netsearchesInProgressDesc = "Current number of threads doing a network search initiated by a get() in this cache.";
        String netsearchesCompletedDesc = "Total number of times network searches initiated by this cache have completed.";
        String netsearchTimeDesc = "Total time spent doing network searches for cache values.";
        String cacheWriterCallsInProgressDesc = "Current number of threads doing a cache writer call.";
        String cacheWriterCallsCompletedDesc = "Total number of times a cache writer call has completed.";
        String cacheWriterCallTimeDesc = "Total time spent doing cache writer calls.";
        String cacheListenerCallsInProgressDesc = "Current number of threads doing a cache listener call.";
        String cacheListenerCallsCompletedDesc = "Total number of times a cache listener call has completed.";
        String cacheListenerCallTimeDesc = "Total time spent doing cache listener calls.";
        String getInitialImagesInProgressDesc = "Current number of getInitialImage operations currently in progress.";
        String getInitialImagesCompletedDesc = "Total number of times getInitialImages (both delta and full GII) initiated by this cache have completed.";
        String deltaGetInitialImagesCompletedDesc = "Total number of times delta getInitialImages initiated by this cache have completed.";
        String getInitialImageTimeDesc = "Total time spent doing getInitialImages for region creation.";
        String getInitialImageKeysReceivedDesc = "Total number of keys received while doing getInitialImage operations.";
        String regionsDesc = "The current number of regions in the cache.";
        String partitionedRegionsDesc = "The current number of partitioned regions in the cache.";
        String destroysDesc = "The total number of times a cache object entry has been destroyed in this cache.";
        String updatesDesc = "The total number of updates originating remotely that have been applied to this cache.";
        String updateTimeDesc = "Total time spent performing an update.";
        String invalidatesDesc = "The total number of times an existing cache object entry value in this cache has been invalidated";
        String getsDesc = "The total number of times a successful get has been done on this cache.";
        String createsDesc = "The total number of times an entry is added to this cache.";
        String putsDesc = "The total number of times an entry is added or replaced in this cache as a result of a local operation (put(), create(), or get() which results in load, netsearch, or netloading a value). Note that this only counts puts done explicitly on this cache. It does not count updates pushed from other caches.";
        String putTimeDesc = "Total time spent adding or replacing an entry in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).";
        String putallsDesc = "The total number of times a map is added or replaced in this cache as a result of a local operation. Note that this only counts putAlls done explicitly on this cache. It does not count updates pushed from other caches.";
        String putallTimeDesc = "Total time spent replacing a map in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).";
        String removeAllsDesc = "The total number of removeAll operations that originated in this cache. Note that this only counts removeAlls done explicitly on this cache. It does not count removes pushed from other caches.";
        String removeAllTimeDesc = "Total time spent performing removeAlls that originated in this cache. This includes time spent waiting for the removeAll to be done in remote caches (if required).";
        String getTimeDesc = "Total time spent doing get operations from this cache (including netsearch and netload)";
        String eventQueueSizeDesc = "The number of cache events waiting to be processed.";
        String eventQueueThrottleTimeDesc = "The total amount of time, in nanoseconds, spent delayed by the event queue throttle.";
        String eventQueueThrottleCountDesc = "The total number of times a thread was delayed in adding an event to the event queue.";
        String eventThreadsDesc = "The number of threads currently processing events.";
        String missesDesc = "Total number of times a get on the cache did not find a value already in local memory. The number of hits (i.e. gets that did not miss) can be calculated by subtracting misses from gets.";
        String queryExecutionsDesc = "Total number of times some query has been executed";
        String queryExecutionTimeDesc = "Total time spent executing queries";
        String queryResultsHashCollisionsDesc = "Total number of times an hash code collision occurred when inserting an object into an OQL result set or rehashing it";
        String queryResultsHashCollisionProbeTimeDesc = "Total time spent probing the hashtable in an OQL result set due to hash code collisions, includes reads, writes, and rehashes";
        String partitionedRegionOQLQueryRetriesDesc = "Total number of times an OQL Query on a Partitioned Region had to be retried";
        String txSuccessLifeTimeDesc = "The total amount of time, in nanoseconds, spent in a transaction before a successful commit. The time measured starts at transaction begin and ends when commit is called.";
        String txFailedLifeTimeDesc = "The total amount of time, in nanoseconds, spent in a transaction before a failed commit. The time measured starts at transaction begin and ends when commit is called.";
        String txRollbackLifeTimeDesc = "The total amount of time, in nanoseconds, spent in a transaction before an explicit rollback. The time measured starts at transaction begin and ends when rollback is called.";
        String txCommitsDesc = "Total number times a transaction commit has succeeded.";
        String txFailuresDesc = "Total number times a transaction commit has failed.";
        String txRollbacksDesc = "Total number times a transaction has been explicitly rolled back.";
        String txCommitTimeDesc = "The total amount of time, in nanoseconds, spent doing successful transaction commits.";
        String txFailureTimeDesc = "The total amount of time, in nanoseconds, spent doing failed transaction commits.";
        String txRollbackTimeDesc = "The total amount of time, in nanoseconds, spent doing explicit transaction rollbacks.";
        String txCommitChangesDesc = "Total number of changes made by committed transactions.";
        String txFailureChangesDesc = "Total number of changes lost by failed transactions.";
        String txRollbackChangesDesc = "Total number of changes lost by explicit transaction rollbacks.";
        String txConflictCheckTimeDesc = "The total amount of time, in nanoseconds, spent doing conflict checks during transaction commit";
        String reliableQueuedOpsDesc = "Current number of cache operations queued for distribution to required roles.";
        String reliableQueueSizeDesc = "Current size in megabytes of disk used to queue for distribution to required roles.";
        String reliableQueueMaxDesc = "Maximum size in megabytes allotted for disk usage to queue for distribution to required roles.";
        String reliableRegionsDesc = "Current number of regions configured for reliability.";
        String reliableRegionsMissingDesc = "Current number regions configured for reliability that are missing required roles.";
        String reliableRegionsQueuingDesc = "Current number regions configured for reliability that are queuing for required roles.";
        String reliableRegionsMissingFullAccessDesc = "Current number of regions configured for reliablity that are missing require roles with full access";
        String reliableRegionsMissingLimitedAccessDesc = "Current number of regions configured for reliablity that are missing required roles with Limited access";
        String reliableRegionsMissingNoAccessDesc = "Current number of regions configured for reliablity that are missing required roles with No access";
        String clearsDesc = "The total number of times a clear has been done on this cache.";
        String metaDataRefreshCountDesc = "Total number of times the meta data is refreshed due to hopping observed.";
        String conflatedEventsDesc = "Number of events not delivered due to conflation.  Typically this means that the event arrived after a later event was already applied to the cache.";
        String tombstoneCountDesc = "Number of destroyed entries that are retained for concurrent modification detection";
        String tombstoneGCCountDesc = "Number of garbage-collections performed on destroyed entries";
        String tombstoneOverhead1Desc = "Amount of memory consumed by destroyed entries in replicated or partitioned regions";
        String tombstoneOverhead2Desc = "Amount of memory consumed by destroyed entries in non-replicated regions";
        String clearTimeoutsDesc = "Number of timeouts waiting for events concurrent to a clear() operation to be received and applied before performing the clear()";
        String deltaUpdatesDesc = "The total number of times entries in this cache are updated through delta bytes.";
        String deltaUpdatesTimeDesc = "Total time spent applying the received delta bytes to entries in this cache.";
        String deltaFailedUpdatesDesc = "The total number of times entries in this cache failed to be updated through delta bytes.";
        String deltasPreparedDesc = "The total number of times delta was prepared in this cache.";
        String deltasPreparedTimeDesc = "Total time spent preparing delta bytes in this cache.";
        String deltasSentDesc = "The total number of times delta was sent to remote caches. This excludes deltas sent from server to client.";
        String deltaFullValuesSentDesc = "The total number of times a full value was sent to a remote cache.";
        String deltaFullValuesRequestedDesc = "The total number of times a full value was requested by this cache.";
        String importedEntriesCountDesc = "The total number of entries imported from a snapshot file.";
        String importTimeDesc = "The total time spent importing entries from a snapshot file.";
        String exportedEntriesCountDesc = "The total number of entries exported into a snapshot file.";
        String exportTimeDesc = "The total time spent exporting entries into a snapshot file.";
        String compressionCompressTimeDesc = "The total time spent compressing data.";
        String compressionDecompressTimeDesc = "The total time spent decompressing data.";
        String compressionCompressionsDesc = "The total number of compression operations.";
        String compressionDecompressionsDesc = "The total number of decompression operations.";
        String compressionPreCompresssedBytesDesc = "The total number of bytes before compressing.";
        String compressionPostCompressedBytesDesc = "The total number of bytes after compressing.";
        String evictByCriteria_evictionsDesc = "The total number of entries evicted";
        String evictByCriteria_evictionTimeDesc = "Time taken for eviction process";
        String evictByCriteria_evictionsInProgressDesc = "Total number of evictions in progress";
        String evictByCriteria_evaluationsDesc = "Total number of evaluations for eviction";
        String evictByCriteria_evaluationTimeDesc = "Total time taken for evaluation of user expression during eviction";
        String handlingNetsearchesInProgressDesc = "Current number of threads handling a network search initiated by a remote cache.";
        String handlingNetsearchesCompletedDesc = "Total number of times handling a network search initiated by a remote cache completed with success.";
        String handlingNetsearchesTimeDesc = "Total time spent handling successful network searches for remote caches.";
        String handlingNetsearchesFailedDesc = "Total number of times handling a network search initiated by a remote cache failed without success.";
        String handlingNetsearchesFailedTimeDesc = "Total time spent handling failed network searches for remote caches.";
        String previouslySeenEventsDesc = "The number of previously seen events ignored by the event tracker.";
        type = f.createType("CachePerfStats", "Statistics about GemFire cache performance", new StatisticDescriptor[]{f.createLongGauge("loadsInProgress", "Current number of threads in this cache doing a cache load.", "operations"), f.createLongCounter("loadsCompleted", "Total number of times a load on this cache has completed (as a result of either a local get() or a remote netload).", "operations"), f.createLongCounter("loadTime", "Total time spent invoking loaders on this cache.", "nanoseconds", false), f.createLongGauge("netloadsInProgress", "Current number of threads doing a network load initiated by a get() in this cache.", "operations"), f.createLongCounter("netloadsCompleted", "Total number of times a network load initiated on this cache has completed.", "operations"), f.createLongCounter("netloadTime", "Total time spent doing network loads on this cache.", "nanoseconds", false), f.createLongGauge("netsearchesInProgress", "Current number of threads doing a network search initiated by a get() in this cache.", "operations"), f.createLongCounter("netsearchesCompleted", "Total number of times network searches initiated by this cache have completed.", "operations"), f.createLongCounter("netsearchTime", "Total time spent doing network searches for cache values.", "nanoseconds"), f.createLongGauge("cacheWriterCallsInProgress", "Current number of threads doing a cache writer call.", "operations"), f.createLongCounter("cacheWriterCallsCompleted", "Total number of times a cache writer call has completed.", "operations"), f.createLongCounter("cacheWriterCallTime", "Total time spent doing cache writer calls.", "nanoseconds"), f.createLongGauge("cacheListenerCallsInProgress", "Current number of threads doing a cache listener call.", "operations"), f.createLongCounter("cacheListenerCallsCompleted", "Total number of times a cache listener call has completed.", "operations"), f.createLongCounter("cacheListenerCallTime", "Total time spent doing cache listener calls.", "nanoseconds"), f.createLongGauge("indexUpdateInProgress", "Current number of ops in progress", "operations"), f.createLongCounter("indexUpdateCompleted", "Total number of ops that have completed", "operations"), f.createLongCounter("indexUpdateTime", "Total amount of time spent doing this op", "nanoseconds"), f.createLongGauge("indexInitializationInProgress", "Current number of index initializations in progress", "operations"), f.createLongCounter("indexInitializationCompleted", "Total number of index initializations that have completed", "operations"), f.createLongCounter("indexInitializationTime", "Total amount of time spent initializing indexes", "nanoseconds"), f.createLongGauge("getInitialImagesInProgress", "Current number of getInitialImage operations currently in progress.", "operations"), f.createLongCounter("getInitialImagesCompleted", "Total number of times getInitialImages (both delta and full GII) initiated by this cache have completed.", "operations"), f.createLongCounter("deltaGetInitialImagesCompleted", "Total number of times delta getInitialImages initiated by this cache have completed.", "operations"), f.createLongCounter("getInitialImageTime", "Total time spent doing getInitialImages for region creation.", "nanoseconds"), f.createLongCounter("getInitialImageKeysReceived", "Total number of keys received while doing getInitialImage operations.", "keys"), f.createLongGauge("regions", "The current number of regions in the cache.", "regions"), f.createLongGauge("partitionedRegions", "The current number of partitioned regions in the cache.", "partitionedRegions"), f.createLongCounter("destroys", "The total number of times a cache object entry has been destroyed in this cache.", "operations"), f.createLongCounter("updates", "The total number of updates originating remotely that have been applied to this cache.", "operations"), f.createLongCounter("updateTime", "Total time spent performing an update.", "nanoseconds"), f.createLongCounter("invalidates", "The total number of times an existing cache object entry value in this cache has been invalidated", "operations"), f.createLongCounter("gets", "The total number of times a successful get has been done on this cache.", "operations"), f.createLongCounter("misses", "Total number of times a get on the cache did not find a value already in local memory. The number of hits (i.e. gets that did not miss) can be calculated by subtracting misses from gets.", "operations"), f.createLongCounter("creates", "The total number of times an entry is added to this cache.", "operations"), f.createLongCounter("puts", "The total number of times an entry is added or replaced in this cache as a result of a local operation (put(), create(), or get() which results in load, netsearch, or netloading a value). Note that this only counts puts done explicitly on this cache. It does not count updates pushed from other caches.", "operations"), f.createLongCounter("putTime", "Total time spent adding or replacing an entry in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).", "nanoseconds", false), f.createLongCounter("putalls", "The total number of times a map is added or replaced in this cache as a result of a local operation. Note that this only counts putAlls done explicitly on this cache. It does not count updates pushed from other caches.", "operations"), f.createLongCounter("putallTime", "Total time spent replacing a map in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).", "nanoseconds", false), f.createLongCounter("removeAlls", "The total number of removeAll operations that originated in this cache. Note that this only counts removeAlls done explicitly on this cache. It does not count removes pushed from other caches.", "operations"), f.createLongCounter("removeAllTime", "Total time spent performing removeAlls that originated in this cache. This includes time spent waiting for the removeAll to be done in remote caches (if required).", "nanoseconds", false), f.createLongCounter("getTime", "Total time spent doing get operations from this cache (including netsearch and netload)", "nanoseconds", false), f.createLongGauge("eventQueueSize", "The number of cache events waiting to be processed.", "messages"), f.createLongGauge("eventQueueThrottleCount", "The total number of times a thread was delayed in adding an event to the event queue.", "delays"), f.createLongCounter("eventQueueThrottleTime", "The total amount of time, in nanoseconds, spent delayed by the event queue throttle.", "nanoseconds", false), f.createLongGauge("eventThreads", "The number of threads currently processing events.", "threads"), f.createLongCounter("queryExecutions", "Total number of times some query has been executed", "operations"), f.createLongCounter("queryExecutionTime", "Total time spent executing queries", "nanoseconds"), f.createLongCounter("queryResultsHashCollisions", "Total number of times an hash code collision occurred when inserting an object into an OQL result set or rehashing it", "operations"), f.createLongCounter("queryResultsHashCollisionProbeTime", "Total time spent probing the hashtable in an OQL result set due to hash code collisions, includes reads, writes, and rehashes", "nanoseconds"), f.createLongCounter("partitionedRegionQueryRetries", "Total number of times an OQL Query on a Partitioned Region had to be retried", "retries"), f.createLongCounter("txCommits", "Total number times a transaction commit has succeeded.", "commits"), f.createLongCounter("txCommitChanges", "Total number of changes made by committed transactions.", "changes"), f.createLongCounter("txCommitTime", "The total amount of time, in nanoseconds, spent doing successful transaction commits.", "nanoseconds", false), f.createLongCounter("txSuccessLifeTime", "The total amount of time, in nanoseconds, spent in a transaction before a successful commit. The time measured starts at transaction begin and ends when commit is called.", "nanoseconds", false), f.createLongCounter("txFailures", "Total number times a transaction commit has failed.", "failures"), f.createLongCounter("txFailureChanges", "Total number of changes lost by failed transactions.", "changes"), f.createLongCounter("txFailureTime", "The total amount of time, in nanoseconds, spent doing failed transaction commits.", "nanoseconds", false), f.createLongCounter("txFailedLifeTime", "The total amount of time, in nanoseconds, spent in a transaction before a failed commit. The time measured starts at transaction begin and ends when commit is called.", "nanoseconds", false), f.createLongCounter("txRollbacks", "Total number times a transaction has been explicitly rolled back.", "rollbacks"), f.createLongCounter("txRollbackChanges", "Total number of changes lost by explicit transaction rollbacks.", "changes"), f.createLongCounter("txRollbackTime", "The total amount of time, in nanoseconds, spent doing explicit transaction rollbacks.", "nanoseconds", false), f.createLongCounter("txRollbackLifeTime", "The total amount of time, in nanoseconds, spent in a transaction before an explicit rollback. The time measured starts at transaction begin and ends when rollback is called.", "nanoseconds", false), f.createLongCounter("txConflictCheckTime", "The total amount of time, in nanoseconds, spent doing conflict checks during transaction commit", "nanoseconds", false), f.createLongGauge("reliableQueuedOps", "Current number of cache operations queued for distribution to required roles.", "operations"), f.createLongGauge("reliableQueueSize", "Current size in megabytes of disk used to queue for distribution to required roles.", "megabytes"), f.createLongGauge("reliableQueueMax", "Maximum size in megabytes allotted for disk usage to queue for distribution to required roles.", "megabytes"), f.createLongGauge("reliableRegions", "Current number of regions configured for reliability.", "regions"), f.createLongGauge("reliableRegionsMissing", "Current number regions configured for reliability that are missing required roles.", "regions"), f.createLongGauge("reliableRegionsQueuing", "Current number regions configured for reliability that are queuing for required roles.", "regions"), f.createLongGauge("reliableRegionsMissingFullAccess", "Current number of regions configured for reliablity that are missing require roles with full access", "regions"), f.createLongGauge("reliableRegionsMissingLimitedAccess", "Current number of regions configured for reliablity that are missing required roles with Limited access", "regions"), f.createLongGauge("reliableRegionsMissingNoAccess", "Current number of regions configured for reliablity that are missing required roles with No access", "regions"), f.createLongGauge("entries", "Current number of entries in the cache. This does not include any entries that are tombstones. See tombstoneCount.", "entries"), f.createLongCounter("eventsQueued", "Number of events attached to other events for callback invocation", "events"), f.createLongCounter("retries", "Number of times a concurrent destroy followed by a create has caused an entry operation to need to retry.", "operations"), f.createLongCounter("clears", "The total number of times a clear has been done on this cache.", "operations"), f.createLongGauge("diskTasksWaiting", "Current number of disk tasks (oplog compactions, asynchronous recoveries, etc) that are waiting for a thread to run the operation", "operations"), f.createLongCounter("conflatedEvents", "Number of events not delivered due to conflation.  Typically this means that the event arrived after a later event was already applied to the cache.", "operations"), f.createLongGauge("tombstones", "Number of destroyed entries that are retained for concurrent modification detection", "entries"), f.createLongCounter("tombstoneGCs", "Number of garbage-collections performed on destroyed entries", "operations"), f.createLongGauge("replicatedTombstonesSize", "Amount of memory consumed by destroyed entries in replicated or partitioned regions", "bytes"), f.createLongGauge("nonReplicatedTombstonesSize", "Amount of memory consumed by destroyed entries in non-replicated regions", "bytes"), f.createLongCounter("clearTimeouts", "Number of timeouts waiting for events concurrent to a clear() operation to be received and applied before performing the clear()", "timeouts"), f.createLongGauge("evictorJobsStarted", "Number of evictor jobs started", "jobs"), f.createLongGauge("evictorJobsCompleted", "Number of evictor jobs completed", "jobs"), f.createLongGauge("evictorQueueSize", "Number of jobs waiting to be picked up by evictor threads", "jobs"), f.createLongCounter("evictWorkTime", "Total time spent doing eviction work in background threads", "nanoseconds", false), f.createLongCounter("metaDataRefreshCount", "Total number of times the meta data is refreshed due to hopping observed.", "refreshes", false), f.createLongCounter("deltaUpdates", "The total number of times entries in this cache are updated through delta bytes.", "operations"), f.createLongCounter("deltaUpdatesTime", "Total time spent applying the received delta bytes to entries in this cache.", "nanoseconds", false), f.createLongCounter("deltaFailedUpdates", "The total number of times entries in this cache failed to be updated through delta bytes.", "operations"), f.createLongCounter("deltasPrepared", "The total number of times delta was prepared in this cache.", "operations"), f.createLongCounter("deltasPreparedTime", "Total time spent preparing delta bytes in this cache.", "nanoseconds", false), f.createLongCounter("deltasSent", "The total number of times delta was sent to remote caches. This excludes deltas sent from server to client.", "operations"), f.createLongCounter("deltaFullValuesSent", "The total number of times a full value was sent to a remote cache.", "operations"), f.createLongCounter("deltaFullValuesRequested", "The total number of times a full value was requested by this cache.", "operations"), f.createLongCounter("importedEntries", "The total number of entries imported from a snapshot file.", "entries"), f.createLongCounter("importTime", "The total time spent importing entries from a snapshot file.", "nanoseconds"), f.createLongCounter("exportedEntries", "The total number of entries exported into a snapshot file.", "entries"), f.createLongCounter("exportTime", "The total time spent exporting entries into a snapshot file.", "nanoseconds"), f.createLongCounter("compressTime", "The total time spent compressing data.", "nanoseconds"), f.createLongCounter("decompressTime", "The total time spent decompressing data.", "nanoseconds"), f.createLongCounter("compressions", "The total number of compression operations.", "operations"), f.createLongCounter("decompressions", "The total number of decompression operations.", "operations"), f.createLongCounter("preCompressedBytes", "The total number of bytes before compressing.", "bytes"), f.createLongCounter("postCompressedBytes", "The total number of bytes after compressing.", "bytes"), f.createLongCounter("evictByCriteria_evictions", "The total number of entries evicted", "operations"), f.createLongCounter("evictByCriteria_evictionTime", "Time taken for eviction process", "nanoseconds"), f.createLongCounter("evictByCriteria_evictionsInProgress", "Total number of evictions in progress", "operations"), f.createLongCounter("evictByCriteria_evaluations", "Total number of evaluations for eviction", "operations"), f.createLongCounter("evictByCriteria_evaluationTime", "Total time taken for evaluation of user expression during eviction", "nanoseconds"), f.createLongGauge("handlingNetsearchesInProgress", "Current number of threads handling a network search initiated by a remote cache.", "operations"), f.createLongCounter("handlingNetsearchesCompleted", "Total number of times handling a network search initiated by a remote cache completed with success.", "operations"), f.createLongCounter("handlingNetsearchesTime", "Total time spent handling successful network searches for remote caches.", "nanoseconds"), f.createLongCounter("handlingNetsearchesFailed", "Total number of times handling a network search initiated by a remote cache failed without success.", "operations"), f.createLongCounter("handlingNetsearchesFailedTime", "Total time spent handling failed network searches for remote caches.", "nanoseconds"), f.createLongCounter("previouslySeenEvents", "The number of previously seen events ignored by the event tracker.", "events")});
        loadsInProgressId = type.nameToId("loadsInProgress");
        loadsCompletedId = type.nameToId("loadsCompleted");
        loadTimeId = type.nameToId("loadTime");
        netloadsInProgressId = type.nameToId("netloadsInProgress");
        netloadsCompletedId = type.nameToId("netloadsCompleted");
        netloadTimeId = type.nameToId("netloadTime");
        netsearchesInProgressId = type.nameToId("netsearchesInProgress");
        netsearchesCompletedId = type.nameToId("netsearchesCompleted");
        netsearchTimeId = type.nameToId("netsearchTime");
        cacheWriterCallsInProgressId = type.nameToId("cacheWriterCallsInProgress");
        cacheWriterCallsCompletedId = type.nameToId("cacheWriterCallsCompleted");
        cacheWriterCallTimeId = type.nameToId("cacheWriterCallTime");
        cacheListenerCallsInProgressId = type.nameToId("cacheListenerCallsInProgress");
        cacheListenerCallsCompletedId = type.nameToId("cacheListenerCallsCompleted");
        cacheListenerCallTimeId = type.nameToId("cacheListenerCallTime");
        indexUpdateInProgressId = type.nameToId("indexUpdateInProgress");
        indexUpdateCompletedId = type.nameToId("indexUpdateCompleted");
        indexUpdateTimeId = type.nameToId("indexUpdateTime");
        indexInitializationTimeId = type.nameToId("indexInitializationTime");
        indexInitializationInProgressId = type.nameToId("indexInitializationInProgress");
        indexInitializationCompletedId = type.nameToId("indexInitializationCompleted");
        getInitialImagesInProgressId = type.nameToId("getInitialImagesInProgress");
        getInitialImagesCompletedId = type.nameToId("getInitialImagesCompleted");
        deltaGetInitialImagesCompletedId = type.nameToId("deltaGetInitialImagesCompleted");
        getInitialImageTimeId = type.nameToId("getInitialImageTime");
        getInitialImageKeysReceivedId = type.nameToId("getInitialImageKeysReceived");
        regionsId = type.nameToId("regions");
        partitionedRegionsId = type.nameToId("partitionedRegions");
        destroysId = type.nameToId("destroys");
        createsId = type.nameToId("creates");
        putsId = type.nameToId("puts");
        putTimeId = type.nameToId("putTime");
        putAllsId = type.nameToId("putalls");
        putAllTimeId = type.nameToId("putallTime");
        removeAllsId = type.nameToId("removeAlls");
        removeAllTimeId = type.nameToId("removeAllTime");
        updatesId = type.nameToId("updates");
        updateTimeId = type.nameToId("updateTime");
        invalidatesId = type.nameToId("invalidates");
        getsId = type.nameToId("gets");
        getTimeId = type.nameToId("getTime");
        missesId = type.nameToId("misses");
        eventQueueSizeId = type.nameToId("eventQueueSize");
        eventQueueThrottleTimeId = type.nameToId("eventQueueThrottleTime");
        eventQueueThrottleCountId = type.nameToId("eventQueueThrottleCount");
        eventThreadsId = type.nameToId("eventThreads");
        queryExecutionsId = type.nameToId("queryExecutions");
        queryExecutionTimeId = type.nameToId("queryExecutionTime");
        queryResultsHashCollisionsId = type.nameToId("queryResultsHashCollisions");
        queryResultsHashCollisionProbeTimeId = type.nameToId("queryResultsHashCollisionProbeTime");
        partitionedRegionQueryRetriesId = type.nameToId("partitionedRegionQueryRetries");
        txSuccessLifeTimeId = type.nameToId("txSuccessLifeTime");
        txFailedLifeTimeId = type.nameToId("txFailedLifeTime");
        txRollbackLifeTimeId = type.nameToId("txRollbackLifeTime");
        txCommitsId = type.nameToId("txCommits");
        txFailuresId = type.nameToId("txFailures");
        txRollbacksId = type.nameToId("txRollbacks");
        txCommitTimeId = type.nameToId("txCommitTime");
        txFailureTimeId = type.nameToId("txFailureTime");
        txRollbackTimeId = type.nameToId("txRollbackTime");
        txCommitChangesId = type.nameToId("txCommitChanges");
        txFailureChangesId = type.nameToId("txFailureChanges");
        txRollbackChangesId = type.nameToId("txRollbackChanges");
        txConflictCheckTimeId = type.nameToId("txConflictCheckTime");
        reliableQueuedOpsId = type.nameToId("reliableQueuedOps");
        reliableQueueSizeId = type.nameToId("reliableQueueSize");
        reliableQueueMaxId = type.nameToId("reliableQueueMax");
        reliableRegionsId = type.nameToId("reliableRegions");
        reliableRegionsMissingId = type.nameToId("reliableRegionsMissing");
        reliableRegionsQueuingId = type.nameToId("reliableRegionsQueuing");
        reliableRegionsMissingFullAccessId = type.nameToId("reliableRegionsMissingFullAccess");
        reliableRegionsMissingLimitedAccessId = type.nameToId("reliableRegionsMissingLimitedAccess");
        reliableRegionsMissingNoAccessId = type.nameToId("reliableRegionsMissingNoAccess");
        entryCountId = type.nameToId("entries");
        eventsQueuedId = type.nameToId("eventsQueued");
        retriesId = type.nameToId("retries");
        clearsId = type.nameToId("clears");
        diskTasksWaitingId = type.nameToId("diskTasksWaiting");
        evictorJobsStartedId = type.nameToId("evictorJobsStarted");
        evictorJobsCompletedId = type.nameToId("evictorJobsCompleted");
        evictorQueueSizeId = type.nameToId("evictorQueueSize");
        evictWorkTimeId = type.nameToId("evictWorkTime");
        metaDataRefreshCountId = type.nameToId("metaDataRefreshCount");
        conflatedEventsId = type.nameToId("conflatedEvents");
        tombstoneCountId = type.nameToId("tombstones");
        tombstoneGCCountId = type.nameToId("tombstoneGCs");
        tombstoneOverhead1Id = type.nameToId("replicatedTombstonesSize");
        tombstoneOverhead2Id = type.nameToId("nonReplicatedTombstonesSize");
        clearTimeoutsId = type.nameToId("clearTimeouts");
        deltaUpdatesId = type.nameToId("deltaUpdates");
        deltaUpdatesTimeId = type.nameToId("deltaUpdatesTime");
        deltaFailedUpdatesId = type.nameToId("deltaFailedUpdates");
        deltasPreparedId = type.nameToId("deltasPrepared");
        deltasPreparedTimeId = type.nameToId("deltasPreparedTime");
        deltasSentId = type.nameToId("deltasSent");
        deltaFullValuesSentId = type.nameToId("deltaFullValuesSent");
        deltaFullValuesRequestedId = type.nameToId("deltaFullValuesRequested");
        importedEntriesCountId = type.nameToId("importedEntries");
        importTimeId = type.nameToId("importTime");
        exportedEntriesCountId = type.nameToId("exportedEntries");
        exportTimeId = type.nameToId("exportTime");
        compressionCompressTimeId = type.nameToId("compressTime");
        compressionDecompressTimeId = type.nameToId("decompressTime");
        compressionCompressionsId = type.nameToId("compressions");
        compressionDecompressionsId = type.nameToId("decompressions");
        compressionPreCompressedBytesId = type.nameToId("preCompressedBytes");
        compressionPostCompressedBytesId = type.nameToId("postCompressedBytes");
        handlingNetsearchesInProgressId = type.nameToId("handlingNetsearchesInProgress");
        handlingNetsearchesCompletedId = type.nameToId("handlingNetsearchesCompleted");
        handlingNetsearchesTimeId = type.nameToId("handlingNetsearchesTime");
        handlingNetsearchesFailedId = type.nameToId("handlingNetsearchesFailed");
        handlingNetsearchesFailedTimeId = type.nameToId("handlingNetsearchesFailedTime");
        previouslySeenEventsId = type.nameToId("previouslySeenEvents");
    }
}

