/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.geode.cache.query.internal.Bag;
import org.apache.geode.cache.query.internal.Ordered;
import org.apache.geode.cache.query.internal.types.CollectionTypeImpl;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.CachePerfStats;

public class SortedResultsBag<E>
extends Bag
implements Ordered {
    private final Map<E, Integer> sortedMap;
    private final boolean orderedDataAddition;
    private final boolean emitNullAtStart;

    public SortedResultsBag(Comparator<E> comparator, boolean nullAtStart) {
        this.sortedMap = new TreeMap<E, Integer>(comparator);
        this.emitNullAtStart = nullAtStart;
        this.orderedDataAddition = false;
    }

    public SortedResultsBag(Comparator<E> comparator, ObjectType elementType, boolean nullAtStart) {
        this.sortedMap = new TreeMap<E, Integer>(comparator);
        this.setElementType(elementType);
        this.emitNullAtStart = nullAtStart;
        this.orderedDataAddition = false;
    }

    public SortedResultsBag(Comparator<E> comparator, ObjectType elementType, CachePerfStats stats, boolean nullAtStart) {
        super(elementType, stats);
        this.sortedMap = new TreeMap<E, Integer>(comparator);
        this.emitNullAtStart = nullAtStart;
        this.orderedDataAddition = false;
    }

    public SortedResultsBag(Comparator<E> comparator, CachePerfStats stats, boolean nullAtStart) {
        super(stats);
        this.sortedMap = new TreeMap<E, Integer>(comparator);
        this.emitNullAtStart = nullAtStart;
        this.orderedDataAddition = false;
    }

    public SortedResultsBag(CachePerfStats stats, boolean nullAtStart) {
        super(stats);
        this.sortedMap = new LinkedHashMap<E, Integer>();
        this.orderedDataAddition = true;
        this.emitNullAtStart = nullAtStart;
    }

    public SortedResultsBag(boolean nullAtStart) {
        this.sortedMap = new LinkedHashMap<E, Integer>();
        this.orderedDataAddition = true;
        this.emitNullAtStart = nullAtStart;
    }

    public SortedResultsBag(ObjectType elementType, boolean nullAtStart) {
        this.sortedMap = new LinkedHashMap<E, Integer>();
        this.orderedDataAddition = true;
        this.setElementType(elementType);
        this.emitNullAtStart = nullAtStart;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    protected int mapGet(Object element) {
        Integer count = this.sortedMap.get(element);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    protected boolean mapContainsKey(Object element) {
        return this.sortedMap.containsKey(element);
    }

    @Override
    protected void mapPut(Object element, int count) {
        this.sortedMap.put(element, count);
    }

    @Override
    protected int mapSize() {
        return this.sortedMap.size();
    }

    @Override
    protected int mapRemove(Object element) {
        Integer count = this.sortedMap.remove(element);
        if (count == null) {
            return 0;
        }
        return count;
    }

    @Override
    protected void mapClear() {
        this.sortedMap.clear();
    }

    @Override
    protected Object getMap() {
        return this.sortedMap;
    }

    @Override
    protected int mapHashCode() {
        return this.sortedMap.hashCode();
    }

    @Override
    protected boolean mapEmpty() {
        return this.sortedMap.isEmpty();
    }

    @Override
    protected Iterator mapEntryIterator() {
        return this.sortedMap.entrySet().iterator();
    }

    @Override
    protected Iterator mapKeyIterator() {
        return this.sortedMap.keySet().iterator();
    }

    @Override
    protected Object keyFromEntry(Object entry) {
        Map.Entry mapEntry = (Map.Entry)entry;
        return mapEntry.getKey();
    }

    @Override
    protected Integer valueFromEntry(Object entry) {
        Map.Entry mapEntry = (Map.Entry)entry;
        return (Integer)mapEntry.getValue();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(SortedResultsBag.class, this.elementType);
    }

    @Override
    public Comparator comparator() {
        return this.orderedDataAddition ? null : ((SortedMap)this.sortedMap).comparator();
    }

    @Override
    public void setElementType(ObjectType elementType) {
        this.elementType = elementType;
    }

    @Override
    public boolean dataPreordered() {
        return this.orderedDataAddition;
    }

    @Override
    protected boolean nullOutputAtBegining() {
        return this.emitNullAtStart;
    }
}

