/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledBindArgument;
import org.apache.geode.cache.query.internal.CompiledLike;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.IndexConditioningHelper;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.Indexable;
import org.apache.geode.cache.query.internal.LinkedResultSet;
import org.apache.geode.cache.query.internal.LinkedStructSet;
import org.apache.geode.cache.query.internal.MapIndexable;
import org.apache.geode.cache.query.internal.Negatable;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.SortedResultsBag;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.AbstractMapIndex;
import org.apache.geode.cache.query.internal.index.IndexData;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.internal.parse.OQLLexerTokenTypes;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxString;

public class CompiledComparison
extends AbstractCompiledValue
implements Negatable,
OQLLexerTokenTypes,
Indexable {
    public final CompiledValue _left;
    public final CompiledValue _right;
    private int _operator;

    CompiledComparison(CompiledValue left, CompiledValue right, int op) {
        Support.Assert(op == 22 || op == 18 || op == 23 || op == 19 || op == 13 || op == 20, String.valueOf(op));
        this._left = left;
        this._right = right;
        this._operator = op;
    }

    @Override
    public List getChildren() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>();
        list.add(this._left);
        list.add(this._right);
        return list;
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object left = this._left.evaluate(context);
        Object right = this._right.evaluate(context);
        if (context.isCqQueryContext() && left instanceof Region.Entry) {
            try {
                left = ((Region.Entry)left).getValue();
            }
            catch (EntryDestroyedException ex) {
                left = null;
            }
        }
        if (context.isCqQueryContext() && right instanceof Region.Entry) {
            try {
                right = ((Region.Entry)right).getValue();
            }
            catch (EntryDestroyedException ex) {
                right = null;
            }
        }
        if (left == null || right == null) {
            return TypeUtils.compare(left, right, this._operator);
        }
        if (!context.getCache().getPdxReadSerialized()) {
            if (left instanceof PdxInstance && !(right instanceof PdxInstance) && ((PdxInstance)left).getClassName().equals(right.getClass().getName())) {
                left = ((PdxInstance)left).getObject();
            } else if (right instanceof PdxInstance && !(left instanceof PdxInstance) && ((PdxInstance)right).getClassName().equals(left.getClass().getName())) {
                right = ((PdxInstance)right).getObject();
            }
        }
        if (left instanceof PdxString) {
            if (right instanceof String) {
                switch (this._right.getType()) {
                    case -4: {
                        right = ((CompiledLiteral)this._right).getSavedPdxString();
                        break;
                    }
                    case 48: {
                        right = ((CompiledBindArgument)this._right).getSavedPdxString(context);
                        break;
                    }
                    case -5: 
                    case -2: {
                        right = new PdxString((String)right);
                    }
                }
            }
        } else if (right instanceof PdxString) {
            switch (this._left.getType()) {
                case -4: {
                    left = ((CompiledLiteral)this._left).getSavedPdxString();
                    break;
                }
                case 48: {
                    left = ((CompiledBindArgument)this._left).getSavedPdxString(context);
                    break;
                }
                case -5: 
                case -2: {
                    left = new PdxString((String)left);
                }
            }
        }
        return TypeUtils.compare(left, right, this._operator);
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evaluateProjection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!this.isDependentOnCurrentScope(context)) {
            return super.filterEvaluate(context, intermediateResults);
        }
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        Support.Assert(idxInfo != null, "a comparison that is dependent, not indexed, and filter evaluated is not possible");
        if (idxInfo.length == 1) {
            return this.singleBaseCollectionFilterEvaluate(context, intermediateResults, completeExpansionNeeded, iterOperands, idxInfo[0], indpndntItrs, isIntersection, conditioningNeeded, evaluateProjection);
        }
        Support.Assert(idxInfo.length == 2, "A Composite CompiledComparison which is filter evaluatable needs to have two indexes");
        return this.doubleBaseCollectionFilterEvaluate(context, intermediateResults, completeExpansionNeeded, iterOperands, idxInfo, indpndntItrs);
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        RuntimeIterator[] runtimeIteratorArray;
        RuntimeIterator indpndntItr = null;
        List currentScopeIndpndntItrs = context.getAllIndependentIteratorsOfCurrentScope();
        Set rntmItrs = QueryUtils.getCurrentScopeUltimateRuntimeIteratorsIfAny(this, context);
        if (rntmItrs.size() == 1 && currentScopeIndpndntItrs.size() == 1) {
            indpndntItr = (RuntimeIterator)rntmItrs.iterator().next();
        }
        if (indpndntItr != null) {
            RuntimeIterator[] runtimeIteratorArray2 = new RuntimeIterator[1];
            runtimeIteratorArray = runtimeIteratorArray2;
            runtimeIteratorArray2[0] = indpndntItr;
        } else {
            runtimeIteratorArray = null;
        }
        return this.filterEvaluate(context, intermediateResults, true, null, runtimeIteratorArray, true, this.isConditioningNeededForIndex(indpndntItr, context, true), true);
    }

    @Override
    public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.assertionFailed(" This auxFilterEvaluate of CompiledComparison should never have got invoked.");
        return null;
    }

    @Override
    public void negate() {
        this._operator = this.inverseOperator(this._operator);
    }

    @Override
    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        PlanInfo result = new PlanInfo();
        IndexInfo[] indexInfo = this.getIndexInfo(context);
        if (indexInfo == null) {
            return result;
        }
        for (IndexInfo info : indexInfo) {
            result.indexes.add(info._index);
        }
        result.evalAsFilter = true;
        String preferredCondn = (String)context.cacheGet("preferred_index_condition");
        if (preferredCondn != null && indexInfo[0]._index.getCanonicalizedIndexedExpression().equals(preferredCondn) && indexInfo[0]._index.getType() != IndexType.PRIMARY_KEY) {
            result.isPreferred = true;
        }
        return result;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        context.addDependencies(this, this._left.computeDependencies(context));
        return context.addDependencies(this, this._right.computeDependencies(context));
    }

    int reflectOnOperator(CompiledValue key) {
        int operator = this._operator;
        if (key == this._left) {
            operator = this.reflectOperator(operator);
        }
        return operator;
    }

    @Override
    public boolean isRangeEvaluatable() {
        return !(this._left instanceof MapIndexable) && !(this._right instanceof MapIndexable);
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryExecutionContext qcontext;
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        if (idxInfo != null && idxInfo.length > 1) {
            return 0;
        }
        if (idxInfo == null) {
            return 1;
        }
        assert (idxInfo.length == 1);
        Object key = idxInfo[0].evaluateIndexKey(context);
        if (key != null && key.equals(QueryService.UNDEFINED)) {
            return 0;
        }
        if (context instanceof QueryExecutionContext && (qcontext = (QueryExecutionContext)context).isHinted(idxInfo[0]._index.getName())) {
            return qcontext.getHintSize(idxInfo[0]._index.getName());
        }
        int op = this.reflectOnOperator(idxInfo[0]._key());
        return idxInfo[0]._index.getSizeEstimate(key, op, idxInfo[0]._matchLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectResults singleBaseCollectionFilterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, IndexInfo indexInfo, RuntimeIterator[] indpndntItr, boolean isIntersection, boolean conditioningNeeded, boolean evaluateProj) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        ObjectType resultType = indexInfo._index.getResultSetType();
        int indexFieldsSize = -1;
        Collection set = null;
        boolean createEmptySet = false;
        Object key = indexInfo.evaluateIndexKey(context);
        createEmptySet = key != null && key.equals(QueryService.UNDEFINED);
        indexFieldsSize = resultType instanceof StructType ? ((StructTypeImpl)resultType).getFieldNames().length : 1;
        int op = this.reflectOnOperator(indexInfo._key());
        QueryObserver observer = QueryObserverHolder.getInstance();
        List projAttrib = null;
        try {
            if (!createEmptySet) {
                observer.beforeIndexLookup(indexInfo._index, op, key);
                context.cachePut("index_info", indexInfo);
            }
            boolean useLinkedDataStructure = false;
            boolean nullValuesAtStart = true;
            Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
            if (orderByClause != null && orderByClause.booleanValue()) {
                List orderByAttrs = (List)context.cacheGet("orderby");
                useLinkedDataStructure = orderByAttrs.size() == 1;
                boolean bl = nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
            }
            if (!conditioningNeeded) {
                ObjectType projResultType;
                ObjectType objectType = projResultType = evaluateProj ? (ObjectType)context.cacheGet("result_type") : null;
                if (projResultType != null) {
                    resultType = projResultType;
                    projAttrib = (List)context.cacheGet("projection");
                    context.cachePut("result_type", Boolean.TRUE);
                }
                if (isIntersection) {
                    if (resultType instanceof StructType) {
                        context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                        set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                        indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
                    } else {
                        context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                        set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                        indexFieldsSize = 1;
                    }
                } else if (intermediateResults != null && context.getQuery() != null && ((DefaultQuery)context.getQuery()).getSelect().isDistinct()) {
                    set = intermediateResults;
                    intermediateResults = null;
                } else if (resultType instanceof StructType) {
                    context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                    set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                    indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
                } else {
                    context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                    set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                    indexFieldsSize = 1;
                }
                if (!createEmptySet) {
                    indexInfo._index.query(key, op, set, iterOperands, indpndntItr != null ? indpndntItr[0] : null, context, projAttrib, intermediateResults, isIntersection);
                }
            } else {
                if (resultType instanceof StructType) {
                    context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                    set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                    indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
                } else {
                    context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                    set = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                    indexFieldsSize = 1;
                }
                if (!createEmptySet) {
                    indexInfo._index.query(key, op, set, context);
                }
            }
            if (!createEmptySet) {
                observer.afterIndexLookup(set);
            }
        }
        catch (Throwable throwable) {
            if (!createEmptySet) {
                observer.afterIndexLookup(set);
            }
            throw throwable;
        }
        if (conditioningNeeded) {
            return QueryUtils.getConditionedIndexResults(set, indexInfo, context, indexFieldsSize, completeExpansionNeeded, iterOperands, indpndntItr);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectResults doubleBaseCollectionFilterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, IndexInfo[] indxInfo, RuntimeIterator[] indpdntItrs) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        context.cachePut("index_info", indxInfo);
        if ((intermediateResults == null || intermediateResults.isEmpty()) && (indpdntItrs != null || completeExpansionNeeded)) {
            Support.Assert(this._operator == 13, "A relationship index is not usable for any condition other than equality");
            List data = null;
            try {
                observer.beforeIndexLookup(indxInfo[0]._index, this._operator, null);
                observer.beforeIndexLookup(indxInfo[1]._index, this._operator, null);
                data = context.getBucketList() != null ? QueryUtils.queryEquijoinConditionBucketIndexes(indxInfo, context) : indxInfo[0]._index.queryEquijoinCondition(indxInfo[1]._index, context);
                observer.afterIndexLookup(data);
            }
            catch (Throwable throwable) {
                observer.afterIndexLookup(data);
                throw throwable;
            }
            return QueryUtils.getConditionedRelationshipIndexResultsExpandedToTopOrCGJLevel(data, indxInfo, context, completeExpansionNeeded, iterOperands, indpdntItrs);
        }
        return QueryUtils.getRelationshipIndexResultsMergedWithIntermediateResults(intermediateResults, indxInfo, context, completeExpansionNeeded, iterOperands, indpdntItrs);
    }

    public static String getSimpleClassName(Class cls) {
        return cls.getName().substring(cls.getPackage().getName().length() + 1);
    }

    @Override
    public IndexInfo[] getIndexInfo(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        IndexInfo[] indexInfo = this.privGetIndexInfo(context);
        if (indexInfo != null) {
            if (indexInfo == NO_INDEXES_IDENTIFIER) {
                return null;
            }
            return indexInfo;
        }
        if (!IndexUtils.indexesEnabled) {
            return null;
        }
        PathAndKey pAndK = this.getPathAndKey(context);
        IndexInfo[] newIndexInfo = null;
        if (pAndK == null) {
            IndexData[] indexData = QueryUtils.getRelationshipIndexIfAny(this._left, this._right, context, this._operator);
            if (indexData != null) {
                newIndexInfo = new IndexInfo[2];
                for (int i = 0; i < 2; ++i) {
                    newIndexInfo[i] = new IndexInfo(null, i == 0 ? this._left : this._right, indexData[i].getIndex(), indexData[i].getMatchLevel(), indexData[i].getMapping(), i == 0 ? this._operator : this.reflectOperator(this._operator));
                }
            }
        } else {
            CompiledValue path = pAndK._path;
            CompiledValue indexKey = pAndK._key;
            IndexData indexData = this instanceof CompiledLike ? QueryUtils.getAvailableIndexIfAny(path, context, 97) : QueryUtils.getAvailableIndexIfAny(path, context, this._operator);
            if (this.indexCannotBeUsed(context, indexData)) {
                Index prIndex = ((AbstractIndex)indexData.getIndex()).getPRIndex();
                if (prIndex != null) {
                    ((PartitionedIndex)prIndex).releaseIndexReadLockForRemove();
                } else {
                    ((AbstractIndex)indexData.getIndex()).releaseIndexReadLockForRemove();
                }
                return null;
            }
            IndexProtocol index = null;
            if (indexData != null) {
                index = indexData.getIndex();
            }
            if (index != null && index.isValid()) {
                newIndexInfo = new IndexInfo[]{new IndexInfo(indexKey, path, index, indexData.getMatchLevel(), indexData.getMapping(), this.reflectOnOperator(indexKey))};
            }
        }
        if (newIndexInfo != null) {
            this.privSetIndexInfo(newIndexInfo, context);
        } else {
            this.privSetIndexInfo(NO_INDEXES_IDENTIFIER, context);
        }
        return newIndexInfo;
    }

    @VisibleForTesting
    boolean indexCannotBeUsed(ExecutionContext context, IndexData indexData) {
        if (indexData == null) {
            return false;
        }
        if (!(indexData.getIndex() instanceof AbstractMapIndex)) {
            return false;
        }
        if (!((AbstractMapIndex)indexData.getIndex()).getIsAllKeys()) {
            return false;
        }
        if (this._operator == 20) {
            return true;
        }
        try {
            if (this._right != null && this._right instanceof CompiledLiteral && this._right.evaluate(context) == null) {
                return true;
            }
            if (this._left != null && this._left instanceof CompiledLiteral && this._left.evaluate(context) == null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    CompiledValue getKey(ExecutionContext context) throws AmbiguousNameException, TypeMismatchException {
        return this.getPathAndKey((ExecutionContext)context)._key;
    }

    private PathAndKey getPathAndKey(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException {
        CompiledValue indexKey;
        CompiledValue path;
        boolean isRightDependent;
        boolean isLeftDependent = context.isDependentOnCurrentScope(this._left);
        if (!isLeftDependent == !(isRightDependent = context.isDependentOnCurrentScope(this._right))) {
            return null;
        }
        if (!isLeftDependent) {
            path = this._right;
            indexKey = this._left;
        } else {
            path = this._left;
            indexKey = this._right;
        }
        if (indexKey.isDependentOnCurrentScope(context)) {
            return null;
        }
        return new PathAndKey(path, indexKey);
    }

    private IndexInfo[] privGetIndexInfo(ExecutionContext context) {
        return (IndexInfo[])context.cacheGet(this);
    }

    private void privSetIndexInfo(IndexInfo[] indexInfo, ExecutionContext context) {
        context.cachePut(this, indexInfo);
    }

    @Override
    public boolean isProjectionEvaluationAPossibility(ExecutionContext context) {
        return true;
    }

    @Override
    public boolean isLimitApplicableAtIndexLevel(ExecutionContext context) {
        return true;
    }

    @Override
    public boolean isOrderByApplicableAtIndexLevel(ExecutionContext context, String canonicalizedOrderByClause) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.getPlanInfo((ExecutionContext)context).evalAsFilter) {
            PlanInfo pi = this.getPlanInfo(context);
            if (pi.indexes.size() == 1) {
                IndexProtocol ip = (IndexProtocol)pi.indexes.get(0);
                return ip.getCanonicalizedIndexedExpression().equals(canonicalizedOrderByClause) && ip.getType() != IndexType.PRIMARY_KEY && pi.isPreferred;
            }
        }
        return false;
    }

    @Override
    public boolean isConditioningNeededForIndex(RuntimeIterator independentIter, ExecutionContext context, boolean completeExpnsNeeded) throws TypeMismatchException, NameResolutionException {
        IndexConditioningHelper ich = null;
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        int indexFieldsSize = -1;
        boolean conditioningNeeded = true;
        if (idxInfo == null || idxInfo.length > 1) {
            return conditioningNeeded;
        }
        ObjectType indexRsltType = idxInfo[0]._index.getResultSetType();
        indexFieldsSize = indexRsltType instanceof StructType ? ((StructTypeImpl)indexRsltType).getFieldNames().length : 1;
        if (independentIter != null && indexFieldsSize == 1) {
            ich = new IndexConditioningHelper(idxInfo[0], context, indexFieldsSize, completeExpnsNeeded, null, independentIter);
        }
        return ich == null || ich.shufflingNeeded;
    }

    @Override
    public int getOperator() {
        return this._operator;
    }

    @Override
    public boolean isBetterFilter(Filter comparedTo, ExecutionContext context, int thisSize) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isThisBetter;
        block12: {
            int thatOperator;
            int thatSize;
            block11: {
                isThisBetter = true;
                thatSize = comparedTo.getSizeEstimate(context);
                thatOperator = comparedTo.getOperator();
                if (context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasHints()) {
                    return thisSize <= thatSize;
                }
                if (this._operator != 13 && this._operator != 20 && this._operator != 21) break block11;
                switch (thatOperator) {
                    case 13: 
                    case 20: 
                    case 21: {
                        isThisBetter = thisSize <= thatSize;
                        break block12;
                    }
                    case 91: {
                        if (this._operator == 20 || this._operator == 21) {
                            isThisBetter = false;
                        }
                        break block12;
                    }
                    case 18: 
                    case 19: 
                    case 22: 
                    case 23: {
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("The operator type =" + thatOperator + " is unknown");
                    }
                }
            }
            switch (thatOperator) {
                case 13: 
                case 20: 
                case 21: 
                case 91: {
                    isThisBetter = false;
                    break;
                }
                case 18: 
                case 19: 
                case 22: 
                case 23: {
                    isThisBetter = thisSize <= thatSize;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The operator type =" + thatOperator + " is unknown");
                }
            }
        }
        return isThisBetter;
    }

    static class PathAndKey {
        CompiledValue _path;
        CompiledValue _key;

        PathAndKey(CompiledValue path, CompiledValue indexKey) {
            this._path = path;
            this._key = indexKey;
        }
    }
}

