/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal.locator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.cache.client.internal.locator.ClientConnectionRequest;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ClientReplacementRequest
extends ClientConnectionRequest {
    private ServerLocation currentServer;

    public ClientReplacementRequest() {
    }

    public ClientReplacementRequest(ServerLocation currentServer, Set<ServerLocation> excludedServers, String serverGroup) {
        super(excludedServers, serverGroup);
        this.currentServer = currentServer;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.currentServer = new ServerLocation();
        InternalDataSerializer.invokeFromData(this.currentServer, in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        InternalDataSerializer.invokeToData(this.currentServer, out);
    }

    public ServerLocation getCurrentServer() {
        return this.currentServer;
    }

    @Override
    public String toString() {
        return "ClientReplacementRequest{group=" + this.getServerGroup() + ", excluded=" + this.getExcludedServers() + ", currentServer=" + this.getCurrentServer() + "}";
    }

    @Override
    public int getDSFID() {
        return -48;
    }
}

