/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.geode.CancelCriterion;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ProxyCacheCloseOp;
import org.apache.geode.cache.client.internal.ProxyRegion;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.ProxyQueryService;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxInstanceFactory;
import org.apache.geode.pdx.internal.PdxInstanceFactoryImpl;

public class ProxyCache
implements RegionService {
    final InternalCache cache;
    private UserAttributes userAttributes;
    private ProxyQueryService proxyQueryService;
    private boolean isClosed = false;
    private final Stopper stopper = new Stopper();

    public ProxyCache(Properties properties, InternalCache cache, PoolImpl pool) {
        this.userAttributes = new UserAttributes(properties, pool);
        this.cache = cache;
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean keepAlive) {
        if (this.isClosed) {
            return;
        }
        try {
            ArrayList<ProxyCache> proxyCache;
            if (this.proxyQueryService != null) {
                this.proxyQueryService.closeCqs(keepAlive);
            }
            UserAttributes.userAttributes.set(this.userAttributes);
            for (ServerLocation serverLocation : this.userAttributes.getServerToId().keySet()) {
                ProxyCacheCloseOp.executeOn(serverLocation, (ExecutablePool)((Object)this.userAttributes.getPool()), this.userAttributes.getCredentials(), keepAlive);
            }
            ArrayList<ProxyCache> arrayList = proxyCache = ((PoolImpl)this.userAttributes.getPool()).getProxyCacheList();
            synchronized (arrayList) {
                proxyCache.remove(this);
            }
        }
        finally {
            this.isClosed = true;
            this.proxyQueryService = null;
            this.userAttributes.setCredentials(null);
            this.userAttributes = null;
            UserAttributes.userAttributes.set(null);
        }
    }

    @Override
    public QueryService getQueryService() {
        this.preOp();
        if (this.proxyQueryService == null) {
            this.proxyQueryService = new ProxyQueryService(this, this.userAttributes.getPool().getQueryService());
        }
        return this.proxyQueryService;
    }

    @Override
    public JSONFormatter getJsonFormatter() {
        return new JSONFormatter(this);
    }

    @Override
    public <K, V> Region<K, V> getRegion(String path) {
        this.preOp();
        if (this.cache.getRegion(path) == null) {
            return null;
        }
        if (!this.cache.getRegion(path).getAttributes().getDataPolicy().isEmpty()) {
            throw new IllegalStateException("Region's data-policy must be EMPTY when multiuser-authentication is true");
        }
        return new ProxyRegion(this, this.cache.getRegion(path), this.cache.getStatisticsClock());
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public void setProperties(Properties properties) {
        this.preOp();
        this.userAttributes.setCredentials(properties);
    }

    public Properties getProperties() {
        this.preOp();
        return this.userAttributes.getCredentials();
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.preOp();
        this.userAttributes = userAttributes;
    }

    public UserAttributes getUserAttributes() {
        this.preOp();
        return this.userAttributes;
    }

    private void preOp() {
        this.stopper.checkCancelInProgress(null);
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    @Override
    public Set<Region<?, ?>> rootRegions() {
        this.preOp();
        HashSet<ProxyRegion> rootRegions = new HashSet<ProxyRegion>();
        for (Region<?, ?> region : this.cache.rootRegions()) {
            if (region.getAttributes().getDataPolicy().withStorage()) continue;
            rootRegions.add(new ProxyRegion(this, region, this.cache.getStatisticsClock()));
        }
        return Collections.unmodifiableSet(rootRegions);
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        return PdxInstanceFactoryImpl.newCreator(className, true, this.cache);
    }

    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean expectDomainClass) {
        return PdxInstanceFactoryImpl.newCreator(className, expectDomainClass, this.cache);
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        return PdxInstanceFactoryImpl.createPdxEnum(className, enumName, enumOrdinal, this.cache);
    }

    public CacheClosedException getCacheClosedException(String reason) {
        return this.cache.getCacheClosedException(reason);
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            String reason = ProxyCache.this.cache.getCancelCriterion().cancelInProgress();
            if (reason != null) {
                return reason;
            }
            if (ProxyCache.this.isClosed()) {
                return "Authenticated cache view is closed for this user.";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            RuntimeException result = ProxyCache.this.cache.getCancelCriterion().generateCancelledException(e);
            if (result != null) {
                return result;
            }
            if (e == null) {
                return ProxyCache.this.cache.getCacheClosedException(reason);
            }
            try {
                return ProxyCache.this.cache.getCacheClosedException(reason, e);
            }
            catch (IllegalStateException ignore) {
                return new CacheClosedException(reason);
            }
        }
    }
}

