/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.EndpointManagerImpl;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.ServerLocation;

public class Endpoint {
    private final AtomicLong lastExecute = new AtomicLong();
    private final AtomicInteger references = new AtomicInteger();
    private final ServerLocation location;
    private final ConnectionStats stats;
    private final EndpointManagerImpl manager;
    private final DistributedMember memberId;
    private volatile boolean closed;

    Endpoint(EndpointManagerImpl endpointManager, DistributedSystem ds, ServerLocation location, ConnectionStats stats, DistributedMember memberId) {
        this.manager = endpointManager;
        this.location = location;
        this.stats = stats;
        this.memberId = memberId;
        this.updateLastExecute();
    }

    public void updateLastExecute() {
        this.lastExecute.set(System.nanoTime());
    }

    private long getLastExecute() {
        return this.lastExecute.get();
    }

    public boolean timeToPing(long pingIntervalNanos) {
        long now = System.nanoTime();
        return this.getLastExecute() <= now - pingIntervalNanos;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public ConnectionStats getStats() {
        return this.stats;
    }

    void addReference() {
        this.references.incrementAndGet();
    }

    public boolean removeReference() {
        boolean lastReference;
        boolean bl = lastReference = this.references.decrementAndGet() <= 0;
        if (lastReference) {
            this.manager.endpointNotInUse(this);
        }
        return lastReference;
    }

    public ServerLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return this.location.toString() + "," + this.getMemberId();
    }

    public DistributedMember getMemberId() {
        return this.memberId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (!this.location.equals(other.getLocation())) {
            return false;
        }
        return this.memberId.equals(other.getMemberId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.location.hashCode() + this.memberId.hashCode();
        return result;
    }
}

