/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal;

import java.time.Instant;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AlertListenerMessage;

class AlertListenerMessageFactory {
    AlertListenerMessageFactory() {
    }

    AlertListenerMessage createAlertListenerMessage(DistributedMember member, AlertLevel alertLevel, Instant timestamp, String connectionName, String threadName, long threadId, String formattedMessage, String stackTrace) {
        this.verifyDistributedMemberCanReceiveMessage(member);
        return AlertListenerMessage.create(member, alertLevel.intLevel(), timestamp, connectionName, threadName, threadId, formattedMessage, stackTrace);
    }

    private void verifyDistributedMemberCanReceiveMessage(DistributedMember member) {
        if (!(member instanceof InternalDistributedMember)) {
            throw new IllegalArgumentException("Creation of AlertListenerMessage requires InternalDistributedMember instead of " + member.getClass().getSimpleName());
        }
    }
}

