/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.shell.jline;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.springframework.shell.support.util.OsUtils;

public class ANSIBuffer {
    private boolean ansiEnabled = true;
    private final StringBuilder ansiBuffer = new StringBuilder();
    private final StringBuilder plainBuffer = new StringBuilder();
    private static final boolean ROO_BRIGHT_COLORS = Boolean.getBoolean("roo.bright");
    private static final boolean SHELL_BRIGHT_COLORS = Boolean.getBoolean("spring.shell.bright");
    private static final boolean BRIGHT_COLORS = ROO_BRIGHT_COLORS || SHELL_BRIGHT_COLORS;

    public ANSIBuffer() {
    }

    public ANSIBuffer(String str) {
        this.append(str);
    }

    public void setAnsiEnabled(boolean ansi) {
        this.ansiEnabled = ansi;
    }

    public boolean getAnsiEnabled() {
        return this.ansiEnabled;
    }

    public String getAnsiBuffer() {
        return this.ansiBuffer.toString();
    }

    public String getPlainBuffer() {
        return this.plainBuffer.toString();
    }

    public String toString(boolean ansi) {
        return ansi ? this.getAnsiBuffer() : this.getPlainBuffer();
    }

    public String toString() {
        return this.toString(this.ansiEnabled);
    }

    public ANSIBuffer append(String str) {
        this.ansiBuffer.append(str);
        this.plainBuffer.append(str);
        return this;
    }

    public ANSIBuffer attrib(String str, int code) {
        this.ansiBuffer.append(ANSICodes.attrib(code)).append(str).append(ANSICodes.attrib(0));
        this.plainBuffer.append(str);
        return this;
    }

    public ANSIBuffer red(String str) {
        return this.attrib(str, 31);
    }

    public ANSIBuffer blue(String str) {
        return this.attrib(str, 34);
    }

    public ANSIBuffer green(String str) {
        return this.attrib(str, 32);
    }

    public ANSIBuffer black(String str) {
        return this.attrib(str, 30);
    }

    public ANSIBuffer yellow(String str) {
        return this.attrib(str, 33);
    }

    public ANSIBuffer magenta(String str) {
        return this.attrib(str, 35);
    }

    public ANSIBuffer cyan(String str) {
        return this.attrib(str, 36);
    }

    public ANSIBuffer bold(String str) {
        return this.attrib(str, 1);
    }

    public ANSIBuffer underscore(String str) {
        return this.attrib(str, 4);
    }

    public ANSIBuffer blink(String str) {
        return this.attrib(str, 5);
    }

    public ANSIBuffer reverse(String str) {
        return this.attrib(str, 7);
    }

    public static void main(String[] args) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.print(ANSICodes.setkey("97", "97;98;99;13") + ANSICodes.attrib(0));
        System.out.flush();
        while ((line = reader.readLine()) != null) {
            System.out.println("GOT: " + line);
        }
    }

    public static ANSIBuffer getANSIBuffer() {
        int esc = 27;
        return new ANSIBuffer(){

            @Override
            public ANSIBuffer reverse(String str) {
                if (OsUtils.isWindows()) {
                    return super.reverse(str).append(ANSICodes.attrib(27));
                }
                return super.reverse(str);
            }

            @Override
            public ANSIBuffer attrib(String str, int code) {
                if (BRIGHT_COLORS && 30 <= code && code <= 37) {
                    return this.append("\u001b[" + code + ";1m").append(str).append(ANSICodes.attrib(0));
                }
                return super.attrib(str, code);
            }
        };
    }

    public static class ANSICodes {
        static final int OFF = 0;
        static final int BOLD = 1;
        static final int UNDERSCORE = 4;
        static final int BLINK = 5;
        static final int REVERSE = 7;
        static final int CONCEALED = 8;
        static final int FG_BLACK = 30;
        static final int FG_RED = 31;
        static final int FG_GREEN = 32;
        static final int FG_YELLOW = 33;
        static final int FG_BLUE = 34;
        static final int FG_MAGENTA = 35;
        static final int FG_CYAN = 36;
        static final int FG_WHITE = 37;
        static final char ESC = '\u001b';

        private ANSICodes() {
        }

        public static String setmode(int mode) {
            return "\u001b[=" + mode + "h";
        }

        public static String resetmode(int mode) {
            return "\u001b[=" + mode + "l";
        }

        public static String clrscr() {
            return "\u001b[2J";
        }

        public static String clreol() {
            return "\u001b[K";
        }

        public static String left(int n) {
            return "\u001b[" + n + "D";
        }

        public static String right(int n) {
            return "\u001b[" + n + "C";
        }

        public static String up(int n) {
            return "\u001b[" + n + "A";
        }

        public static String down(int n) {
            return "\u001b[" + n + "B";
        }

        public static String gotoxy(int row, int column) {
            return "\u001b[" + row + ";" + column + "H";
        }

        public static String save() {
            return "\u001b[s";
        }

        public static String restore() {
            return "\u001b[u";
        }

        public static String attrib(int attr) {
            return "\u001b[" + attr + "m";
        }

        public static String setkey(String code, String value) {
            return "\u001b[" + code + ";" + value + "p";
        }
    }
}

