/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.cache.wan.AbstractGatewaySender;
import org.apache.geode.internal.security.CallbackInstantiator;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.cli.functions.GatewaySenderFunctionArgs;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.logging.log4j.Logger;

public class AlterGatewaySenderFunction
implements InternalFunction<GatewaySenderFunctionArgs> {
    private static final long serialVersionUID = 1L;
    private static final String ID = AlterGatewaySenderFunction.class.getName();
    private static final Logger logger = LogService.getLogger();

    public void execute(FunctionContext<GatewaySenderFunctionArgs> context) {
        ResultSender resultSender = context.getResultSender();
        Cache cache = context.getCache();
        String memberNameOrId = context.getMemberName();
        GatewaySenderFunctionArgs gatewaySenderAlterArgs = (GatewaySenderFunctionArgs)context.getArguments();
        try {
            GatewaySender alterGatewaySender = this.alterGatewaySender(cache, gatewaySenderAlterArgs);
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format((String)"GatewaySender {0} is updated on member {1}", (Object[])new Object[]{alterGatewaySender.getId(), memberNameOrId})));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, (Object)e, null));
        }
    }

    private GatewaySender alterGatewaySender(Cache cache, GatewaySenderFunctionArgs gatewaySenderCreateArgs) {
        List<String> gatewayEventFilters;
        Boolean groupTransactionEvents;
        Integer batchTimeInterval;
        Integer batchSize;
        Integer alertThreshold;
        String gwId = gatewaySenderCreateArgs.getId();
        GatewaySender gateway = cache.getGatewaySender(gwId);
        if (gateway == null) {
            String message = String.format("Cannot find existing gateway sender with id '%s'.", gwId);
            throw new EntityNotFoundException(message);
        }
        if (!(gateway instanceof AbstractGatewaySender)) {
            throw new UnsupportedOperationException("alter gateway sender");
        }
        boolean pause = false;
        if (gateway.isRunning() && !gateway.isPaused()) {
            gateway.pause();
            pause = true;
        }
        if ((alertThreshold = gatewaySenderCreateArgs.getAlertThreshold()) != null) {
            ((AbstractGatewaySender)gateway).setAlertThreshold(alertThreshold.intValue());
        }
        if ((batchSize = gatewaySenderCreateArgs.getBatchSize()) != null) {
            ((AbstractGatewaySender)gateway).setBatchSize(batchSize.intValue());
        }
        if ((batchTimeInterval = gatewaySenderCreateArgs.getBatchTimeInterval()) != null) {
            ((AbstractGatewaySender)gateway).setBatchTimeInterval(batchTimeInterval.intValue());
        }
        if ((groupTransactionEvents = gatewaySenderCreateArgs.mustGroupTransactionEvents()) != null) {
            ((AbstractGatewaySender)gateway).setGroupTransactionEvents(groupTransactionEvents.booleanValue());
        }
        if ((gatewayEventFilters = gatewaySenderCreateArgs.getGatewayEventFilter()) != null) {
            ArrayList<Object> filters = new ArrayList<Object>();
            if (!gatewayEventFilters.isEmpty()) {
                for (String filter : gatewayEventFilters) {
                    filters.add(CallbackInstantiator.getObjectOfTypeFromClassName((String)filter, GatewayEventFilter.class));
                }
            }
            ((AbstractGatewaySender)gateway).setGatewayEventFilters(filters);
        }
        if (pause) {
            gateway.resume();
        }
        return gateway;
    }

    public String getId() {
        return ID;
    }
}

