/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.logging.log4j.Logger;

class DiskStoreCommandsUtils {
    private static final Logger logger = LogService.getLogger();
    private static final String LOG4J_CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";

    DiskStoreCommandsUtils() {
    }

    static void configureLogging(List<String> commandList) {
        String configFilePropertyValue = System.getProperty(LOG4J_CONFIGURATION_FILE_PROPERTY);
        if (StringUtils.isBlank((CharSequence)configFilePropertyValue)) {
            URL configUrl = LogService.class.getResource("/log4j2-cli.xml");
            configFilePropertyValue = configUrl.toString();
        }
        commandList.add("-Dlog4j.configurationFile=" + configFilePropertyValue);
    }

    static String validatedDirectories(String[] diskDirs) {
        String invalidDirectories = null;
        StringBuilder builder = null;
        for (String diskDirPath : diskDirs) {
            File diskDir = new File(diskDirPath);
            if (diskDir.exists()) continue;
            if (builder == null) {
                builder = new StringBuilder();
            } else if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(diskDirPath);
        }
        if (builder != null) {
            invalidDirectories = builder.toString();
        }
        return invalidDirectories;
    }

    static Set<DistributedMember> getNormalMembers(InternalCache cache) {
        return ManagementUtils.getAllNormalMembers((InternalCache)cache);
    }

    static boolean diskStoreBeanAndMemberBeanDiskStoreExists(DistributedSystemMXBean dsMXBean, String memberName, String diskStore) {
        return DiskStoreCommandsUtils.diskStoreBeanExists(dsMXBean, memberName, diskStore) && DiskStoreCommandsUtils.memberBeanDiskStoreExists(dsMXBean, memberName, diskStore);
    }

    private static boolean diskStoreBeanExists(DistributedSystemMXBean dsMXBean, String memberName, String diskStore) {
        try {
            dsMXBean.fetchDiskStoreObjectName(memberName, diskStore);
            return true;
        }
        catch (Exception e) {
            if (!e.getMessage().toLowerCase().contains("not found")) {
                logger.warn("Unable to retrieve Disk Store ObjectName for member: {}, diskstore: {}  {}", (Object)memberName, (Object)diskStore, (Object)e.getMessage());
            }
            return false;
        }
    }

    private static boolean memberBeanDiskStoreExists(DistributedSystemMXBean dsMXBean, String memberName, String diskStore) {
        return Stream.of(dsMXBean).filter(Objects::nonNull).map(DistributedSystemMXBean::listMemberDiskstore).filter(Objects::nonNull).map(mds -> (String[])mds.get(memberName)).filter(Objects::nonNull).flatMap(Stream::of).filter(Objects::nonNull).anyMatch(dsName -> dsName.equals(diskStore));
    }
}

