/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli;

import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public abstract class AbstractCliAroundInterceptor
implements CliAroundInterceptor {
    public boolean interactionSupported() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return gfsh != null && !gfsh.isQuietMode() && !gfsh.isHeadlessMode();
    }

    protected String interact(String message) {
        return Gfsh.getCurrentInstance().interact(message);
    }

    protected Response readYesNo(String message, Response defaultResponse) {
        String userInput;
        message = defaultResponse == Response.YES ? message + " (" + Response.YES.toUpperPrompt() + "/" + Response.NO.toLowerPrompt() + "): " : message + " (" + Response.YES.toLowerPrompt() + "/" + Response.NO.toUpperPrompt() + "): ";
        if (!this.interactionSupported()) {
            return defaultResponse;
        }
        Response response = null;
        do {
            if (!StringUtils.isEmpty((CharSequence)(userInput = this.interact(message)))) continue;
            return defaultResponse;
        } while ((response = Response.fromString(userInput)) == null);
        return response;
    }

    protected static enum Response {
        YES("yes"),
        NO("no");

        private final String text;

        private Response(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }

        public String toUpperPrompt() {
            return this.text.substring(0, 1).toUpperCase();
        }

        public String toLowerPrompt() {
            return this.text.substring(0, 1).toLowerCase();
        }

        public static Response fromString(String text) {
            if (text != null) {
                for (Response response : Response.values()) {
                    if (!text.equalsIgnoreCase(response.text) && (text.length() != 1 || !text.equalsIgnoreCase(response.text.substring(0, 1)))) continue;
                    return response;
                }
            }
            return null;
        }
    }
}

