
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package org.apache.geode.cache.configuration;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.apache.geode.annotations.Experimental;

/**
 *
 * A "disk-store" element specifies a DiskStore for persistence.
 *
 *
 * <p>
 * Java class for disk-store-type complex type.
 *
 * <p>
 * The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="disk-store-type"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="disk-dirs" type="{http://geode.apache.org/schema/cache}disk-dirs-type" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="name" use="required" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="auto-compact" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="compaction-threshold" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="allow-force-compaction" type="{http://www.w3.org/2001/XMLSchema}boolean" /&gt;
 *       &lt;attribute name="max-oplog-size" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="time-interval" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="write-buffer-size" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="queue-size" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="disk-usage-warning-percentage" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *       &lt;attribute name="disk-usage-critical-percentage" type="{http://www.w3.org/2001/XMLSchema}string" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "disk-store-type", namespace = "http://geode.apache.org/schema/cache",
    propOrder = {"diskDirs"})
@Experimental
public class DiskStoreType extends CacheElement {

  @XmlElement(name = "disk-dirs", namespace = "http://geode.apache.org/schema/cache")
  protected DiskDirsType diskDirs;
  @XmlAttribute(name = "name", required = true)
  protected String name;
  @XmlAttribute(name = "auto-compact")
  protected Boolean autoCompact;
  @XmlAttribute(name = "compaction-threshold")
  protected String compactionThreshold;
  @XmlAttribute(name = "allow-force-compaction")
  protected Boolean allowForceCompaction;
  @XmlAttribute(name = "max-oplog-size")
  protected String maxOplogSize;
  @XmlAttribute(name = "time-interval")
  protected String timeInterval;
  @XmlAttribute(name = "write-buffer-size")
  protected String writeBufferSize;
  @XmlAttribute(name = "queue-size")
  protected String queueSize;
  @XmlAttribute(name = "disk-usage-warning-percentage")
  protected String diskUsageWarningPercentage;
  @XmlAttribute(name = "disk-usage-critical-percentage")
  protected String diskUsageCriticalPercentage;

  @Override
  @JsonProperty(value = "name")
  public String getId() {
    return getName();
  }

  /**
   * Gets the value of the name property.
   *
   * possible object is
   * {@link String }
   *
   * @return the name.
   */
  public String getName() {
    return name;
  }

  public List<DiskDirType> getDiskDirs() {
    if (diskDirs == null) {
      diskDirs = new DiskDirsType();
    }
    return diskDirs.getDiskDirs();
  }

  public void setDiskDirs(List<DiskDirType> diskDirs) {
    getDiskDirs().clear();
    getDiskDirs().addAll(diskDirs);
  }

  /**
   * Sets the value of the name property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the name.
   */
  public void setName(String value) {
    name = value;
  }

  /**
   * Gets the value of the autoCompact property.
   *
   * possible object is
   * {@link Boolean }
   *
   * @return true if auto compaction is enabled, false otherwise.
   */
  public Boolean isAutoCompact() {
    return autoCompact;
  }

  /**
   * Sets the value of the autoCompact property.
   *
   * allowed object is
   * {@link Boolean }
   *
   * @param value enables or disables auto compaction.
   */
  public void setAutoCompact(Boolean value) {
    autoCompact = value;
  }

  /**
   * Gets the value of the compactionThreshold property.
   *
   * possible object is
   * {@link String }
   *
   * @return the compaction threshold.
   */
  public String getCompactionThreshold() {
    return compactionThreshold;
  }

  /**
   * Sets the value of the compactionThreshold property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the compaction threshold.
   */
  public void setCompactionThreshold(String value) {
    compactionThreshold = value;
  }

  /**
   * Gets the value of the allowForceCompaction property.
   *
   * possible object is
   * {@link Boolean }
   *
   * @return true is force compaction is allowed, false if not.
   */
  public Boolean isAllowForceCompaction() {
    return allowForceCompaction;
  }

  /**
   * Sets the value of the allowForceCompaction property.
   *
   * allowed object is
   * {@link Boolean }
   *
   * @param value allows or disallows force compaction.
   */
  public void setAllowForceCompaction(Boolean value) {
    allowForceCompaction = value;
  }

  /**
   * Gets the value of the maxOplogSize property.
   *
   * possible object is
   * {@link String }
   *
   * @return the maximum oplog size.
   */
  public String getMaxOplogSize() {
    return maxOplogSize;
  }

  /**
   * Sets the value of the maxOplogSize property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the maximum oplog size.
   */
  public void setMaxOplogSize(String value) {
    maxOplogSize = value;
  }

  /**
   * Gets the value of the timeInterval property.
   *
   * possible object is
   * {@link String }
   *
   * @return the time interval.
   */
  public String getTimeInterval() {
    return timeInterval;
  }

  /**
   * Sets the value of the timeInterval property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the time interval.
   */
  public void setTimeInterval(String value) {
    timeInterval = value;
  }

  /**
   * Gets the value of the writeBufferSize property.
   *
   * possible object is
   * {@link String }
   *
   * @return the write-buffer size.
   */
  public String getWriteBufferSize() {
    return writeBufferSize;
  }

  /**
   * Sets the value of the writeBufferSize property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the write-buffer size.
   */
  public void setWriteBufferSize(String value) {
    writeBufferSize = value;
  }

  /**
   * Gets the value of the queueSize property.
   *
   * possible object is
   * {@link String }
   *
   * @return the queue size.
   */
  public String getQueueSize() {
    return queueSize;
  }

  /**
   * Sets the value of the queueSize property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the queue size.
   */
  public void setQueueSize(String value) {
    queueSize = value;
  }

  /**
   * Gets the value of the diskUsageWarningPercentage property.
   *
   * possible object is
   * {@link String }
   *
   * @return the disk usage warning percentage.
   */
  public String getDiskUsageWarningPercentage() {
    return diskUsageWarningPercentage;
  }

  /**
   * Sets the value of the diskUsageWarningPercentage property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the disk usage warning percentage.
   */
  public void setDiskUsageWarningPercentage(String value) {
    diskUsageWarningPercentage = value;
  }

  /**
   * Gets the value of the diskUsageCriticalPercentage property.
   *
   * possible object is
   * {@link String }
   *
   * @return the disk usage critical percentage.
   */
  public String getDiskUsageCriticalPercentage() {
    return diskUsageCriticalPercentage;
  }

  /**
   * Sets the value of the diskUsageCriticalPercentage property.
   *
   * allowed object is
   * {@link String }
   *
   * @param value the disk usage critical percentage.
   */
  public void setDiskUsageCriticalPercentage(String value) {
    diskUsageCriticalPercentage = value;
  }

}
