<!--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->
# Apache Fluo Recipes

[![Build Status][ti]][tl] [![Apache License][li]][ll]

**Fluo Recipes are common code for [Apache Fluo][fluo] application developers.**

Fluo Recipes build on the Fluo API to offer additional functionality to developers.
They are published separately from Fluo on their own release schedule.
This allows Fluo Recipes to iterate and innovate faster than Fluo (which will maintain
a more minimal API on a slower release cycle). Fluo Recipes offers code to implement
common patterns on top of Fluo's API.  It also offers glue code to external libraries
like Spark and Kryo.

## Getting Started

* Read the [Fluo Recipes documentation][fluo-docs]
* View the [API][fluo-api] for Fluo Recipes

[fluo]: https://fluo.apache.org/
[fluo-api]: https://fluo.apache.org/api/
[fluo-docs]: https://fluo.apache.org/docs/
[ti]: https://travis-ci.org/apache/fluo-recipes.svg?branch=master
[tl]: https://travis-ci.org/apache/fluo-recipes
[li]: http://img.shields.io/badge/license-ASL-blue.svg
[ll]: https://github.com/apache/fluo-recipes/blob/master/LICENSE
