/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonFormatOptions;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@Internal
public class JsonRowDataSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final RowDataToJsonConverters.RowDataToJsonConverter runtimeConverter;
    private transient ObjectMapper mapper;
    private transient ObjectNode node;
    private final TimestampFormat timestampFormat;
    private final JsonFormatOptions.MapNullKeyMode mapNullKeyMode;
    private final String mapNullKeyLiteral;
    private final boolean encodeDecimalAsPlainNumber;
    private final boolean ignoreNullFields;

    public JsonRowDataSerializationSchema(RowType rowType, TimestampFormat timestampFormat, JsonFormatOptions.MapNullKeyMode mapNullKeyMode, String mapNullKeyLiteral, boolean encodeDecimalAsPlainNumber, boolean ignoreNullFields) {
        this.rowType = rowType;
        this.timestampFormat = timestampFormat;
        this.mapNullKeyMode = mapNullKeyMode;
        this.mapNullKeyLiteral = mapNullKeyLiteral;
        this.encodeDecimalAsPlainNumber = encodeDecimalAsPlainNumber;
        this.ignoreNullFields = ignoreNullFields;
        this.runtimeConverter = new RowDataToJsonConverters(timestampFormat, mapNullKeyMode, mapNullKeyLiteral, ignoreNullFields).createConverter((LogicalType)rowType);
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.mapper = JacksonMapperFactory.createObjectMapper().configure(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN, this.encodeDecimalAsPlainNumber);
    }

    public byte[] serialize(RowData row) {
        if (this.node == null || this.ignoreNullFields) {
            this.node = this.mapper.createObjectNode();
        }
        try {
            this.runtimeConverter.convert(this.mapper, (JsonNode)this.node, row);
            return this.mapper.writeValueAsBytes((Object)this.node);
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Could not serialize row '%s'.", row), t);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRowDataSerializationSchema that = (JsonRowDataSerializationSchema)o;
        return this.rowType.equals((Object)that.rowType) && this.timestampFormat.equals((Object)that.timestampFormat) && this.mapNullKeyMode.equals((Object)that.mapNullKeyMode) && this.mapNullKeyLiteral.equals(that.mapNullKeyLiteral) && this.encodeDecimalAsPlainNumber == that.encodeDecimalAsPlainNumber && this.ignoreNullFields == that.ignoreNullFields;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.rowType, this.timestampFormat, this.mapNullKeyMode, this.mapNullKeyLiteral, this.encodeDecimalAsPlainNumber, this.ignoreNullFields});
    }
}

