/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.runtimefilter;

import org.apache.flink.runtime.operators.util.BloomFilter;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.runtimefilter.util.RuntimeFilterUtils;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class LocalRuntimeFilterBuilderOperator
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData>,
BoundedOneInput {
    private final GeneratedProjection buildProjectionCode;
    private final int estimatedRowCount;
    private final int maxRowCount;
    private transient Projection<RowData, BinaryRowData> buildSideProjection;
    private transient BloomFilter filter;
    private transient Collector<RowData> collector;
    private transient int actualRowCount;

    public LocalRuntimeFilterBuilderOperator(GeneratedProjection buildProjectionCode, int estimatedRowCount, int maxRowCount) {
        Preconditions.checkArgument((estimatedRowCount > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxRowCount >= estimatedRowCount ? 1 : 0) != 0);
        this.buildProjectionCode = (GeneratedProjection)Preconditions.checkNotNull((Object)buildProjectionCode);
        this.estimatedRowCount = estimatedRowCount;
        this.maxRowCount = maxRowCount;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.buildSideProjection = (Projection)this.buildProjectionCode.newInstance(this.getUserCodeClassloader());
        this.filter = RuntimeFilterUtils.createOnHeapBloomFilter(this.estimatedRowCount);
        this.collector = new StreamRecordCollector<RowData>(this.output);
        this.actualRowCount = 0;
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        if (this.filter != null) {
            Preconditions.checkNotNull(this.buildSideProjection);
            int hashCode = this.buildSideProjection.apply((RowData)element.getValue()).hashCode();
            this.filter.addHash(hashCode);
            ++this.actualRowCount;
            if (this.actualRowCount > this.maxRowCount) {
                this.filter = null;
                this.actualRowCount = -1;
            }
        }
    }

    public void endInput() throws Exception {
        this.collector.collect((Object)RuntimeFilterUtils.convertBloomFilterToRowData(this.actualRowCount, this.filter));
    }
}

