/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.felix.utils.json.JSONWriter;
import org.apache.felix.webconsole.internal.configuration.PropertyDescriptor;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class MetaTypeSupport {
    static final String PASSWORD_PLACEHOLDER_VALUE = "unmodified";

    MetaTypeSupport() {
    }

    static Bundle getBundle(BundleContext bundleContext, String bundleLocation) {
        if (bundleLocation == null) {
            return null;
        }
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!bundleLocation.equals(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }

    static void attributeToJson(JSONWriter json, PropertyDescriptor ad, Object propValue) throws IOException {
        boolean isPassword;
        json.object();
        Object value = propValue != null ? propValue : (ad.getDefaultValue() != null ? ad.getDefaultValue() : (ad.getCardinality() == 0 ? "" : new String[]{}));
        json.key("name");
        json.value(ad.getName());
        json.key("optional");
        json.value(ad.isOptional());
        json.key("is_set");
        json.value(propValue != null);
        int propertyType = MetaTypeSupport.getAttributeType(ad);
        json.key("type");
        if (ad.getOptionLabels() != null && ad.getOptionLabels().length > 0) {
            json.object();
            json.key("labels");
            json.value(Arrays.asList(ad.getOptionLabels()));
            json.key("values");
            json.value(Arrays.asList(ad.getOptionValues()));
            json.endObject();
        } else {
            json.value(propertyType);
        }
        boolean bl = isPassword = propertyType == 12;
        if (ad.getCardinality() == 0) {
            if (isPassword) {
                value = PASSWORD_PLACEHOLDER_VALUE;
            } else if (value instanceof Vector) {
                value = ((Vector)value).get(0);
            } else if (value.getClass().isArray()) {
                value = Array.get(value, 0);
            }
            json.key("value");
            json.value(value);
        } else {
            json.key("values");
            json.array();
            List list = MetaTypeSupport.toList(value);
            for (Object val : list) {
                if (isPassword) {
                    json.value(PASSWORD_PLACEHOLDER_VALUE);
                    continue;
                }
                json.value(val);
            }
            json.endArray();
        }
        if (ad.getDescription() != null) {
            json.key("description");
            json.value(ad.getDescription() + " (" + ad.getID() + ")");
        }
        json.endObject();
    }

    private static List toList(Object value) {
        if (value instanceof Vector) {
            return (Vector)value;
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                int len = Array.getLength(value);
                Object[] tmp = new Object[len];
                for (int j = 0; j < len; ++j) {
                    tmp[j] = Array.get(value, j);
                }
                value = tmp;
            }
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    static PropertyDescriptor createAttributeDefinition(String id, Object value) {
        Class type;
        int attrCardinality;
        if (value == null) {
            attrCardinality = 0;
            type = String.class;
        } else if (value instanceof Collection) {
            attrCardinality = Integer.MIN_VALUE;
            Collection coll = (Collection)value;
            type = coll.isEmpty() ? String.class : coll.iterator().next().getClass();
        } else if (value.getClass().isArray()) {
            attrCardinality = Integer.MAX_VALUE;
            type = value.getClass().getComponentType();
        } else {
            attrCardinality = 0;
            type = value.getClass();
        }
        int attrType = type == Boolean.class || type == Boolean.TYPE ? 11 : (type == Byte.class || type == Byte.TYPE ? 6 : (type == Character.class || type == Character.TYPE ? 5 : (type == Double.class || type == Double.TYPE ? 7 : (type == Float.class || type == Float.TYPE ? 8 : (type == Long.class || type == Long.TYPE ? 2 : (type == Integer.class || type == Integer.TYPE ? 3 : (type == Short.class || type == Short.TYPE ? 4 : 1)))))));
        return new PropertyDescriptor(id, attrType, attrCardinality);
    }

    public static boolean isPasswordProperty(String name) {
        if (name == null || !OsgiManager.ENABLE_SECRET_HEURISTICS) {
            return false;
        }
        return name.toLowerCase().indexOf("password") != -1;
    }

    static int getAttributeType(PropertyDescriptor ad) {
        if (ad.getType() == 1 && MetaTypeSupport.isPasswordProperty(ad.getID())) {
            return 12;
        }
        return ad.getType();
    }

    static final Object toType(int type, String value) {
        switch (type) {
            case 11: {
                return Boolean.valueOf(value);
            }
            case 6: {
                return Byte.valueOf(value);
            }
            case 5: {
                char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                return Character.valueOf(c);
            }
            case 7: {
                return Double.valueOf(value);
            }
            case 8: {
                return Float.valueOf(value);
            }
            case 2: {
                return Long.valueOf(value);
            }
            case 3: {
                return Integer.valueOf(value);
            }
            case 4: {
                return Short.valueOf(value);
            }
        }
        return value;
    }

    static void setPasswordProps(Vector vec, String[] properties, Object props) {
        List propList = props == null ? new ArrayList() : MetaTypeSupport.toList(props);
        for (int i = 0; i < properties.length; ++i) {
            if (PASSWORD_PLACEHOLDER_VALUE.equals(properties[i])) {
                if (i >= propList.size() || propList.get(i) == null) continue;
                vec.add(propList.get(i));
                continue;
            }
            vec.add(properties[i]);
        }
    }

    static final Object toArray(int type, Vector<Object> values) {
        Object[] array;
        int size = values.size();
        if (type == 1 || type == 12) {
            return values.toArray(new String[size]);
        }
        switch (type) {
            case 11: {
                array = new boolean[size];
                break;
            }
            case 6: {
                array = new byte[size];
                break;
            }
            case 5: {
                array = new char[size];
                break;
            }
            case 7: {
                array = new double[size];
                break;
            }
            case 8: {
                array = new float[size];
                break;
            }
            case 2: {
                array = new long[size];
                break;
            }
            case 3: {
                array = new int[size];
                break;
            }
            case 4: {
                array = new short[size];
                break;
            }
            default: {
                array = new String[size];
            }
        }
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }
}

