/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.apache.felix.http.jetty.LoadBalancerCustomizerFactory;
import org.apache.felix.http.jetty.internal.CustomizerWrapper;
import org.eclipse.jetty.server.HttpConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class LoadBalancerCustomizerFactoryTracker
extends ServiceTracker<LoadBalancerCustomizerFactory, ServiceReference<LoadBalancerCustomizerFactory>> {
    private final CustomizerWrapper customizerWrapper;
    private final BundleContext bundleContext;
    private final SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> set = new TreeSet<ServiceReference<LoadBalancerCustomizerFactory>>();

    public LoadBalancerCustomizerFactoryTracker(BundleContext context, CustomizerWrapper customizerWrapper) {
        super(context, LoadBalancerCustomizerFactory.class.getName(), null);
        this.bundleContext = context;
        this.customizerWrapper = customizerWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference<LoadBalancerCustomizerFactory> addingService(ServiceReference<LoadBalancerCustomizerFactory> reference) {
        ServiceReference<LoadBalancerCustomizerFactory> highestReference;
        SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> sortedSet = this.set;
        synchronized (sortedSet) {
            this.set.add(reference);
            highestReference = this.set.last();
        }
        if (highestReference.compareTo(reference) == 0) {
            boolean updated = false;
            LoadBalancerCustomizerFactory factory = ServiceUtils.safeGetService(this.bundleContext, reference);
            if (factory != null) {
                HttpConfiguration.Customizer customizer = factory.createCustomizer();
                if (customizer != null) {
                    this.customizerWrapper.setCustomizer(customizer);
                    updated = true;
                } else {
                    ServiceUtils.safeUngetService(this.bundleContext, reference);
                }
            }
            if (!updated) {
                SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> sortedSet2 = this.set;
                synchronized (sortedSet2) {
                    this.set.remove(reference);
                }
                return null;
            }
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference<LoadBalancerCustomizerFactory> reference, ServiceReference<LoadBalancerCustomizerFactory> service) {
        boolean change;
        ServiceReference<LoadBalancerCustomizerFactory> highestReference = null;
        SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> sortedSet = this.set;
        synchronized (sortedSet) {
            change = this.set.isEmpty() ? false : this.set.last().compareTo(reference) == 0;
            this.set.remove(reference);
            highestReference = this.set.isEmpty() ? null : this.set.last();
        }
        if (change) {
            boolean done = false;
            do {
                if (highestReference == null) {
                    this.customizerWrapper.setCustomizer(null);
                    done = true;
                    continue;
                }
                LoadBalancerCustomizerFactory factory = ServiceUtils.safeGetService(this.bundleContext, highestReference);
                if (factory != null) {
                    HttpConfiguration.Customizer customizer = factory.createCustomizer();
                    if (customizer != null) {
                        this.customizerWrapper.setCustomizer(customizer);
                        done = true;
                    } else {
                        ServiceUtils.safeUngetService(this.bundleContext, highestReference);
                    }
                }
                if (done) continue;
                SortedSet<ServiceReference<LoadBalancerCustomizerFactory>> sortedSet2 = this.set;
                synchronized (sortedSet2) {
                    this.set.remove(highestReference);
                    highestReference = this.set.isEmpty() ? null : this.set.last();
                }
            } while (!done);
            ServiceUtils.safeUngetService(this.bundleContext, reference);
        }
    }
}

