/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.util;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.daffodil.api.DataProcessor;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.core.compiler.Compiler;
import org.apache.daffodil.core.compiler.Compiler$;
import org.apache.daffodil.core.compiler.ProcessorFactory;
import org.apache.daffodil.core.util.StreamParser$;
import org.apache.daffodil.core.util.StreamParser$CompileFailure$;
import org.apache.daffodil.core.util.StreamParser$Result$;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.lib.exceptions.MultiException;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter$;
import scala.Product;
import scala.collection.Seq;
import scala.collection.immutable.LazyList;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public class StreamParser {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(StreamParser.class.getDeclaredField("compilationWarnings$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(StreamParser.class.getDeclaredField("pf$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(StreamParser.class.getDeclaredField("c$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StreamParser.class.getDeclaredField("outputter$lzy1"));
    private final Node schema;
    private volatile Object outputter$lzy1;
    private InputSourceDataInputStream dis;
    private volatile Object c$lzy1;
    private volatile Object pf$lzy1;
    private final DataProcessor dp;
    private volatile Object compilationWarnings$lzy1;

    public static LazyList<Result> doStreamTest(Node node, String string) {
        return StreamParser$.MODULE$.doStreamTest(node, string);
    }

    public StreamParser(Node schema) {
        this.schema = schema;
        if (this.pf().isError()) {
            throw new CompileFailure(this.pf().getDiagnostics());
        }
        DataProcessor dataproc1 = this.pf().onPath("/");
        Path schemaTempFile = Files.createTempFile("streamparser", ".test", new FileAttribute[0]);
        FileUtils.write((File)schemaTempFile.toFile(), (CharSequence)schema.toString(), (Charset)Charset.defaultCharset());
        DataProcessor dataproc = dataproc1.withValidation("xerces", schemaTempFile.toUri().toURL());
        if (dataproc.isError()) {
            throw new CompileFailure(dataproc.getDiagnostics());
        }
        this.dp = dataproc;
    }

    public Node schema() {
        return this.schema;
    }

    private ScalaXMLInfosetOutputter outputter() {
        Object object = this.outputter$lzy1;
        if (object instanceof ScalaXMLInfosetOutputter) {
            return (ScalaXMLInfosetOutputter)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ScalaXMLInfosetOutputter)this.outputter$lzyINIT1();
    }

    private Object outputter$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.outputter$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ScalaXMLInfosetOutputter scalaXMLInfosetOutputter = null;
                    try {
                        scalaXMLInfosetOutputter = new ScalaXMLInfosetOutputter(ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$1());
                        object2 = scalaXMLInfosetOutputter == null ? LazyVals.NullValue$.MODULE$ : scalaXMLInfosetOutputter;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.outputter$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return scalaXMLInfosetOutputter;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Compiler c() {
        Object object = this.c$lzy1;
        if (object instanceof Compiler) {
            return (Compiler)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Compiler)this.c$lzyINIT1();
    }

    private Object c$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.c$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Compiler compiler = null;
                    try {
                        compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
                        object2 = compiler == null ? LazyVals.NullValue$.MODULE$ : compiler;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.c$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return compiler;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private ProcessorFactory pf() {
        Object object = this.pf$lzy1;
        if (object instanceof ProcessorFactory) {
            return (ProcessorFactory)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ProcessorFactory)this.pf$lzyINIT1();
    }

    private Object pf$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.pf$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ProcessorFactory processorFactory = null;
                    try {
                        processorFactory = this.c().compileNode(this.schema(), this.c().compileNode$default$2(), this.c().compileNode$default$3(), this.c().compileNode$default$4());
                        object2 = processorFactory == null ? LazyVals.NullValue$.MODULE$ : processorFactory;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.pf$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return processorFactory;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<Diagnostic> compilationWarnings() {
        Object object = this.compilationWarnings$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.compilationWarnings$lzyINIT1();
    }

    private Object compilationWarnings$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.compilationWarnings$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LinkedList<Diagnostic> linkedList = null;
                    try {
                        LinkedList<Diagnostic> tmp = new LinkedList<Diagnostic>(this.pf().getDiagnostics());
                        tmp.addAll(this.dp.getDiagnostics());
                        linkedList = tmp;
                        object2 = linkedList == null ? LazyVals.NullValue$.MODULE$ : linkedList;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.compilationWarnings$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return linkedList;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void setInputStream(InputStream inputStream) {
        this.dis = InputSourceDataInputStream$.MODULE$.apply(inputStream);
    }

    public Result parse() {
        if (this.dis == null) {
            throw new IllegalStateException("Input stream must be provided by setInputStream() call.");
        }
        DFDL.ParseResult res = (DFDL.ParseResult)this.dp.parse(this.dis, this.outputter());
        boolean procErr = ((DFDL.Result)((Object)res)).isProcessingError();
        boolean validationErr = ((DFDL.Result)((Object)res)).isValidationError();
        List<Diagnostic> diags = ((DFDL.Result)((Object)res)).getDiagnostics();
        Node doc = !procErr ? this.outputter().getResult() : null;
        long bitPos1b = ((DFDL.Result)((Object)res)).resultState().currentLocation().bitPos1b();
        Result r = new Result(doc, diags, procErr, validationErr, bitPos1b);
        this.outputter().reset();
        return r;
    }

    public static class CompileFailure
    extends MultiException<Diagnostic>
    implements Product {
        private final List diags;

        public static CompileFailure apply(List<Diagnostic> list) {
            return StreamParser$CompileFailure$.MODULE$.apply(list);
        }

        public static CompileFailure fromProduct(Product product) {
            return StreamParser$CompileFailure$.MODULE$.fromProduct(product);
        }

        public static CompileFailure unapply(CompileFailure compileFailure) {
            return StreamParser$CompileFailure$.MODULE$.unapply(compileFailure);
        }

        public CompileFailure(List<Diagnostic> diags) {
            this.diags = diags;
            super(diags);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompileFailure)) return false;
            CompileFailure compileFailure = (CompileFailure)object;
            List<Diagnostic> list = this.diags();
            List<Diagnostic> list2 = compileFailure.diags();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!((Object)list).equals(list2)) return false;
            if (!compileFailure.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof CompileFailure;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CompileFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "diags";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Diagnostic> diags() {
            return this.diags;
        }

        public CompileFailure copy(List<Diagnostic> diags) {
            return new CompileFailure(diags);
        }

        public List<Diagnostic> copy$default$1() {
            return this.diags();
        }

        public List<Diagnostic> _1() {
            return this.diags();
        }
    }

    public static class Result
    implements Product,
    Serializable {
        private final Node message;
        private final List diags;
        private final boolean isProcessingError;
        private final boolean isValidationError;
        private final long bitPos1b;

        public static Result apply(Node node, List<Diagnostic> list, boolean bl, boolean bl2, long l) {
            return StreamParser$Result$.MODULE$.apply(node, list, bl, bl2, l);
        }

        public static Result fromProduct(Product product) {
            return StreamParser$Result$.MODULE$.fromProduct(product);
        }

        public static Result unapply(Result result) {
            return StreamParser$Result$.MODULE$.unapply(result);
        }

        public Result(Node message, List<Diagnostic> diags, boolean isProcessingError, boolean isValidationError, long bitPos1b) {
            this.message = message;
            this.diags = diags;
            this.isProcessingError = isProcessingError;
            this.isValidationError = isValidationError;
            this.bitPos1b = bitPos1b;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.message()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.diags()));
            n = Statics.mix((int)n, (int)(this.isProcessingError() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.isValidationError() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.bitPos1b()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            if (this.isProcessingError() != result.isProcessingError()) return false;
            if (this.isValidationError() != result.isValidationError()) return false;
            if (this.bitPos1b() != result.bitPos1b()) return false;
            Node node = this.message();
            Node node2 = result.message();
            if (node == null) {
                if (node2 != null) {
                    return false;
                }
            } else if (!node.equals(node2)) return false;
            List<Diagnostic> list = this.diags();
            List<Diagnostic> list2 = result.diags();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!((Object)list).equals(list2)) return false;
            if (!result.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToLong((long)this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "message";
                }
                case 1: {
                    return "diags";
                }
                case 2: {
                    return "isProcessingError";
                }
                case 3: {
                    return "isValidationError";
                }
                case 4: {
                    return "bitPos1b";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Node message() {
            return this.message;
        }

        public List<Diagnostic> diags() {
            return this.diags;
        }

        public boolean isProcessingError() {
            return this.isProcessingError;
        }

        public boolean isValidationError() {
            return this.isValidationError;
        }

        public long bitPos1b() {
            return this.bitPos1b;
        }

        public Node toXML() {
            Null$ null$;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n        "));
            $buf.$amp$plus((Object)this.message());
            $buf.$amp$plus((Object)new Text("\n        "));
            if (!this.diags().isEmpty()) {
                NodeBuffer $buf2 = new NodeBuffer();
                $buf2.$amp$plus((Object)new Text("\n          "));
                $buf2.$amp$plus(CollectionConverters$.MODULE$.ListHasAsScala(this.diags()).asScala().map(StreamParser$::org$apache$daffodil$core$util$StreamParser$Result$$_$toXML$$anonfun$1));
                $buf2.$amp$plus((Object)new Text("\n        "));
                Elem elem = new Elem(null, "diagnostics", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2));
                null$ = elem;
            } else {
                null$ = Null$.MODULE$;
            }
            $buf.$amp$plus((Object)null$);
            $buf.$amp$plus((Object)new Text("\n      "));
            return new Elem(null, "Result", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)).$percent((MetaData)(this.isProcessingError() ? new UnprefixedAttribute("isProcessingError", BoxesRunTime.boxToBoolean((boolean)this.isProcessingError()).toString(), (MetaData)Null$.MODULE$) : Null$.MODULE$)).$percent((MetaData)(this.isValidationError() ? new UnprefixedAttribute("isValidationError", BoxesRunTime.boxToBoolean((boolean)this.isValidationError()).toString(), (MetaData)Null$.MODULE$) : Null$.MODULE$)).$percent((MetaData)new UnprefixedAttribute("bitPos1b", BoxesRunTime.boxToLong((long)this.bitPos1b()).toString(), (MetaData)Null$.MODULE$));
        }

        public Result copy(Node message, List<Diagnostic> diags, boolean isProcessingError, boolean isValidationError, long bitPos1b) {
            return new Result(message, diags, isProcessingError, isValidationError, bitPos1b);
        }

        public Node copy$default$1() {
            return this.message();
        }

        public List<Diagnostic> copy$default$2() {
            return this.diags();
        }

        public boolean copy$default$3() {
            return this.isProcessingError();
        }

        public boolean copy$default$4() {
            return this.isValidationError();
        }

        public long copy$default$5() {
            return this.bitPos1b();
        }

        public Node _1() {
            return this.message();
        }

        public List<Diagnostic> _2() {
            return this.diags();
        }

        public boolean _3() {
            return this.isProcessingError();
        }

        public boolean _4() {
            return this.isValidationError();
        }

        public long _5() {
            return this.bitPos1b();
        }
    }
}

