/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializer;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.MultiBackgroundInitializerTest;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MultiBackgroundInitializerSupplierTest
extends MultiBackgroundInitializerTest {
    private NullPointerException npe;
    private IOException ioException;
    private FailableConsumer<?, ?> ioExceptionConsumer;
    private FailableConsumer<?, ?> nullPointerExceptionConsumer;

    MultiBackgroundInitializerSupplierTest() {
    }

    @Override
    protected MultiBackgroundInitializerTest.AbstractChildBackgroundInitializer createChildBackgroundInitializer() {
        return new SupplierChildBackgroundInitializer();
    }

    @BeforeEach
    public void setUpException() throws Exception {
        this.npe = new NullPointerException();
        this.ioException = new IOException();
        this.ioExceptionConsumer = cc -> {
            throw this.ioException;
        };
        this.nullPointerExceptionConsumer = cc -> {
            throw this.npe;
        };
    }

    @Test
    void testClose() throws ConcurrentException, InterruptedException {
        MultiBackgroundInitializerTest.AbstractChildBackgroundInitializer childOne = this.createChildBackgroundInitializer();
        MultiBackgroundInitializerTest.AbstractChildBackgroundInitializer childTwo = this.createChildBackgroundInitializer();
        Assertions.assertFalse((boolean)this.initializer.isInitialized(), (String)"Initialized without having anything to initialize");
        this.initializer.addInitializer("child one", (BackgroundInitializer)childOne);
        this.initializer.addInitializer("child two", (BackgroundInitializer)childTwo);
        Assertions.assertFalse((boolean)childOne.getCloseableCounter().isClosed(), (String)"child one closed() succeeded before start()");
        Assertions.assertFalse((boolean)childTwo.getCloseableCounter().isClosed(), (String)"child two closed() succeeded before start()");
        this.initializer.start();
        long startTime = System.currentTimeMillis();
        long waitTime = 3000L;
        long endTime = startTime + 3000L;
        while (!childOne.isStarted() || !childTwo.isStarted()) {
            if (System.currentTimeMillis() <= endTime) continue;
            Assertions.fail((String)"children never started");
            Thread.sleep(50L);
        }
        Assertions.assertFalse((boolean)childOne.getCloseableCounter().isClosed(), (String)"child one close() succeeded after start() but before close()");
        Assertions.assertFalse((boolean)childTwo.getCloseableCounter().isClosed(), (String)"child two close() succeeded after start() but before close()");
        childOne.get();
        childTwo.get();
        Assertions.assertFalse((boolean)childOne.getCloseableCounter().isClosed(), (String)"child one initializing succeeded after start() but before close()");
        Assertions.assertFalse((boolean)childTwo.getCloseableCounter().isClosed(), (String)"child two initializing succeeded after start() but before close()");
        try {
            this.initializer.close();
        }
        catch (Exception e) {
            Assertions.fail();
        }
        Assertions.assertTrue((boolean)childOne.getCloseableCounter().isClosed(), (String)"child one close() did not succeed");
        Assertions.assertTrue((boolean)childOne.getCloseableCounter().isClosed(), (String)"child two close() did not succeed");
    }

    @Test
    void testCloseWithCheckedException() throws Exception {
        SupplierChildBackgroundInitializer childOne = new SupplierChildBackgroundInitializer(this.ioExceptionConsumer);
        this.initializer.addInitializer("child one", (BackgroundInitializer)childOne);
        this.initializer.start();
        long startTime = System.currentTimeMillis();
        long waitTime = 3000L;
        long endTime = startTime + 3000L;
        while (!childOne.isStarted()) {
            if (System.currentTimeMillis() <= endTime) continue;
            Assertions.fail((String)"children never started");
            Thread.sleep(50L);
        }
        childOne.get();
        try {
            this.initializer.close();
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertInstanceOf(ConcurrentException.class, (Object)e);
            Assertions.assertSame((Object)this.ioException, (Object)e.getSuppressed()[0]);
        }
    }

    @Test
    void testCloseWithRuntimeException() throws Exception {
        SupplierChildBackgroundInitializer childOne = new SupplierChildBackgroundInitializer(this.nullPointerExceptionConsumer);
        this.initializer.addInitializer("child one", (BackgroundInitializer)childOne);
        this.initializer.start();
        long startTime = System.currentTimeMillis();
        long waitTime = 3000L;
        long endTime = startTime + 3000L;
        while (!childOne.isStarted()) {
            if (System.currentTimeMillis() <= endTime) continue;
            Assertions.fail((String)"children never started");
            Thread.sleep(50L);
        }
        childOne.get();
        try {
            this.initializer.close();
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertInstanceOf(ConcurrentException.class, (Object)e);
            Assertions.assertSame((Object)this.npe, (Object)e.getSuppressed()[0]);
        }
    }

    @Test
    void testCloseWithTwoExceptions() throws ConcurrentException, InterruptedException {
        SupplierChildBackgroundInitializer childOne = new SupplierChildBackgroundInitializer(this.ioExceptionConsumer);
        SupplierChildBackgroundInitializer childTwo = new SupplierChildBackgroundInitializer(this.nullPointerExceptionConsumer);
        this.initializer.addInitializer("child one", (BackgroundInitializer)childOne);
        this.initializer.addInitializer("child two", (BackgroundInitializer)childTwo);
        this.initializer.start();
        long startTime = System.currentTimeMillis();
        long waitTime = 3000L;
        long endTime = startTime + 3000L;
        while (!childOne.isStarted() || !childTwo.isStarted()) {
            if (System.currentTimeMillis() <= endTime) continue;
            Assertions.fail((String)"children never started");
            Thread.sleep(50L);
        }
        childOne.get();
        childTwo.get();
        try {
            this.initializer.close();
            Assertions.fail();
        }
        catch (Exception e) {
            boolean foundChildOneException = false;
            boolean foundChildTwoException = false;
            for (Throwable t : e.getSuppressed()) {
                if (t.equals(this.ioException)) {
                    foundChildOneException = true;
                }
                if (!t.equals(this.npe)) continue;
                foundChildTwoException = true;
            }
            Assertions.assertTrue((boolean)foundChildOneException);
            Assertions.assertTrue((boolean)foundChildTwoException);
        }
    }

    private static final class SupplierChildBackgroundInitializer
    extends MultiBackgroundInitializerTest.AbstractChildBackgroundInitializer {
        SupplierChildBackgroundInitializer() {
            this(cc -> cc.close());
        }

        SupplierChildBackgroundInitializer(FailableConsumer<?, ?> consumer) {
            try {
                FailableSupplier supplier = this::initializeInternal;
                Field initializer = AbstractConcurrentInitializer.class.getDeclaredField("initializer");
                initializer.setAccessible(true);
                initializer.set((Object)this, supplier);
                Field closer = AbstractConcurrentInitializer.class.getDeclaredField("closer");
                closer.setAccessible(true);
                closer.set((Object)this, consumer);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                Assertions.fail();
            }
        }
    }
}

