/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.help;

import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.cli.help.TextStyle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TextStyleTests {
    public static Stream<Arguments> padTestData() {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        TextStyle.Builder builder = TextStyle.builder();
        builder.setIndent(5);
        builder.setLeftPad(5);
        builder.setMinWidth(4);
        builder.setScalable(true);
        builder.setMaxWidth(Integer.MAX_VALUE);
        builder.setAlignment(TextStyle.Alignment.LEFT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world", "     Hello world"}));
        builder.setAlignment(TextStyle.Alignment.RIGHT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world", "     Hello world"}));
        builder.setAlignment(TextStyle.Alignment.CENTER);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world", "  Hello world   "}));
        builder.setMaxWidth(5);
        builder.setAlignment(TextStyle.Alignment.LEFT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world", "Hello world"}));
        builder.setAlignment(TextStyle.Alignment.RIGHT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world", "Hello world"}));
        builder.setAlignment(TextStyle.Alignment.CENTER);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world", "Hello world"}));
        builder.setMaxWidth(20);
        builder.setAlignment(TextStyle.Alignment.LEFT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world         ", "     Hello world    "}));
        builder.setAlignment(TextStyle.Alignment.RIGHT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "         Hello world", "         Hello world"}));
        builder.setAlignment(TextStyle.Alignment.CENTER);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "    Hello world     ", "    Hello world     "}));
        builder.setMaxWidth(14);
        builder.setAlignment(TextStyle.Alignment.LEFT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "Hello world   ", "Hello world   "}));
        builder.setAlignment(TextStyle.Alignment.RIGHT);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), "   Hello world", "   Hello world"}));
        builder.setAlignment(TextStyle.Alignment.CENTER);
        lst.add(Arguments.of((Object[])new Object[]{builder.get(), " Hello world  ", " Hello world  "}));
        return lst.stream();
    }

    @Test
    void testDefaultStyle() {
        TextStyle underTest = TextStyle.DEFAULT;
        Assertions.assertEquals((Object)TextStyle.Alignment.LEFT, (Object)underTest.getAlignment());
        Assertions.assertTrue((boolean)underTest.isScalable());
        Assertions.assertEquals((int)0, (int)underTest.getLeftPad());
        Assertions.assertEquals((int)0, (int)underTest.getMinWidth());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)underTest.getMaxWidth());
    }

    @ParameterizedTest(name="{index} {0}")
    @MethodSource(value={"padTestData"})
    void testPad(TextStyle underTest, String unindentedString, String indentedString) {
        Assertions.assertEquals((Object)unindentedString, (Object)underTest.pad(false, (CharSequence)"Hello world"), (String)"Unindented string test failed");
        Assertions.assertEquals((Object)indentedString, (Object)underTest.pad(true, (CharSequence)"Hello world"), (String)"Indented string test failed");
    }
}

