/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.cayenne.configuration.event.QueryEvent;
import org.apache.cayenne.map.EJBQLQueryDescriptor;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.util.JUndoableCayenneTextPane;
import org.apache.cayenne.project.validation.EJBQLStatementValidator;
import org.apache.cayenne.swing.components.textpane.JCayenneTextPane;
import org.apache.cayenne.swing.components.textpane.syntax.EJBQLSyntaxConstant;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EjbqlQueryScriptsTab
extends JPanel
implements DocumentListener {
    private static final Logger logger = LoggerFactory.getLogger(EjbqlQueryScriptsTab.class);
    protected ProjectController mediator;
    protected JCayenneTextPane scriptArea;
    private boolean updateDisabled;
    protected EJBQLStatementValidator ejbqlQueryValidator = new EJBQLStatementValidator();

    public EjbqlQueryScriptsTab(ProjectController mediator) {
        this.mediator = mediator;
        this.initView();
    }

    void displayScript() {
        this.scriptArea.setDocumentTextDirect(this.getQuery().getEjbql());
        this.updateDisabled = false;
    }

    private void initView() {
        this.scriptArea = new JUndoableCayenneTextPane(new EJBQLSyntaxConstant());
        this.scriptArea.getDocument().addDocumentListener(this);
        this.scriptArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                try {
                    String text = EjbqlQueryScriptsTab.this.scriptArea.getDocument().getText(e.getOffset(), 1);
                    if (text.equals(" ") || text.equals("\n") || text.equals("\t")) {
                        EjbqlQueryScriptsTab.this.getQuery().setEjbql(EjbqlQueryScriptsTab.this.scriptArea.getDocumentTextDirect());
                        EjbqlQueryScriptsTab.this.validateEJBQL();
                    }
                }
                catch (BadLocationException ex) {
                    logger.warn("Error reading document", ex);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EjbqlQueryScriptsTab.this.getQuery().setEjbql(EjbqlQueryScriptsTab.this.scriptArea.getDocumentTextDirect());
                EjbqlQueryScriptsTab.this.validateEJBQL();
            }
        });
        this.scriptArea.getPane().addFocusListener(new FocusListener(){
            EJBQLValidationThread thread;

            @Override
            public void focusGained(FocusEvent e) {
                this.thread = new EJBQLValidationThread();
                this.thread.start();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.thread.terminate();
            }
        });
        this.scriptArea.getPane().addKeyListener(new KeyListener(){
            boolean pasteOrCut;

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 35 || e.getKeyCode() == 36 || e.getKeyCode() == 37 || e.getKeyCode() == 39 || e.getKeyCode() == 38 || e.getKeyCode() == 65483) {
                    EjbqlQueryScriptsTab.this.getQuery().setEjbql(EjbqlQueryScriptsTab.this.scriptArea.getText());
                    EjbqlQueryScriptsTab.this.validateEJBQL();
                }
                if ((e.getKeyCode() == 86 || e.getKeyCode() == 88) && e.isControlDown()) {
                    this.pasteOrCut = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (this.pasteOrCut && e.getKeyCode() == 17 || e.getKeyCode() == 127) {
                    EjbqlQueryScriptsTab.this.scriptArea.removeHighlightText();
                    EjbqlQueryScriptsTab.this.getQuery().setEjbql(EjbqlQueryScriptsTab.this.scriptArea.getText());
                    EjbqlQueryScriptsTab.this.validateEJBQL();
                    this.pasteOrCut = false;
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.scriptArea, "West");
        this.add((Component)this.scriptArea.getScrollPane(), "Center");
        this.setVisible(true);
    }

    public void initFromModel() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        if (query == null || !"EJBQLQuery".equals(query.getType())) {
            this.setVisible(false);
            return;
        }
        this.scriptArea.setEnabled(true);
        this.displayScript();
        this.validateEJBQL();
        this.setVisible(true);
    }

    EJBQLQueryDescriptor getQuery() {
        QueryDescriptor query = this.mediator.getCurrentQuery();
        return query != null && "EJBQLQuery".equals(query.getType()) ? (EJBQLQueryDescriptor)query : null;
    }

    void setEJBQL(DocumentEvent e) {
        Document doc = e.getDocument();
        try {
            this.setEJBQL(doc.getText(0, doc.getLength()));
        }
        catch (BadLocationException ex) {
            logger.warn("Error reading document", ex);
        }
    }

    void setEJBQL(String text) {
        EJBQLQueryDescriptor query = this.getQuery();
        if (query == null) {
            return;
        }
        if (text != null && text.trim().isEmpty()) {
            text = null;
        }
        if (!Util.nullSafeEquals(text, query.getEjbql())) {
            query.setEjbql(text);
            this.mediator.fireQueryEvent(new QueryEvent((Object)this, query));
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.updateDisabled) {
            this.setEJBQL(e);
        }
    }

    void validateEJBQL() {
        final EJBQLStatementValidator.PositionException positionException = this.ejbqlQueryValidator.validateEJBQL(this.getQuery());
        if (positionException != null && !SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (positionException.getBeginLine() != null || positionException.getBeginColumn() != null || positionException.getLength() != null) {
                        EjbqlQueryScriptsTab.this.scriptArea.setHighlightText(positionException.getBeginLine(), positionException.getBeginColumn(), positionException.getLength(), positionException.getMessage());
                    } else {
                        EjbqlQueryScriptsTab.this.scriptArea.removeHighlightText();
                    }
                }
            });
        }
    }

    class EJBQLValidationThread
    extends Thread {
        volatile boolean running;
        final Object timer;
        int previousCaretPosition;
        int validateCaretPosition;
        static final int DELAY = 500;

        EJBQLValidationThread() {
            super("ejbql-validation-thread");
            this.timer = new Object();
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                int caretPosition = EjbqlQueryScriptsTab.this.scriptArea.getCaretPosition();
                if (this.previousCaretPosition != 0 && this.previousCaretPosition == caretPosition && this.validateCaretPosition != this.previousCaretPosition) {
                    EjbqlQueryScriptsTab.this.validateEJBQL();
                    this.validateCaretPosition = caretPosition;
                }
                this.previousCaretPosition = caretPosition;
                Object object = this.timer;
                synchronized (object) {
                    try {
                        this.timer.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminate() {
            Object object = this.timer;
            synchronized (object) {
                this.running = false;
                this.timer.notify();
            }
        }
    }
}

