/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.mapper.annotations.Update;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.datastax.oss.driver.internal.querybuilder.update.DefaultUpdate;
import com.squareup.javapoet.MethodSpec;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperUpdateStartMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;

    EntityHelperUpdateStartMethodGenerator(EntityDefinition entityDefinition) {
        this.entityDefinition = entityDefinition;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder updateBuilder = MethodSpec.methodBuilder((String)"updateStart").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(DefaultUpdate.class);
        if (!this.entityDefinition.getRegularColumns().iterator().hasNext()) {
            updateBuilder.addStatement("throw new $T($S)", new Object[]{MapperException.class, String.format("Entity %s does not have any non PK columns. %s is not possible", this.entityDefinition.getClassName().simpleName(), Update.class.getSimpleName())});
        } else {
            updateBuilder.addStatement("throwIfKeyspaceMissing()", new Object[0]).addStatement("$1T update = (keyspaceId == null)\n? $2T.update(tableId)\n: $2T.update(keyspaceId, tableId)", new Object[]{UpdateStart.class, QueryBuilder.class}).addCode("$[return (($1T)update", new Object[]{DefaultUpdate.class});
            for (PropertyDefinition property : this.entityDefinition.getRegularColumns()) {
                updateBuilder.addCode("\n.setColumn($1L, $2T.bindMarker($1L))", new Object[]{property.getCqlName(), QueryBuilder.class});
            }
            updateBuilder.addCode(")", new Object[0]);
            updateBuilder.addCode("$];\n", new Object[0]);
        }
        return Optional.of(updateBuilder.build());
    }
}

