/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

public class JavaPoetFiler {
    private final Filer filer;
    private final String indent;

    public JavaPoetFiler(Filer filer, String indent) {
        this.filer = filer;
        this.indent = indent;
    }

    public void write(String fileName, JavaFile.Builder contents) {
        try {
            JavaFileObject file = this.filer.createSourceFile(fileName, new Element[0]);
            try (Writer writer = file.openWriter();){
                contents.indent(this.indent).build().writeTo((Appendable)writer);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

