/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import com.datastax.oss.driver.api.mapper.annotations.Mapper;
import com.squareup.javapoet.ClassName;
import javax.lang.model.element.TypeElement;

public class GeneratedNames {
    private static final String SUFFIX = "__MapperGenerated";
    public static final String GENERIC_TYPE_CONSTANT = "GENERIC_TYPE";

    public static ClassName entityHelper(TypeElement entityClass) {
        return GeneratedNames.entityHelper(ClassName.get((TypeElement)entityClass));
    }

    public static ClassName entityHelper(ClassName entityClassName) {
        return GeneratedNames.peerClass(entityClassName, "Helper__MapperGenerated");
    }

    public static ClassName mapperBuilder(TypeElement mapperInterface) {
        String custom = mapperInterface.getAnnotation(Mapper.class).builderName();
        if (custom.isEmpty()) {
            return GeneratedNames.peerClass(mapperInterface, "Builder");
        }
        int i = custom.lastIndexOf(46);
        return ClassName.get((String)custom.substring(0, i), (String)custom.substring(i + 1), (String[])new String[0]);
    }

    public static ClassName mapperImplementation(TypeElement mapperInterface) {
        return GeneratedNames.peerClass(mapperInterface, "Impl__MapperGenerated");
    }

    public static ClassName daoImplementation(TypeElement daoInterface) {
        return GeneratedNames.peerClass(daoInterface, "Impl__MapperGenerated");
    }

    private static ClassName peerClass(ClassName base, String suffix) {
        ClassName topLevel = base;
        StringBuilder prefix = new StringBuilder();
        while (topLevel.enclosingClassName() != null) {
            topLevel = topLevel.enclosingClassName();
            prefix.insert(0, '_').insert(0, topLevel.simpleName());
        }
        return topLevel.peerClass(prefix.toString() + base.simpleName() + suffix);
    }

    private static ClassName peerClass(TypeElement element, String suffix) {
        return GeneratedNames.peerClass(ClassName.get((TypeElement)element), suffix);
    }
}

