/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.addresstranslation;

import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.addresstranslation.SubnetAddress;
import com.datastax.oss.driver.internal.core.util.AddressUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubnetAddressTranslator
implements AddressTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(SubnetAddressTranslator.class);
    private final List<SubnetAddress> subnetAddresses;
    private final Optional<InetSocketAddress> defaultAddress;
    private final String logPrefix;

    public SubnetAddressTranslator(@NonNull DriverContext context) {
        this.logPrefix = context.getSessionName();
        boolean resolveAddresses = context.getConfig().getDefaultProfile().getBoolean(DefaultDriverOption.ADDRESS_TRANSLATOR_RESOLVE_ADDRESSES, false);
        this.subnetAddresses = context.getConfig().getDefaultProfile().getStringMap(DefaultDriverOption.ADDRESS_TRANSLATOR_SUBNET_ADDRESSES).entrySet().stream().map(e -> {
            String subnetCIDR = ((String)e.getKey()).replaceAll("\"", "");
            String address = (String)e.getValue();
            return new SubnetAddress(subnetCIDR, this.parseAddress(address, resolveAddresses));
        }).collect(Collectors.toList());
        this.defaultAddress = Optional.ofNullable(context.getConfig().getDefaultProfile().getString(DefaultDriverOption.ADDRESS_TRANSLATOR_DEFAULT_ADDRESS, null)).map(address -> this.parseAddress((String)address, resolveAddresses));
        SubnetAddressTranslator.validateSubnetsAreOfSameProtocol(this.subnetAddresses);
        SubnetAddressTranslator.validateSubnetsAreNotOverlapping(this.subnetAddresses);
    }

    private static void validateSubnetsAreOfSameProtocol(List<SubnetAddress> subnets) {
        for (int i = 0; i < subnets.size() - 1; ++i) {
            for (int j = i + 1; j < subnets.size(); ++j) {
                SubnetAddress subnet1 = subnets.get(i);
                SubnetAddress subnet2 = subnets.get(j);
                if (subnet1.isIPv4() == subnet2.isIPv4() || subnet1.isIPv6() == subnet2.isIPv6()) continue;
                throw new IllegalArgumentException(String.format("Configured subnets are of the different protocols: %s, %s", subnet1, subnet2));
            }
        }
    }

    private static void validateSubnetsAreNotOverlapping(List<SubnetAddress> subnets) {
        for (int i = 0; i < subnets.size() - 1; ++i) {
            for (int j = i + 1; j < subnets.size(); ++j) {
                SubnetAddress subnet2;
                SubnetAddress subnet1 = subnets.get(i);
                if (!subnet1.isOverlapping(subnet2 = subnets.get(j))) continue;
                throw new IllegalArgumentException(String.format("Configured subnets are overlapping: %s, %s", subnet1, subnet2));
            }
        }
    }

    @Override
    @NonNull
    public InetSocketAddress translate(@NonNull InetSocketAddress address) {
        InetSocketAddress translatedAddress = null;
        for (SubnetAddress subnetAddress : this.subnetAddresses) {
            if (!subnetAddress.contains(address)) continue;
            translatedAddress = subnetAddress.getAddress();
        }
        if (translatedAddress == null && this.defaultAddress.isPresent()) {
            translatedAddress = this.defaultAddress.get();
        }
        if (translatedAddress == null) {
            translatedAddress = address;
        }
        LOG.debug("[{}] Translated {} to {}", new Object[]{this.logPrefix, address, translatedAddress});
        return translatedAddress;
    }

    @Override
    public void close() {
    }

    @Nullable
    private InetSocketAddress parseAddress(String address, boolean resolve) {
        try {
            InetSocketAddress parsedAddress = AddressUtils.extract(address, resolve).iterator().next();
            LOG.debug("[{}] Parsed {} to {}", new Object[]{this.logPrefix, address, parsedAddress});
            return parsedAddress;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Invalid address %s (%s)", address, e.getMessage()), e);
        }
    }
}

