/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.addresstranslation;

import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

class Subnet {
    private final byte[] subnet;
    private final byte[] networkMask;
    private final byte[] upper;
    private final byte[] lower;

    private Subnet(byte[] subnet, byte[] networkMask) {
        this.subnet = subnet;
        this.networkMask = networkMask;
        byte[] upper = new byte[subnet.length];
        byte[] lower = new byte[subnet.length];
        for (int i = 0; i < subnet.length; ++i) {
            upper[i] = (byte)(subnet[i] | ~networkMask[i]);
            lower[i] = (byte)(subnet[i] & networkMask[i]);
        }
        this.upper = upper;
        this.lower = lower;
    }

    static Subnet parse(String subnetCIDR) throws UnknownHostException {
        List parts = Splitter.on((String)"/").splitToList((CharSequence)subnetCIDR);
        if (parts.size() != 2) {
            throw new IllegalArgumentException("Invalid subnet: " + subnetCIDR);
        }
        boolean isIPv6 = ((String)parts.get(0)).contains(":");
        byte[] subnet = InetAddress.getByName((String)parts.get(0)).getAddress();
        if (Subnet.isIPv4(subnet) && isIPv6) {
            subnet = Subnet.toIPv6(subnet);
        }
        int prefixLength = Integer.parseInt((String)parts.get(1));
        Subnet.validatePrefixLength(subnet, prefixLength);
        byte[] networkMask = Subnet.toNetworkMask(subnet, prefixLength);
        Subnet.validateSubnetIsPrefixBlock(subnet, networkMask, subnetCIDR);
        return new Subnet(subnet, networkMask);
    }

    private static byte[] toNetworkMask(byte[] subnet, int prefixLength) {
        int fullBytes = prefixLength / 8;
        int remainingBits = prefixLength % 8;
        byte[] mask = new byte[subnet.length];
        Arrays.fill(mask, 0, fullBytes, (byte)-1);
        if (remainingBits > 0) {
            mask[fullBytes] = (byte)(255 << 8 - remainingBits);
        }
        return mask;
    }

    private static void validatePrefixLength(byte[] subnet, int prefixLength) {
        int max_prefix_length = subnet.length * 8;
        if (prefixLength < 0 || max_prefix_length < prefixLength) {
            throw new IllegalArgumentException(String.format("Prefix length %s must be within [0; %s]", prefixLength, max_prefix_length));
        }
    }

    private static void validateSubnetIsPrefixBlock(byte[] subnet, byte[] networkMask, String subnetCIDR) {
        byte[] prefixBlock = Subnet.toPrefixBlock(subnet, networkMask);
        if (!Arrays.equals(subnet, prefixBlock)) {
            throw new IllegalArgumentException(String.format("Subnet %s must be represented as a network prefix block", subnetCIDR));
        }
    }

    private static byte[] toPrefixBlock(byte[] subnet, byte[] networkMask) {
        byte[] prefixBlock = new byte[subnet.length];
        for (int i = 0; i < subnet.length; ++i) {
            prefixBlock[i] = (byte)(subnet[i] & networkMask[i]);
        }
        return prefixBlock;
    }

    @VisibleForTesting
    byte[] getSubnet() {
        return Arrays.copyOf(this.subnet, this.subnet.length);
    }

    @VisibleForTesting
    byte[] getNetworkMask() {
        return Arrays.copyOf(this.networkMask, this.networkMask.length);
    }

    byte[] getUpper() {
        return Arrays.copyOf(this.upper, this.upper.length);
    }

    byte[] getLower() {
        return Arrays.copyOf(this.lower, this.lower.length);
    }

    boolean isIPv4() {
        return Subnet.isIPv4(this.subnet);
    }

    boolean isIPv6() {
        return Subnet.isIPv6(this.subnet);
    }

    boolean contains(byte[] ip) {
        if (this.isIPv4() && !Subnet.isIPv4(ip)) {
            return false;
        }
        if (this.isIPv6() && Subnet.isIPv4(ip)) {
            ip = Subnet.toIPv6(ip);
        }
        if (this.subnet.length != ip.length) {
            throw new IllegalArgumentException("IP version is unknown: " + Arrays.toString(Subnet.toZeroBasedByteArray(ip)));
        }
        for (int i = 0; i < this.subnet.length; ++i) {
            if (this.subnet[i] == (byte)(ip[i] & this.networkMask[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isIPv4(byte[] ip) {
        return ip.length == 4;
    }

    private static boolean isIPv6(byte[] ip) {
        return ip.length == 16;
    }

    private static byte[] toIPv6(byte[] ipv4) {
        byte[] ipv6 = new byte[16];
        ipv6[10] = -1;
        ipv6[11] = -1;
        System.arraycopy(ipv4, 0, ipv6, 12, 4);
        return ipv6;
    }

    public String toString() {
        return Arrays.toString(Subnet.toZeroBasedByteArray(this.subnet));
    }

    private static int[] toZeroBasedByteArray(byte[] bytes) {
        int[] res = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            res[i] = bytes[i] & 0xFF;
        }
        return res;
    }
}

