/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.utils.Shared;
import org.slf4j.Logger;

@Shared(scope={Shared.Scope.SIMULATION})
public interface Clock {
    public long nanoTime();

    public long currentTimeMillis();

    default public long nowInSeconds() {
        return this.currentTimeMillis() / 1000L;
    }

    public static void waitUntil(long deadlineNanos) throws InterruptedException {
        long waitNanos = deadlineNanos - Global.nanoTime();
        if (waitNanos > 0L) {
            TimeUnit.NANOSECONDS.sleep(waitNanos);
        }
    }

    public static class Default
    implements Clock {
        @Override
        public long nanoTime() {
            return System.nanoTime();
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }

    public static class Global {
        private static Throwable FAILED_TO_INITIALISE;
        private static String INITIALIZE_MESSAGE;
        private static final Clock instance;

        public static void logInitializationOutcome(Logger logger) {
            if (FAILED_TO_INITIALISE != null) {
                logger.error(INITIALIZE_MESSAGE, FAILED_TO_INITIALISE);
            } else if (INITIALIZE_MESSAGE != null) {
                logger.debug(INITIALIZE_MESSAGE);
            }
            FAILED_TO_INITIALISE = null;
            INITIALIZE_MESSAGE = null;
        }

        public static Clock clock() {
            return instance;
        }

        public static long nanoTime() {
            return instance.nanoTime();
        }

        public static long currentTimeMillis() {
            return instance.currentTimeMillis();
        }

        static {
            String classname = CassandraRelevantProperties.CLOCK_GLOBAL.getString();
            Clock clock = new Default();
            Throwable errorOutcome = null;
            String outcome = null;
            if (classname != null) {
                try {
                    outcome = "Using custom clock implementation: " + classname;
                    clock = (Clock)Class.forName(classname).newInstance();
                }
                catch (Throwable t) {
                    outcome = "Failed to load clock implementation " + classname;
                    errorOutcome = t;
                }
            }
            instance = clock;
            FAILED_TO_INITIALISE = errorOutcome;
            INITIALIZE_MESSAGE = outcome;
        }
    }
}

