/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RegularAndStaticColumns;
import org.apache.cassandra.db.partitions.BTreePartitionData;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.index.transactions.UpdateTransaction;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.Cloner;
import org.apache.cassandra.utils.memory.HeapCloner;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class BTreePartitionUpdater
implements UpdateFunction<Row, Row>,
ColumnData.PostReconciliationFunction {
    final MemtableAllocator allocator;
    final OpOrder.Group writeOp;
    final Cloner cloner;
    final UpdateTransaction indexer;
    public long dataSize;
    long heapSize;
    public long colUpdateTimeDelta = Long.MAX_VALUE;

    public BTreePartitionUpdater(MemtableAllocator allocator, Cloner cloner, OpOrder.Group writeOp, UpdateTransaction indexer) {
        this.allocator = allocator;
        this.cloner = cloner;
        this.writeOp = writeOp;
        this.indexer = indexer;
        this.heapSize = 0L;
        this.dataSize = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BTreePartitionData mergePartitions(BTreePartitionData current, PartitionUpdate update) {
        if (current == null) {
            current = BTreePartitionData.EMPTY;
            this.onAllocatedOnHeap(BTreePartitionData.UNSHARED_HEAP_SIZE);
        }
        try {
            this.indexer.start();
            BTreePartitionData bTreePartitionData = this.makeMergedPartition(current, update);
            return bTreePartitionData;
        }
        finally {
            this.indexer.commit();
            this.reportAllocatedMemory();
        }
    }

    protected BTreePartitionData makeMergedPartition(BTreePartitionData current, PartitionUpdate update) {
        DeletionInfo newDeletionInfo = this.merge(current.deletionInfo, update.deletionInfo());
        RegularAndStaticColumns columns = current.columns;
        RegularAndStaticColumns newColumns = update.columns().mergeTo(columns);
        this.onAllocatedOnHeap(newColumns.unsharedHeapSize() - columns.unsharedHeapSize());
        Row newStatic = this.mergeStatic(current.staticRow, update.staticRow());
        Object[] tree = BTree.update(current.tree, update.holder().tree, update.metadata().comparator, this);
        EncodingStats newStats = current.stats.mergeWith(update.stats());
        this.onAllocatedOnHeap(newStats.unsharedHeapSize() - current.stats.unsharedHeapSize());
        return new BTreePartitionData(newColumns, tree, newDeletionInfo, newStatic, newStats);
    }

    private Row mergeStatic(Row current, Row update) {
        if (update.isEmpty()) {
            return current;
        }
        if (current.isEmpty()) {
            return this.insert(update);
        }
        return this.merge(current, update);
    }

    @Override
    private DeletionInfo merge(DeletionInfo existing, DeletionInfo update) {
        if (update.isLive() || !update.mayModify(existing)) {
            return existing;
        }
        if (!update.getPartitionDeletion().isLive()) {
            this.indexer.onPartitionDeletion(update.getPartitionDeletion());
        }
        if (update.hasRanges()) {
            update.rangeIterator(false).forEachRemaining(this.indexer::onRangeTombstone);
        }
        DeletionInfo newInfo = existing.mutableCopy().add(update.clone(HeapCloner.instance));
        this.onAllocatedOnHeap(newInfo.unsharedHeapSize() - existing.unsharedHeapSize());
        return newInfo;
    }

    @Override
    public Row insert(Row insert) {
        Row data = insert.clone(this.cloner);
        this.indexer.onInserted(insert);
        this.dataSize += (long)data.dataSize();
        this.heapSize += data.unsharedHeapSizeExcludingData();
        return data;
    }

    @Override
    public Row merge(Row existing, Row update) {
        Row reconciled = Rows.merge(existing, update, this);
        this.indexer.onUpdated(existing, reconciled);
        return reconciled;
    }

    @Override
    public Cell<?> merge(Cell<?> previous, Cell<?> insert) {
        if (insert == previous) {
            return insert;
        }
        long timeDelta = Math.abs(insert.timestamp() - previous.timestamp());
        if (timeDelta < this.colUpdateTimeDelta) {
            this.colUpdateTimeDelta = timeDelta;
        }
        if (this.cloner != null) {
            insert = this.cloner.clone(insert);
        }
        this.dataSize += (long)(insert.dataSize() - previous.dataSize());
        this.heapSize += insert.unsharedHeapSizeExcludingData() - previous.unsharedHeapSizeExcludingData();
        return insert;
    }

    @Override
    public ColumnData insert(ColumnData insert) {
        if (this.cloner != null) {
            insert = insert.clone(this.cloner);
        }
        this.dataSize += (long)insert.dataSize();
        this.heapSize += insert.unsharedHeapSizeExcludingData();
        return insert;
    }

    @Override
    public void delete(ColumnData existing) {
        this.dataSize -= (long)existing.dataSize();
        this.heapSize -= existing.unsharedHeapSizeExcludingData();
    }

    @Override
    public void onAllocatedOnHeap(long heapSize) {
        this.heapSize += heapSize;
    }

    public void reportAllocatedMemory() {
        this.allocator.onHeap().adjust(this.heapSize, this.writeOp);
    }
}

