/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.mail.microsoft.oauth.it;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mock.MockEndpoint;

@Path("/mail-microsoft-oauth")
@ApplicationScoped
public class MailMicrosoftOauthResource {

    public static final String USERNAME_PROPERTY = "cq.mail.microsoft.oauth.username";
    public static final String CLIENT_ID_PROPERTY = "cq.mail.microsoft.oauth.client.id";
    public static final String CLIENT_SECRET_PROPERTY = "cq.mail.microsoft.oauth.client.secret";
    public static final String TENANT_ID_PROPERTY = "cq.mail.microsoft.oauth.tenant.id";

    @Inject
    CamelContext context;

    @Path("/load/other/mail-microsoft-oauth")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadOtherMailMicrosoftOauth() throws Exception {
        /* This is an autogenerated test */
        /* No way to test a Camel artifact of kind "other" */
        return Response.ok().build();
    }

    @Path("/getReceived")
    @GET
    @Produces(MediaType.APPLICATION_JSON)
    public List<Map<String, String>> getReceived() {

        MockEndpoint mockResult = context.getEndpoint("mock:receivedMessages", MockEndpoint.class);
        return mockResult.getExchanges().stream().map(
                e -> {
                    MailMessage mailMessage = e.getMessage(MailMessage.class);
                    try {
                        return Map.of("subject", mailMessage.getMessage().getSubject(),
                                "content", mailMessage.getBody(String.class).trim());
                    } catch (MessagingException ex) {
                        return Map.of("subject", "Error: " + ex.getMessage(),
                                "content", mailMessage.getBody(String.class).trim());
                    }
                }).collect(Collectors.toList());
    }

    @GET
    @Path("/route/{routeId}/{operation}")
    @Produces(MediaType.TEXT_PLAIN)
    public String controlRoute(@PathParam("routeId") String routeId, @PathParam("operation") String operation)
            throws Exception {
        switch (operation) {
        case "stop":
            context.getRouteController().stopRoute(routeId);
            break;
        case "start":
            context.getRouteController().startRoute(routeId);
            break;
        case "status":
            return context.getRouteController().getRouteStatus(routeId).name();
        }
        return null;
    }

}
