/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.dfdl.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.FluentProducerTemplate;
import org.jboss.logging.Logger;

@Path("/dfdl")
@ApplicationScoped
public class DfdlResource {

    private static final Logger LOG = Logger.getLogger(DfdlResource.class);

    private static final String COMPONENT_DFDL = "dfdl";
    private static final String DATAFORMAT_DFDL = "dfdl";
    @Inject
    CamelContext context;
    @Inject
    FluentProducerTemplate fluentProducerTemplate;

    @Path("/load/component/dfdl")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentDfdl() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_DFDL) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_DFDL);
        return Response.status(500, COMPONENT_DFDL + " could not be loaded from the Camel context").build();
    }

    @Path("/parse")
    @POST
    @Produces(MediaType.TEXT_PLAIN)
    public String parse(String ediString) throws Exception {
        return fluentProducerTemplate.to("direct:parse").withBody(ediString).request(String.class);
    }

    @Path("/unparse")
    @POST
    @Produces(MediaType.TEXT_PLAIN)
    public String unparse(String xmlString) throws Exception {
        return fluentProducerTemplate.to("direct:unparse").withBody(xmlString).request(String.class);
    }

    @Path("/load/dataformat/dfdl")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadDataformatDfdl() throws Exception {
        /* This is an autogenerated test */
        if (context.resolveDataFormat(DATAFORMAT_DFDL) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", DATAFORMAT_DFDL);
        return Response.status(500, DATAFORMAT_DFDL + " could not be loaded from the Camel context").build();
    }

    @Path("/marshal")
    @POST
    @Produces(MediaType.TEXT_PLAIN)
    public String marshal(String xmlString) throws Exception {
        return fluentProducerTemplate.to("direct:marshal").withBody(xmlString).request(String.class);
    }

    @Path("/unmarshal")
    @POST
    @Produces(MediaType.TEXT_PLAIN)
    public String unmarshal(String ediString) throws Exception {
        return fluentProducerTemplate.to("direct:unmarshal").withBody(ediString).request(String.class);
    }
}
