/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.RequestRecord;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class SyncRequestProcessorMetricTest {
    ZooKeeperServer zks;
    RequestProcessor nextProcessor;
    CountDownLatch allRequestsFlushed;

    @BeforeEach
    public void setup() throws Exception {
        ZKDatabase db = (ZKDatabase)Mockito.mock(ZKDatabase.class);
        Mockito.when((Object)db.append((Request)ArgumentMatchers.any(Request.class))).thenReturn((Object)true);
        ((ZKDatabase)Mockito.doAnswer(invocation -> {
            Thread.sleep(100L);
            return null;
        }).when((Object)db)).commit();
        this.zks = (ZooKeeperServer)Mockito.mock(ZooKeeperServer.class);
        Mockito.when((Object)this.zks.getZKDatabase()).thenReturn((Object)db);
        this.nextProcessor = (RequestProcessor)Mockito.mock(RequestProcessor.class);
        ((RequestProcessor)Mockito.doAnswer(invocationOnMock -> {
            this.allRequestsFlushed.countDown();
            return null;
        }).when((Object)this.nextProcessor)).processRequest((Request)ArgumentMatchers.any(Request.class));
    }

    private Request createRquest(long sessionId, int xid) {
        return new Request(null, sessionId, xid, 5, RequestRecord.fromBytes((byte[])new byte[10]), null);
    }

    @Test
    public void testSyncProcessorMetrics() throws Exception {
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this.zks, this.nextProcessor);
        for (int i = 0; i < 500; ++i) {
            syncProcessor.processRequest(this.createRquest(1L, i));
        }
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)500L, (Object)values.get("sync_processor_request_queued"));
        this.allRequestsFlushed = new CountDownLatch(500);
        syncProcessor.start();
        this.allRequestsFlushed.await(5000L, TimeUnit.MILLISECONDS);
        values = MetricsUtils.currentServerMetrics();
        Assertions.assertEquals((Object)501L, (Object)values.get("cnt_sync_processor_queue_size"));
        Assertions.assertEquals((Object)500L, (Object)values.get("max_sync_processor_queue_size"));
        Assertions.assertEquals((Object)0L, (Object)values.get("min_sync_processor_queue_size"));
        Assertions.assertEquals((Object)500L, (Object)values.get("cnt_sync_processor_queue_time_ms"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_sync_processor_queue_time_ms")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)500L, (Object)values.get("cnt_sync_processor_queue_and_flush_time_ms"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_sync_processor_queue_and_flush_time_ms")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)500L, (Object)values.get("cnt_sync_process_time"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_sync_process_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)500L, (Object)values.get("max_sync_processor_batch_size"));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_sync_processor_queue_flush_time_ms"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_sync_processor_queue_flush_time_ms")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(100L)));
        syncProcessor.shutdown();
    }
}

