/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.sc;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerManager;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerRegistry;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;

public class LocalStorageContainerManager
extends AbstractLifecycleComponent<StorageConfiguration>
implements StorageContainerManager {
    private final Endpoint myEndpoint;
    private final int numStorageContainers;
    private final StorageContainerRegistry registry;

    public LocalStorageContainerManager(Endpoint myEndpoint, StorageConfiguration conf, StorageContainerRegistry scRegistry, int numStorageContainers) {
        super("local-storage-container-manager", (ComponentConfiguration)conf, (StatsLogger)NullStatsLogger.INSTANCE);
        this.myEndpoint = myEndpoint;
        this.registry = scRegistry;
        this.numStorageContainers = numStorageContainers;
    }

    public Endpoint getStorageContainer(long scId) {
        return this.myEndpoint;
    }

    protected void doStart() {
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)this.numStorageContainers);
        for (int scId = 0; scId < this.numStorageContainers; ++scId) {
            futures.add(this.registry.startStorageContainer((long)scId));
        }
        FutureUtils.collect((List)futures).join();
    }

    protected void doStop() {
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)this.numStorageContainers);
        for (int scId = 0; scId < this.numStorageContainers; ++scId) {
            futures.add(this.registry.stopStorageContainer((long)scId));
        }
        FutureUtils.collect((List)futures).join();
    }

    protected void doClose() throws IOException {
    }
}

