/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.Injector;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PluginHelper;

public class DefaultInjector
implements Injector {
    protected final CamelContext camelContext;
    protected final CamelBeanPostProcessor postProcessor;

    public DefaultInjector(CamelContext context) {
        this.camelContext = context;
        this.postProcessor = PluginHelper.getBeanPostProcessor((CamelContext)this.camelContext);
    }

    public <T> T newInstance(Class<T> type) {
        return this.newInstance(type, true);
    }

    public <T> T newInstance(Class<T> type, String factoryMethod) {
        return this.newInstance(type, null, factoryMethod);
    }

    public <T> T newInstance(Class<T> type, Class<?> factoryClass, String factoryMethod) {
        Class<Object> target = factoryClass != null ? factoryClass : type;
        T answer = null;
        try {
            Method fm = target.getMethod(factoryMethod, new Class[0]);
            if (Modifier.isStatic(fm.getModifiers()) && Modifier.isPublic(fm.getModifiers()) && fm.getReturnType() != Void.class) {
                Object obj = fm.invoke(null, new Object[0]);
                answer = type.cast(obj);
            }
            CamelContextAware.trySetCamelContext(answer, (CamelContext)this.camelContext);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error invoking factory method: " + factoryMethod + " on class: " + String.valueOf(target), (Throwable)e);
        }
        return answer;
    }

    public <T> T newInstance(Class<T> type, boolean postProcessBean) {
        Object answer = ObjectHelper.newInstance(type);
        CamelContextAware.trySetCamelContext((Object)answer, (CamelContext)this.camelContext);
        if (postProcessBean) {
            this.applyBeanPostProcessing(answer);
        }
        return (T)answer;
    }

    public boolean supportsAutoWiring() {
        return false;
    }

    protected <T> void applyBeanPostProcessing(T bean) {
        try {
            this.postProcessor.postProcessBeforeInitialization(bean, bean.getClass().getName());
            this.postProcessor.postProcessAfterInitialization(bean, bean.getClass().getName());
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Error during post processing of bean: " + String.valueOf(bean), (Throwable)e);
        }
    }
}

