CLS
PRINT "This program allows you to send control codes to the MOTOROLA GPS receivers."
PRINT
PRINT "You could do this with a dumb terminal, but you would need to enter the "
PRINT "exact checksum characters before the GPS receiver will recognize the"
PRINT "command.  This program computes the checksum characters and automatically"
PRINT "inserts them on the end.."
PRINT
PRINT
PRINT
INPUT "To which COM port is your GPS connected (1/2)"; p$
IF p$ = "" THEN p$ = "1"


CLS
PRINT
PRINT "PREPARING TO SEND THE BINARY COMMAND TO SHIFT THE GPS FROM BINARY TO NMEA"
PRINT
PRINT "If the receiver is in an unknown status, or known to be in the Motorola"
PRINT "Binary mode, then you need to send this command.  It should be sent at the"
PRINT "default Binary speed of 9600 baud.  This program will use 9600 baud..."
PRINT
PRINT
PRINT " MODE COMMAND:       @@Ci^a+CRLF"
PRINT " where                ||| || | *- LINE FEED CHARACTER"
PRINT "                      ||| || *--- Carriage Return character"
PRINT "                      ||| |*----- Check sum (+) for this exact string"
PRINT "                      ||| *------ Control A (sent as a single 8 bit char)"
PRINT "                      ||*-------- lower case i"
PRINT "                      |*--------- capital C"
PRINT "                      *---------- @@ characters"
PRINT
INPUT "Proceed to place the receiver in to NMEA mode (y/n) (N)"; A$
IF UCASE$(A$) = "Y" THEN
   PRINT
   PRINT "Sending NMEA mode command at 9600 baud..."
   OPEN "COM" + p$ + ":9600,N,8,1,CS0,CD0,DS0" FOR RANDOM AS #1
   PRINT #1,
   PRINT #1, "@@Ci"; CHR$(1); "+"; CHR$(13); CHR$(10);
   CLOSE #1
END IF


CLS
PRINT "Now re-opening the COM port at the default NMEA 4800 baud rate..."
PRINT

OPEN "COM" + p$ + ":4800,N,8,1,CS0,CD0,DS0" FOR RANDOM AS #1
PRINT "DONE!"
PRINT
PRINT

Again:

PRINT "Now send a Motorola command to enable any selected NMEA string in the"
PRINT "following list.  The RAW format for the command is as follows:"
PRINT
PRINT "     $PMOTG,GGA,xxxx*ccCRLF   Where cc is the XOR checksum of all"
PRINT "                              characters between the $ and the *."
PRINT "                              then end the line with CR/LF.  The"
PRINT "                              xxxx (4 digits) is the periodicity"
PRINT "                              of that NMEA command in seconds."
PRINT
PRINT "Other NMEA sentences are:     GGA,GLL,RMC,GSA,GSV,VTG,ZDA"
PRINT ""
PRINT "To return to BINARY, send the NMEA command: $PMOTG,FOR,0*ccCRLF"
PRINT ""
PRINT "To send the command, type all characters between the $PMOTG,... and *."
PRINT "To view the receiver output, type VIEW."
PRINT "To end this program, type END."
PRINT ""

DO

   LINE INPUT "Enter the desired command string (or VIEW or END) > "; S$
   S$ = UCASE$(S$): IF S$ = "END" THEN STOP
   IF S$ = "VIEW" THEN EXIT DO

   IF RIGHT$(S$, 1) = "*" THEN S$ = LEFT$(S$, LEN(S$) - 1)
   S$ = "PMOTG," + S$
   cs = 0
   FOR i = 1 TO LEN(S$)
       cs = cs XOR ASC(MID$(S$, i, 1))
   NEXT i
   Cmd$ = "$" + S$ + "*" + RIGHT$("0" + HEX$(cs), 2)
   PRINT Cmd$: PRINT #1, Cmd$; CHR$(13); CHR$(10);
LOOP

CLS
LOCATE 25, 1: PRINT "Hit ESC to return to menu...";
LOCATE 1, 1


DO
A$ = INPUT$(LOC(1), 1)
REM If you get an error here, then your GPS is still outputting BINARY and
REM never got set to NMEA.  Restart the program and be sure to indicate the
REM correct COM port and to answer (Y)es to SEND THE NMEA MODE COMMAND.
PRINT A$;
IF INKEY$ = CHR$(27) THEN EXIT DO
LOOP
CLS
GOTO Again
END

