/*
 *	Tracing routines for BPQ Ethernet
 */
#include <stdio.h>
#include "listen.h"

void bpq_dump(unsigned char *data, int length, int hexdump)
{
	int len;

	lprintf(T_BPQ, "BPQ Ether: %02X:%02X:%02X:%02X:%02X:%02X->%02X:%02X:%02X:%02X:%02X:%02X\n",
		data[6], data[7], data[8], data[9], data[10], data[11],
		data[0], data[1], data[2], data[3], data[4], data[5]);

	len = data[14] + data[15] * 256 - 5;

	ax25_dump(data + 16, len, hexdump);
}
