/*
 *  Handles the properties
 */
#include <gnome.h>
#include "main.h"
#include "props.h"

typedef struct {
	GtkWidget *dlg;
	GtkWidget *table;
	GtkWidget *update;
        GtkWidget *mheardfile;
	struct mhapp *app;
} PropDlg;

static void prop_set(GnomePropertyBox *pb, gint page, PropDlg *dlg)
{
	dlg->app->update_time =  atol(gtk_entry_get_text(GTK_ENTRY(dlg->update)));
        g_free(dlg->app->mheard_file);
        dlg->app->mheard_file = g_strdup(gtk_entry_get_text(GTK_ENTRY(dlg->mheardfile)));
	change_update_time(dlg->app);
}


void prop_load(struct mhapp *app)
{
	app->update_time = gnome_config_get_int("/"APP_NAME"/Misc/Update Time=5000");
        app->mheard_file = g_strdup(gnome_config_get_string("/"APP_NAME"/Misc/Mheard File="DATA_MHEARD_FILE));
}

void prop_save(struct mhapp *app)
{
	 gnome_config_set_int("/"APP_NAME"/Misc/Update Time", app->update_time);
	 gnome_config_set_string("/"APP_NAME"/Misc/Mheard File", app->mheard_file);

	 gnome_config_sync();
}

void prop_dialog(GtkWidget *widget, struct mhapp *app)
{
    GtkWidget *w;
    PropDlg *dlg;
    gchar *s;

    dlg = g_malloc(sizeof(PropDlg));
    dlg->dlg = gnome_property_box_new();
    dlg->app = app;
    s = g_strdup_printf(APP_NAME " - %s", _("Properties"));
    gtk_window_set_title(GTK_WINDOW(dlg->dlg), s);
    g_free(s);
    dlg->table = gtk_table_new(2,2, FALSE);
    w = gtk_label_new(_("Misc"));
    gnome_property_box_append_page(GNOME_PROPERTY_BOX(dlg->dlg),
        dlg->table, w);
    gtk_widget_show(w);
    gtk_widget_show(dlg->table);

    w = gtk_label_new(_("Update Interval (mS)"));
    gtk_table_attach_defaults(GTK_TABLE(dlg->table), w, 0, 1, 0, 1);
    gtk_widget_show(w);

    dlg->update = gtk_entry_new();
    gtk_signal_connect(GTK_OBJECT(dlg->dlg), "apply",
            GTK_SIGNAL_FUNC(prop_set), dlg);

    gtk_table_attach_defaults(GTK_TABLE(dlg->table), dlg->update, 1, 2, 0, 1);
    s = g_strdup_printf("%d", app->update_time);
    gtk_entry_set_text(GTK_ENTRY(dlg->update), s);
    g_free(s);
    gtk_signal_connect_object(GTK_OBJECT(dlg->update), "changed",
            GTK_SIGNAL_FUNC(gnome_property_box_changed),
            GTK_OBJECT(dlg->dlg));
    gtk_widget_show(dlg->update);

    w = gtk_label_new(_("Mheard Data Filename"));
    gtk_table_attach_defaults(GTK_TABLE(dlg->table), w, 0, 1, 1, 2);
    gtk_widget_show(w);

    dlg->mheardfile = gtk_entry_new();
    gtk_table_attach_defaults(GTK_TABLE(dlg->table), dlg->mheardfile, 1, 2, 1, 2);
    gtk_entry_set_text(GTK_ENTRY(dlg->mheardfile), app->mheard_file);

    gtk_signal_connect_object(GTK_OBJECT(dlg->mheardfile), "changed",
            GTK_SIGNAL_FUNC(gnome_property_box_changed),
            GTK_OBJECT(dlg->dlg));
    gtk_widget_show(dlg->mheardfile);

    gtk_widget_show(dlg->dlg);
}

