#define MAIN

#include "sun.h"

int program_function;

int   d;      /* Tag im Jahr */
Date  date;   /* Datum       */
int	qrb,qtf; /* Entfernung/Richtung */
char  progname[128]; /* Programmname */
char  dirname[128]; /* Verzeichnisname */
int   ipp; /* Zahl der Eintrge im FTZ-Profil */

Location locations[MAXLOCATION+1];
int num_arg[16]; /* Zahlenargumente z.B. fr SHOW/SCATTER */

int month_length[13] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 } ;

int get_program_function(char *program_name)
{
   int func;
   char *p;
   int d;
   
   func=NIL;
   
   /* Abschneiden eines eventuellen Pfad-Namens */
   p=strrchr(program_name,'/');
   if (p==NULL)
   {
      p=program_name;
      strcpy(dirname,".");
   }
   else
   {
      strcpy(dirname,program_name);
      d=(p - program_name);
      dirname[d]=0;
      p++;	/* Zeiger auf Zeichen hinter '/' stellen */
   }
   
   strupr(p);	/* umwandeln in Gro-Buchstaben */
   if (strcmp(p,"HEADING")==0) 		func=HEADING;
   if (strcmp(p,"DISTANCE")==0) 	func=HEADING;
   if (strcmp(p,"HEAD")==0)		func=HEADING;
   if (strcmp(p,"COORDINATES")==0)	func=COORDINATES;
   if (strcmp(p,"LOCATOR")==0)		func=COORDINATES;
   if (strcmp(p,"SUN")==0)		func=SUN;
   if (strcmp(p,"GRAYLINE")==0)		func=GRAYLINE;
   if (strcmp(p,"TRIGPOINT")==0)	func=TRIGPOINT;
   if (strcmp(p,"SCATTER")==0)		func=TRIGPOINT;
   if (strcmp(p,"MOON")==0)		func=MOON;
   if (strcmp(p,"FTZMUF")==0)		func=F_FTZ;
   if (strcmp(p,"FTZ_PROFILE")==0)	func=FTZ_PROF;
   if (strcmp(p,"FTZMUF6")==0)		func=F_FTZ6;
   
   if (func==NIL)
   {
      /* Kann nur bei falscher Installation auftreten */
		printf("%s: Unknown function\n",p);
		exit(-1);
	}
   return (func);   
}

int main(int argc,char *argv[])
{
	char	*p;
	int 	i;
	char	list[128],loc[7];
        int     max_loc,locs,nn;
      
   max_loc=0;	/* Anzahl der gefundenen Eintrge mit 0 initialisieren */
   nn=0;	/* Anzahl der Zahlenargumente */

   /* Funktion des Programms festlegen */
   strcpy(progname,argv[0]);
   program_function=get_program_function(argv[0]);

   /* Alle bergabe-Parameter in den String list kopieren */
   switch(argc)
   {  /* Falls kein bergabeparameter bergeben wurde, */
     	/* dann Fehlermeldung */
      case 1:		   
         print_usage(argv[0]);
         exit(1);
         break;
      case 2:
      	strcpy(list,argv[1]);
         break;
      default:
      	strcpy(list,argv[1]);
         for (i=2;i<argc;i++)
         {
         	strcat(list," ");
            strcat(list,argv[i]);
         }
	}

   p=strtok(list," \t\n");
   while (p)
   {
      while (1)
      {
         /* printf("Testing >>%s<<\n",p); */
         /* Test auf Zahl */
         /* printf("ZAHL:\n"); */
         if (isnum(p))
         {
            num_arg[nn]=atoi(p);
            nn++;
            break;
         }

         /* Test auf Locator */
         /* printf("LOCATOR:\n"); */
         if (isloc(p))
         {
            locations[max_loc]=r_locator(p);
         	max_loc++;
            break;
         }

         /* Suche in User-Datenbank */
         /* printf("USER:\n"); */
         locations[max_loc]=pg_lookup_us_data(strlwr(p));
         if (strcmp(locations[max_loc].pref,"---")!=0)
         {
         	if (strlen(locations[max_loc].name)==0)
            {  
               /* Dann keinen QTH-Eintrag gefunden */
               strcpy(locations[max_loc].pref,"?");
               strcpy(locations[max_loc].name,p);
            }
            max_loc++;
            break;
         }

      	/* Suche in Location.dat*/
         locs=scan_locations(strupr(p),max_loc);	
         /* printf("LOCATION: %d found\n",locs); */

         if (locs!=0)
         {
            max_loc+=locs;
            break;
         }

         /* Test auf Locator-Grofeld, wenn ja, dann Mittelpunkt benutzen */
         if (strlen(p)==4) {
             /* printf("GROSSFELD:\n"); */
             strcpy(loc,p);
             strcat(loc,"LL");
             /* printf("P: %s\n",loc); */
             if (isloc(loc))
             {
                locations[max_loc]=r_locator(loc);
             	max_loc++;
                break;
             }
         }

         /* Suche in DXCC-DB */
         /* printf("DXCC:\n"); */
         locs=pg_lookup_dxcc_pfx(strlwr(p),max_loc);
         /* if (locs!=0) */
         if (strcmp(locations[max_loc].pref,"---")!=0)
         {
      	    max_loc+=locs;
            break;
         }

         /* Es wurde kein Eintrag gefunden */
         strcpy(locations[max_loc].pref,"#");
         strcpy(locations[max_loc].name,p);
         max_loc++;
         break;
      }
      p=strtok(NULL," \t\n");
      /* printf("--\n"); */

   }
   /* Abhngig von der Programm-Funktion die Parameterliste abarbeiten */
   switch(program_function)
   {
      case SUN:
         	sh_sun(max_loc);
            break;
      case GRAYLINE:
         	sh_grayline(max_loc);
            break;
      case HEADING:
         	sh_head(max_loc);
            break;
      case COORDINATES:
         	sh_coordinates(max_loc);
            break;
      case TRIGPOINT:
         	sh_trigpoint(max_loc,nn);
            break;
      case MOON:
         	sh_moon(max_loc);
            break;
      case F_FTZ:
         	sh_ftz(max_loc);
            break;
      case F_FTZ6:
         	sh_ftz6(max_loc);
            break;
      case FTZ_PROF:
         	sh_ftz_profile(0);
            break;
      default:
         break;
   }
	exit(0);
}
