/************************/
/* Defines  		*/
/************************/

/* #define DEBUG		1 */
#define F_NIL		0       /* Dummy-Funktion   */
#define PI M_PI
#define MAXLOCATION 1000

#define PP 10
#define PROF1 "B=1.8/G=0.8/A=44/P=5 \
 B=3.5/G=3.5/A=42/P=5 \
 B=7/G=4.1/A=35/P=5 \
 B=10.1/G=3.5/A=25/P=5 \
 B=14/G=3.5/A=18/P=5 \
 B=18/G=4.7/A=14/P=5 \
 B=21/G=5.3/A=12/P=5 \
 B=24.9/G=5.0/A=11/P=5 \
 B=28/G=4.5/A=10/P=5"

#define PROF2 "B=1.8/G=0.8/A=44/P=100 \
 B=3.5/G=3.5/A=42/P=100 \
 B=7/G=4.1/A=35/P=100 \
 B=10.1/G=3.5/A=25/P=100 \
 B=14/G=3.5/A=18/P=100 \
 B=18/G=4.7/A=14/P=100 \
 B=21/G=5.3/A=12/P=100 \
 B=24.9/G=5.0/A=11/P=100 \
 B=28/G=4.5/A=10/P=100"

#define PROF3 "B=1.8/G=-10.0/A=8/P=100 \
 B=3.5/G=-6.2/A=9/P=100 \
 B=7/G=-3.6/A=10/P=100 \
 B=10.1/G=-3.7/A=10/P=100 \
 B=14/G=-3.0/A=10/P=100 \
 B=18/G=-3.0/A=10/P=100 \
 B=21/G=-3.0/A=10/P=100 \
 B=24.9/G=-3.0/A=10/P=100 \
 B=28/G=-3.0/A=10/P=100\0"

#define PROF4 "B=1.8/G=3.3/A=43/P=100 \
 B=3.5/G=4.5/A=39/P=100 \
 B=7/G=3.4/A=23/P=100 \
 B=10.1/G=4.3/A=16/P=100 \
 B=14/G=9.0/A=11/P=100 \
 B=18/G=9.3/A=9/P=100 \
 B=21/G=9.5/A=8/P=100 \
 B=24.9/G=9.7/A=7/P=100 \
 B=28/G=9.8/A=6/P=100"

#define PROF5 "B=1.8/G=-3.0/A=6/P=1000 \
 B=3.5/G=-2.6/A=8/P=1000 \
 B=7/G=8.3/A=13/P=1000 \
 B=10.1/G=9.1/A=10/P=1000 \
 B=14/G=11.6/A=7/P=1000 \
 B=18/G=11.8/A=6/P=1000 \
 B=21/G=12.0/A=5/P=1000 \
 B=24.9/G=12.1/A=5/P=1000 \
 B=28/G=12.2/A=4/P=1000"

#define DEFAULT_FTZ_DATA PROF3

typedef struct  /* enthlt Stationsprofil */
{
	float mhz[PP];
	float gain[PP];
	float minang[PP];
	float power[PP];
} Station_Profile;

/********************************************/
/* Globale Variablen                        */
/********************************************/

#ifndef MAIN
extern int program_function;	/* legt die Funktion des Programms fest */
extern int     d;      /* Tag im Jahr */
extern Date    date;   /* Datum       */
extern Location target_location;
extern Location user_location;
extern int p_ssn;
extern int p_jahr;
extern int p_monat;
extern float p_x1;
extern float p_x2;
extern float p_y1;
extern float p_y2;
extern char *p_ps;
extern char *p_call1;
extern char *p_call2;
extern struct tm now;
extern time_t tim;
extern int ipp;
#endif


/********************************************/
/* Globale Funktionen                       */
/********************************************/

Location pg_lookup_us_data(char *user_call);
int pg_lookup_ssn();
Station_Profile pg_lookup_stn_profile();
void ftz_kern(int p_ssn,int p_jahr,int p_monat, float p_x1,
     float p_y1, float p_x2, float p_y2, char *p_ps, char *p_call1, 
     char *p_call2);
/* float angm(float f); geht noch nicht, da in ftz_kern.c noch nicht umgestellt */
float zkw(float f);
float sag(float f);
