/*#define DEBUG*/ 
#include <stdio.h>
#include <stdlib.h>

#include "ftz.h"
#include "libpq-fe.h"
/* #include "adv_txt.h" */
#include "output.h"
#include <math.h>

char *pghost, *pgport, *pgoptions, *pgtty;
PGconn* conn;

void exit_nicely(PGconn* conn)
{
  PQfinish(conn);
}

int pg_init()
{
   int rc;
   char dbName[16];

#ifdef DEBUG
  printf("Start pg_init\n");
#endif

  pghost = NULL;
  pgport = NULL;
  pgoptions = NULL;
  pgtty = NULL;
  strcpy(dbName,"clx_db");

  conn = PQsetdb(pghost, pgport, pgoptions, pgtty, dbName);

  if (PQstatus(conn) == CONNECTION_BAD)
  {
    fprintf(stderr,"Connection to database '%s' failed.\n", dbName);
    fprintf(stderr,"%s",PQerrorMessage(conn));
    exit_nicely(conn);
    rc = 0;
  } 
  else
  {
     rc = 1;
  }
  return(rc);
}

/* Sucht usercall in User-Datenbank                        */
/* Wenn gefunden, dann wird Location-Eintrag zurckgegeben */
/* Falls nicht, dann ist String in location.pref leer      */
/* Falls User gefunden, aber kein Locator eingegeben, dann */
/* dann ist String location.name leer 							  */
Location pg_lookup_us_data(char* user_call)
{
   int lat_deg,lat_min,lon_deg,lon_min;
   char cmd[255];
   char ew,ns;
   PGresult* res;
   Location location;

#ifdef DEBUG
   printf("Start pg_lookup_user\n");
#endif

   pg_init();

   strip_ssid(user_call);
   sprintf(cmd,"select us_qth,us_loc from us_data where us_call='%s';",user_call);

#ifdef DEBUG
   printf("CMD: %s\n",cmd);
#endif

   res = PQexec(conn,cmd);

#ifdef DEBUG
  printf(" gefundene Datensaetze: %d", PQntuples(res));
#endif

   if ( PQntuples(res) < 1 )
   { 
     strcpy(location.pref,"");
   }
   else
   {
      strcpy(location.pref,user_call);
      if ( ( sscanf(PQgetvalue(res,0,1),"%d %d %c %d %d %c",
			&lat_deg,&lat_min,&ns, &lon_deg,&lon_min,&ew ) > 0 ))
      {
 #ifdef DEBUG 
      	printf("LAT: %d %d %c   LON: %d %d %c\n",
            lat_deg,lat_min,ns,lon_deg,lon_min,ew);
 #endif  

      	location.lat = lat_deg;
        location.latmin = lat_min; 
         if (ns == 's') location.lat = -location.lat;
	
      	location.lon=lon_deg;
        location.lonmin = lon_min; 
         if (ew == 'w') location.lon = -location.lon;

         strcpy(location.name,PQgetvalue(res,0,0));
         location.timezone=0.0;
     }
     else
     {
      	strcpy(location.name,"");
     }
  }

  PQclear(res);
  PQfinish(conn);
  return location;
}

/* Sucht s_pfx in DXCC-Datenbank                           */
/* Wenn gefunden, dann wird Location-Eintrag in target_l abgel.*/
/* Wert 0 falls Zugriff fehlte. */
int pg_lookup_dxcc_pfx(char *s_pfx)
{
   PGresult* res;
   char	cmd[255];
   char	c_pfx[16],land_n[80];
   int	i,rows;
   
#ifdef DEBUG
  printf("Start pg_lookup_dxcc_pfx\n");
#endif

  pg_init();

   sprintf(cmd,"select  a.c_pfx, b.s_pfx, b.land_n, b.geo_loc[1],b.geo_loc[2] \
        	from dxcc_pfx a, dxcc_dat b \
                where '%s'::text ~ c_pfx AND a.s_pfx = b.s_pfx;",s_pfx);

#ifdef DEBUG
  printf("CMD: %s\n",cmd);
#endif

  res = PQexec(conn,cmd);
  rows = PQntuples(res);
#ifdef DEBUG
  printf(" gefundene Datensatze: %d",rows);
#endif
  i=0;

  if ( rows >= 0 )
  {
     while (i<rows)
     {
      	 strcpy (c_pfx,PQgetvalue(res,i,1));
         strcpy (land_n,PQgetvalue(res,i,2));
         target_location.lat = atoi(PQgetvalue(res,i,3));
         target_location.lon = -1.0*atoi(PQgetvalue(res,i,4));
         target_location.lonmin = 0.0;
         target_location.latmin = 0.0;
#ifdef DEBUG
 printf("PFX: %-6s NAME: %-20s   LAT: %6.2f LON: %6.2f\n",c_pfx,land_n,
target_location.lat,target_location.lon);
#endif
         strcpy(target_location.pref,c_pfx);
         strcpy(target_location.name,land_n);
         target_location.timezone=0.0;
         i++;
     }
  }
  PQclear(res);
  PQfinish(conn);
  return (1);
}
/* Ermitteln des letzten Eintrags von SSN aus den WWV-Daten */
int pg_lookup_SSN()

{
   int SSN,rows; 
   WWV WWVbuf; 
   char cmd[255];
   PGresult* res;
   float a=0.7E-03;
   float b=0.75;
   float c=66.0;

#ifdef DEBUG
   printf("Start pg_lookup_SSN\n");
#endif
   SSN = 0;
   pg_init();

   sprintf(cmd,"select wwv_date,wwv_hour,wwv_sfi,wwv_a,wwv_k from wwv_data;");

#ifdef DEBUG
   printf("CMD: %s\n",cmd);
#endif

   res = PQexec(conn,cmd);
#ifdef DEBUG
  printf(" gefundene Datensaetze: %3d ", PQntuples(res));
#endif
   rows = PQntuples(res); 
   if ( rows < 1 )
   { 
     SSN = 0 ; 
   }
   else
   {
      if ( ( sscanf(PQgetvalue(res,rows-1,1),"%d",
	&WWVbuf.wwv_date) > 0 ))
      {
         WWVbuf.wwv_sfi = atoi(PQgetvalue(res,rows-1,2));
         WWVbuf.wwv_time = atoi(PQgetvalue(res,rows-1,1));
         WWVbuf.wwv_date = atoi(PQgetvalue(res,rows-1,0));
/*         strcpy(WWVbuf.wwv_date,PQgetvalue(res,rows-1,0)); */
         WWVbuf.wwv_ssn =
           (int) ((-b+sqrt(b*b-4.0*a*(c- (float) WWVbuf.wwv_sfi)))/(2.0*a));
         SSN = WWVbuf.wwv_ssn;
         printf("\nSolar data :ssn %4d, sfi %4d, time %4d UTC \n",
           WWVbuf.wwv_ssn,WWVbuf.wwv_sfi,WWVbuf.wwv_time);
     }
     else
     {
      SSN = 0; 	
     }
  }

  PQclear(res);
  PQfinish(conn);
  return SSN;
}
