/************************/
/* Defines  		*/
/************************/
#define USAGE       1231 /* usage: sh/ftz Prefix [l] [kW] [Gain] [Elev] [SSN]*/
#define NOAVAIL     1232 /* data base not online */
#define NOINDB      1203 /* cant fine Prefix */ 
#define FTZ_HEAD    1224 /* FTZMUF Ausbreitungsrechnung */
#define ENTER_LOC   1212 /* enter your location first ! */
#define FTZ6_HEAD   1234 /* FTZMUF 6m-Ausbreitung */
#define COUNT       1235 /* reserve */ 

#define F_NIL		0       /* Dummy-Funktion   */
#define F_FTZ		1	/* Funktion SH/FTZ */
#define F_FTZ6		2	/* Funktion SH/FTZ6  */
#define MAXLOCATION 1000

typedef struct  /* enthlt Tag/Monat */
{
	int	day;
	int	month;
	char	lit_month[16];
} Date;

typedef struct  /* QTH-Record */
{
        char pref[10];
        char name[31];
        float  timezone;
        double lat;
        double lon;
        double latmin;
        double lonmin;
} Location;

typedef struct /* Solardaten */
{        int   wwv_ssn;
         int   wwv_sfi;
         int   wwv_a;
         int   wwv_k;
         int   wwv_date;
         int   wwv_time;
         char  wwv_fcast;
} WWV;

typedef struct /* user daten */
{        char user_call;
         char user_loc;
         char user_qth;
         int  user_koord;
} userdata;

/********************************************/
/* Globale Variablen                        */
/********************************************/

#ifndef MAIN
extern int program_function;	/* legt die Funktion des Programms fest */
extern int     d;      /* Tag im Jahr */
extern Date    date;   /* Datum       */
extern Location target_location;
extern Location user_location;
extern int p_ssn;
extern int p_jahr;
extern int p_monat;
extern float p_x1;
extern float p_x2;
extern float p_y1;
extern float p_y2;
extern char *p_ps;
extern char *p_call1;
extern char *p_call2;
#endif


/********************************************/
/* Globale Funktionen                       */
/********************************************/

char *min2tim(int time);
char *strip_ssid(char *s);
char *get_date();
char *strupr(char *s);
char *strlwr(char *s);
Location r_locator(char *loc);
int scan_locations(char *s_pfx);
Location pg_lookup_us_data(char *user_call);
int pg_lookup_dxcc_pfx(char *s_pfx);
int pg_lookup_SSN();
void ftz_kern(int p_ssn,int p_jahr,int p_monat, float p_x1,
     float p_y1, float p_x2, float p_y2, char *p_ps, char *p_call1, 
     char *p_call2);

