#!/usr/bin/perl
# file: udp_client.pl

use IO::Socket;
use strict;
use constant MAXLEN => 1024;

my $host = shift || 'localhost';
my $port = shift || 'echo';

my $S = IO::Socket::INET->new(Proto    => 'udp',
                              Type     => SOCK_DGRAM
                              ) || die "can't make socket: $!";

$port = getservbyname($port,'udp') unless $port=~/^\d+$/;
my $dest = sockaddr_in($port,inet_aton($host));

my $child = fork();
die "Can't fork: $!" unless defined $child;

send_data($S,$dest,$child) unless $child;
receive_data($S)           if $child;
close $S;

sub send_data {
    my ($sock,$dest,$child) = @_;
    $sock->send($_,0,$dest) || die "send(): $!" while <>;
    kill 'TERM' => $child;
}

sub receive_data {
    my $sock = shift;
    my $data;
    while (1) {
        $sock->recv($data,MAXLEN,0) || die "recv(): $!";
        print $data;
    }
}

__END__
