
#ifndef DB_H
#define DB_H

#include <gdbm.h>

#define DB_INSERT	GDBM_INSERT
#define DB_REPLACE	GDBM_REPLACE

struct db_t {
	GDBM_FILE f;
	char *name;
};

extern struct db_t *db_open(char *name);
extern void db_close(struct db_t *dbp);
extern int db_store(struct db_t *dbp, datum key, datum content, int flag);
extern datum db_fetch(struct db_t *dbp, datum key);
extern int db_exists(struct db_t *dbp, datum key);
extern int db_delete(struct db_t *dbp, datum key);
extern datum db_firstkey(struct db_t *dbp);
extern datum db_nextkey(struct db_t *dbp, datum key);
extern void db_reorganize(struct db_t *dbp);
extern void db_sync(struct db_t *dbp);

#endif
