
/*
 *	cmd_cluster.c
 *
 *	cluster user interface commands
 */
 
#include <string.h>

#include "csock.h"
#include "cmd_cluster.h"
#include "hmalloc.h"
#include "network.h"
#include "net_user.h"
#include "cstring.h"
#include "config.h"
#include "cfgfile.h"
#include "timer.h"

int cmd_bye(struct csock_t *s, int argc, char **argv)
{
	csputs(s, "73!\n");
	csflush(s);
	sock_disconnect(s);
	
	return -2;
}

/*
 *	Talking
 */
 
int construct_talk(struct csock_t *s, char *to, int arg, int argc, char **argv)
{
	struct talk_t t;
	struct nuser_t *u;
	char *msg, *tonode = NULL;
	
	time(&t.time);
	hstrncpy(t.fromcall, s->lu->nu->call, sizeof(t.fromcall));
	strcpy(t.fromnodec, (char *)clucall);
	t.via = NULL;
	
	hstrupr(to);
	
	if ((tonode = strchr(to, '@'))) {
		/* User-supplied destination node */
		*tonode = '\0';
		tonode++;
		if (!(t.tonode = get_node((call_t *)tonode))) {
			csprintf(s, "Node %s is not known.\n");
			return 0;
		}
	} else {
		/* Verify that the user exists, get his node */
		if ((u = get_nuser((call_t *)to))) {
			/* To an user */
			t.tonode = u->node;
		} else {
			/* To a node */
			if (!(t.tonode = get_node((call_t *)to))) {
				csprintf(s, "%s is not a known user or node.\n", to);
				return 0;
			}
		}
	}
	
	if (!valid_call((call_t *)to)) {
		csprintf(s, "%s is not a valid callsign.\n", to);
		return 0;
	}
	
	hstrncpy(t.tocall, to, sizeof(t.tocall));
	
	msg = argstr(arg, argc, argv);
	if (strlen(msg) + 1 > sizeof(t.message))
		csprintf(s, "Maximum length of a talk message is %d bytes. Your message was truncated.\n", sizeof(t.message)-1);
	hstrncpy(t.message, msg, sizeof(t.message));
	
	net_talk(&t);
	
	return 0;
}

int cmd_talk(struct csock_t *s, int argc, char **argv)
{
	if (argc <= 2) {
		csputs(s, "Usage: Talk <user[@node]> <message>\n");
		return 0;
	}
	
	return construct_talk(s, argv[1], 2, argc, argv);
}

int cmd_treply(struct csock_t *s, int argc, char **argv)
{
	if (argc <= 1) {
		csputs(s, "Usage: TReply <message>\n");
		return 0;
	}
	
	return construct_talk(s, s->lu->last_talk_from, 1, argc, argv);
}

/*
 *	DX
 */
 
int cmd_dx(struct csock_t *s, int argc, char **argv)
{
	struct dx_t *d;
	unsigned long fr = 0;
	int call_arg = 2;
	int i;
	
	if (argc >= 3) {
		if (!((fr = str2freq(argv[1])))) {
			fr = str2freq(argv[2]);
			call_arg = 1;
		}
	}
	
	if (!fr || argc < 3 || strlen(argv[call_arg]) < 3) {
		csputs(s, "Usage: Dx <frequency> <callsign> [<additional info>]\n");
		return 0;
	}
	
	hstrupr(argv[call_arg]);
	d = hmalloc(sizeof(struct dx_t));
	
	d->time = now - now % 60; /* need to align on minute boundary, otherwice
					we get our own spots back on merge,
					the MID checking looses seconds on
					the PC link */
	
	d->freq = fr;
	hstrncpy(d->call, argv[call_arg], sizeof(d->call));
	hstrncpy(d->fromcall, s->lu->f->call, sizeof(call_t));
	hstrncpy(d->fromnodec, (char *)clucall, sizeof(call_t));
	d->via = NULL;
	d->hops = 0;
	if (argc > 3)
		hstrncpy(d->info, argstr(3, argc, argv), sizeof(d->info));
	else
		*d->info = '\0';
	
	i = net_dx(d);
	
	switch (i) {
	case -1:
		csputs(s, "Duplicate check: Already have this spot.\n");
		break;
	case -2:
		csputs(s, "Bad frequency.\n");
		break;
	case -3:
		csputs(s, "Bad source node or user callsign.\n");
		break;
	default:
	}
	
	return 0;
}

/*
 *	Announce
 */
 
int cmd_announce(struct csock_t *s, int argc, char **argv)
{
	struct ann_t *a;
	
	if (argc < 3) {
		csputs(s, "Usage: Announce Local|Full|<node> <message>\n");
		return 0;
	}
	
	a = hmalloc(sizeof(struct ann_t));
	hstrncpy(a->tonodec, argv[1], sizeof(call_t));
	hstrupr(a->tonodec);
	if (!strcmp(a->tonodec, "F") || !strcmp(a->tonodec, "FULL"))
		strcpy(a->tonodec, "*");
	else if (!strcmp(a->tonodec, "L") || !strcmp(a->tonodec, "LOCAL"))
		strcpy(a->tonodec, (char *)clucall);
	else if (!get_node(&a->tonodec)) {
		csprintf(s, "Node %s not found.\n", a->tonodec);
		hfree(a);
		return 0;
	}
	
	hstrncpy(a->message, argstr(2, argc, argv), sizeof(a->message));
	hstrncpy(a->fromcall, s->lu->f->call, sizeof(call_t));
	hstrncpy(a->fromnodec, (char *)clucall, sizeof(call_t));
	
	a->wx = 0;
	a->sysop = 0;
	a->time = now;
	a->hops = 0;
	a->via = NULL;
	
	net_announce(a);
	
	return 0;
}

/*
 *	Say
 */
 
int cmd_say(struct csock_t *s, int argc, char **argv)
{
	struct ann_t *a;
	
	if (argc < 2) {
		csputs(s, "Usage: Say <message>\n");
		return 0;
	}
	
	a = hmalloc(sizeof(struct ann_t));
	hstrncpy(a->tonodec, (char *)clucall, sizeof(call_t));
	
	hstrncpy(a->message, argstr(1, argc, argv), sizeof(a->message));
	hstrncpy(a->fromcall, s->lu->f->call, sizeof(call_t));
	hstrncpy(a->fromnodec, (char *)clucall, sizeof(call_t));
	
	a->wx = 0;
	a->sysop = 0;
	a->time = now;
	a->hops = 0;
	a->via = NULL;
	
	net_announce(a);
	
	return 0;
}

/*
 *	Shout
 */
 
int cmd_shout(struct csock_t *s, int argc, char **argv)
{
	struct ann_t *a;
	
	if (argc < 2) {
		csputs(s, "Usage: SHout <message>\n");
		return 0;
	}
	
	a = hmalloc(sizeof(struct ann_t));
	hstrncpy(a->tonodec, "*", sizeof(call_t));
	
	hstrncpy(a->message, argstr(1, argc, argv), sizeof(a->message));
	hstrncpy(a->fromcall, s->lu->f->call, sizeof(call_t));
	hstrncpy(a->fromnodec, (char *)clucall, sizeof(call_t));
	
	a->wx = 0;
	a->sysop = 0;
	a->time = now;
	a->hops = 0;
	a->via = NULL;
	
	net_announce(a);
	
	return 0;
}

