
#include <string.h>

#include "command.h"
#include "cstring.h"
#include "cfgfile.h"

 /* ***************************************************************** */

/*
 *	Find the command from the command table and execute it.
 */

int command(struct csock_t *s, struct cmd *cmds, char *cmdline)
{
	struct cmd *cmdp;
	int argc;
	char *argv[256];
	
	if ((argc = parse_args(argv, cmdline)) == 0)
		return 0;
	hstrlwr(argv[0]);
	for (cmdp = cmds; cmdp->function != NULL; cmdp++)
		if (strncasecmp(cmdp->name, argv[0], strlen(argv[0])) == 0)
			break;
	if (cmdp->function == NULL) {
		csprintf(s, "Unknown command: %s\n", argv[0]);
		return -1;
	}
	return (*cmdp->function)(s, argc, argv);
}

