/*
 * Copyright (c) 1983, 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *  This product includes software developed by the University of
 *  California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1983, 1990 The Regents of the University of California.\n\
 All rights reserved.\n";

#endif /* not lint */

/*
 * $Source: /hda4/ftp/source/networking/NetBSD/new/rlogin/rlogin.c,v $
 * $Header: mit/rlogin/RCS/rlogin.c,v 5.2 89/07/26 12:11:21 kfall
 *  Exp Locker: kfall $
 */

/*
 * rmdlogin - remote login with md5 authentication
 *
 * F6FBB Jean-Paul ROUBELAT - Added MD5 - 970512
 *
 */
#define MDLOGIN

#include <sys/param.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <sys/ioctl.h>

#include <netinet/in.h>
#if 0
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#endif
#include <netdb.h>

#ifdef linux
#define USE_TERMIO
#define CQUIT	'\034'
#define CSTART	'\021'
#define CSTOP	'\023'
#define CEOF	'\004'
#endif

#ifdef USE_TERMIO
#include <termios.h>
#define sg_flags c_lflag
#define sg_ospeed c_cflag&CBAUD

#define TIOCGETP TCGETS
#define TIOCSETP TCSETS
#define TIOCSETN TCSETSW
struct termios defmodes;
struct termios ixon_state;

#else
#include <sgtty.h>
#endif
#include <setjmp.h>
#include <varargs.h>
#include <errno.h>
#include <pwd.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#ifdef KERBEROS
#include <kerberosIV/des.h>
#include <kerberosIV/krb.h>

CREDENTIALS cred;
Key_schedule schedule;
int use_kerberos = 1, doencrypt;
char dst_realm_buf[REALM_SZ], *dest_realm = NULL;
extern char *krb_realmofhost ();

#endif

/*
   * rlogin has problems with urgent data when logging into suns which
   * results in the connection being closed with an IO error. SUN_KLUDGE
   * is a work around - the actual bug is probably in tcp.c in the kernel, but
   * I haven't managed to find it yet.
   * Andrew.Tridgell@anu.edu.au (12th March 1993)
 */
#ifdef notdef
#define SUN_KLUDGE
#endif

#ifndef TIOCPKT_WINDOW
#define	TIOCPKT_WINDOW	0x80
#endif

/* concession to Sun */
#ifndef SIGUSR1
#define	SIGUSR1	30
#endif

extern int errno;
int eight, litout, rem;
int dosigwinch;

char *user;

int noescape;
u_char escapechar = '~';

char *speeds[] =
{
	"0", "50", "75", "110", "134", "150", "200", "300", "600", "1200",
	"1800", "2400", "4800", "9600", "19200", "38400"
};

#ifdef sun
struct winsize
{
	unsigned short ws_row, ws_col;
	unsigned short ws_xpixel, ws_ypixel;
};

#endif
struct winsize winsize;

int reader (int omask);

u_char getescape (register char *p);

void doit (long omask);
void done (int status);
void setsignal (int sig, void (*act) (int));
void sigwinch (int sig);
void usage (void);
void msg (char *str);
void copytochild (int sig);
void lostpeer (int sig);
void mode (int f);
void oob_real (void);
void oob (int sig);
void sendwindow (void);
void sigwinch (int sig);
void stop (char cmdc);
void echo (register char c);
void writer (void);
void catch_child (int sig);
void writeroob (int sig);

#ifndef sun
#define	get_window_size(fd, wp)	ioctl(fd, TIOCGWINSZ, wp)
#endif

int main (int argc, char **argv)
{
	extern char *optarg;
	extern int optind;
	struct passwd *pw;
	struct servent *sp;

#ifdef	USE_TERMIO
	struct termios ttyb;

#else
	struct sgttyb ttyb;

#endif
	long omask;
	int argoff, ch, dflag, one, uid;
	char *host, *p, term[1024];

	argoff = dflag = 0;
	one = 1;
	host = user = NULL;

	if ((p = rindex (argv[0], '/')))
		++p;
	else
		p = argv[0];

	if (strcmp (p, "rmdlogin"))
		host = p;

	/* handle "rmdlogin host flags" */
	if (!host && argc > 2 && argv[1][0] != '-')
	{
		host = argv[1];
		argoff = 1;
	}

#ifdef KERBEROS
#define	OPTIONS	"8EKLde:k:l:x"
#else
#define	OPTIONS	"8EKLde:l:"
#endif
	while ((ch = getopt (argc - argoff, argv + argoff, OPTIONS)) != EOF)
		switch (ch)
		{
		case '8':
			eight = 1;
			break;
		case 'E':
			noescape = 1;
			break;
		case 'K':
#ifdef KERBEROS
			use_kerberos = 0;
#endif
			break;
		case 'L':
			litout = 1;
			break;
		case 'd':
			dflag = 1;
			break;
		case 'e':
			escapechar = getescape (optarg);
			break;
#ifdef KERBEROS
		case 'k':
			dest_realm = dst_realm_buf;
			(void) strncpy (dest_realm, optarg, REALM_SZ);
			break;
#endif
		case 'l':
			user = optarg;
			break;
#ifdef CRYPT
#ifdef KERBEROS
		case 'x':
			doencrypt = 1;
			des_set_key (cred.session, schedule);
			break;
#endif
#endif
		case '?':
		default:
			usage ();
		}
	optind += argoff;
	argc -= optind;
	argv += optind;

	/* if haven't gotten a host yet, do so */
	if (!host && !(host = *argv++))
		usage ();

	if (*argv)
		usage ();

	if (!(pw = getpwuid (uid = getuid ())))
	{
		(void) fprintf (stderr, "rmdlogin: unknown user id.\n");
		exit (1);
	}
	if (!user)
		user = pw->pw_name;

	sp = NULL;
#ifdef KERBEROS
	if (use_kerberos)
	{
		sp = getservbyname ((doencrypt ? "eklogin" : "klogin"), "tcp");
		if (sp == NULL)
		{
			use_kerberos = 0;
			warning ("can't get entry for %s/tcp service",
					 doencrypt ? "eklogin" : "klogin");
		}
	}
#endif
	if (sp == NULL)
		sp = getservbyname ("login", "tcp");
	if (sp == NULL)
	{
		(void) fprintf (stderr, "rmdlogin: login/tcp: unknown service.\n");
		exit (1);
	}

	(void) strcpy (term, (p = getenv ("TERM")) ? p : "network");
	if (ioctl (0, TIOCGETP, &ttyb) == 0)
	{
		(void) strcat (term, "/");
		(void) strcat (term, speeds[ttyb.sg_ospeed]);
	}

	(void) get_window_size (0, &winsize);

#ifdef USE_TERMIO
/**** moved before rcmd call so that if get a SIGPIPE in rcmd **/
/**** we will have the defmodes set already. ***/
	(void) ioctl (fileno (stdin), TIOCGETP, &defmodes);
	(void) ioctl (fileno (stdin), TIOCGETP, &ixon_state);
#endif

	(void) signal (SIGPIPE, lostpeer);
	/* will use SIGUSR1 for window size hack, so hold it off */
	omask = sigblock (sigmask (SIGURG) | sigmask (SIGUSR1));

#ifdef KERBEROS
  try_connect:
	if (use_kerberos)
	{
		rem = KSUCCESS;
		errno = 0;
		if (dest_realm == NULL)
			dest_realm = krb_realmofhost (host);

#ifdef CRYPT
		if (doencrypt)
			rem = krcmd_mutual (&host, sp->s_port, user, term, 0,
								dest_realm, &cred, schedule);
		else
#endif /* CRYPT */
			rem = krcmd (&host, sp->s_port, user, term, 0,
						 dest_realm);
		if (rem < 0)
		{
			use_kerberos = 0;
			sp = getservbyname ("login", "tcp");
			if (sp == NULL)
			{
				(void) fprintf (stderr,
								"rmdlogin: unknown service login/tcp.\n");
				exit (1);
			}
			if (errno == ECONNREFUSED)
				warning ("remote host doesn't support Kerberos");
			if (errno == ENOENT)
				warning ("can't provide Kerberos auth data");
			goto try_connect;
		}
	}
	else
	{
#ifdef CRYPT
		if (doencrypt)
		{
			(void) fprintf (stderr,
			   "rmdlogin: the -x flag requires Kerberos authentication.\n");
			exit (1);
		}
#endif /* CRYPT */
		rem = rcmd (&host, sp->s_port, pw->pw_name, user, term, 0);
	}
#else
	rem = rcmd (&host, sp->s_port, pw->pw_name, user, term, 0);
#endif /* KERBEROS */

	if (rem < 0)
		exit (1);

	if (dflag &&
		setsockopt (rem, SOL_SOCKET, SO_DEBUG, &one, sizeof (one)) < 0)
		(void) fprintf (stderr, "rmdlogin: setsockopt: %s.\n",
						strerror (errno));
#ifdef IP_TOS
	one = IPTOS_LOWDELAY;
	if (setsockopt (rem, IPPROTO_IP, IP_TOS, (char *) &one, sizeof (int)) < 0)
		  perror ("rmdlogin: setsockopt TOS (ignored)");

#endif

	(void) setuid (uid);
	doit (omask);

	/*NOTREACHED */
	return 0;
}

int child, defflags, deflflags, tabflag;
char deferase, defkill;

#ifdef USE_TERMIO
char defvtim, defvmin;
struct tchars
{
	char t_intrc;				/* interrupt */
	char t_quitc;				/* quit */
	char t_startc;				/* start output */
	char t_stopc;				/* stop output */
	char t_eofc;				/* end-of-file */
	char t_brkc;				/* input delimiter (like nl) */
};

#ifdef linux
struct ltchars
{
	char t_suspc;				/* stop process */
	char t_dsuspc;				/* delayed stop process */
	char t_rprntc;				/* rprint line */
	char t_flushc;				/* flush output */
	char t_werasc;				/* word erase */
	char t_lnextc;				/* literal next char */
};

#ifndef TIOCPKT_FLUSHWRITE
#define TIOCPKT_FLUSHWRITE 0x02
#define TIOCPKT_NOSTOP 0x10
#define TIOCPKT_DOSTOP 0x20
#endif
#endif

#endif

struct tchars deftc;
struct ltchars defltc;
struct tchars notc =
{-1, -1, -1, -1, -1, -1};
struct ltchars noltc =
{-1, -1, -1, -1, -1, -1};

void doit (long omask)
{
#ifdef	USE_TERMIO
	struct termios sb;

#else
	struct sgttyb sb;

#endif

	(void) ioctl (0, TIOCGETP, (char *) &sb);
	defflags = sb.sg_flags;
#ifdef USE_TERMIO
	tabflag = sb.c_oflag & TABDLY;
	defflags |= ECHO;
	deferase = sb.c_cc[VERASE];
	defkill = sb.c_cc[VKILL];
	sb.c_cc[VMIN] = 1;
	sb.c_cc[VTIME] = 1;
	defvtim = sb.c_cc[VTIME];
	defvmin = sb.c_cc[VMIN];
	deftc.t_quitc = CQUIT;
	deftc.t_startc = CSTART;
	deftc.t_stopc = CSTOP;
	deftc.t_eofc = CEOF;
	deftc.t_brkc = '\n';
	defltc.t_suspc = sb.c_cc[VSUSP];	/* stop process */
#ifdef V_DSUSP
	defltc.t_dsuspc = sb.c_cc[VDSUSP];	/* delayed stop process */
#else
	defltc.t_dsuspc = 255;
#endif
	defltc.t_rprntc = sb.c_cc[VREPRINT];	/* rprint line */
	defltc.t_flushc = sb.c_cc[VDISCARD];	/* flush output */
	defltc.t_werasc = sb.c_cc[VWERASE];		/* word erase */
	defltc.t_lnextc = sb.c_cc[VLNEXT];	/* literal next char */
#else
	tabflag = defflags & TBDELAY;
	defflags &= ECHO | CRMOD;
	deferase = sb.sg_erase;
	defkill = sb.sg_kill;
	(void) ioctl (0, TIOCLGET, (char *) &deflflags);
	(void) ioctl (0, TIOCGETC, (char *) &deftc);
	(void) ioctl (0, TIOCGLTC, (char *) &defltc);
#endif
	notc.t_startc = deftc.t_startc;
	notc.t_stopc = deftc.t_stopc;
	(void) signal (SIGINT, SIG_IGN);
	setsignal (SIGHUP, exit);
	setsignal (SIGQUIT, exit);
#ifdef linux
	(void) signal (SIGCHLD, catch_child);
#endif
	child = fork ();
	if (child == -1)
	{
		(void) fprintf (stderr, "rmdlogin: fork: %s.\n", strerror (errno));
		done (1);
	}
	if (child == 0)
	{
#ifdef linux
		signal (SIGCHLD, SIG_IGN);
#endif
		mode (1);
		if (reader (omask) == 0)
		{
			msg ("connection closed.");
			exit (0);
		}
		sleep (1);
		msg ("\007connection closed.");
		exit (1);
	}

	/*
	 * We may still own the socket, and may have a pending SIGURG (or might
	 * receive one soon) that we really want to send to the reader.  Set a
	 * trap that simply copies such signals to the child.
	 */
	(void) signal (SIGURG, copytochild);
	(void) signal (SIGUSR1, writeroob);
	(void) sigsetmask (omask);
#ifdef	__linux__
	sleep (1);
#else
	(void) signal (SIGCHLD, catch_child);
#endif
	writer ();
	msg ("closed connection.");
	done (0);
}

/* trap a signal, unless it is being ignored. */
void setsignal (int sig, void (*act) ())
{
	int omask = sigblock (sigmask (sig));

	if (signal (sig, act) == SIG_IGN)
		(void) signal (sig, SIG_IGN);
	(void) sigsetmask (omask);
}

void done (int status)
{
	int w, wstatus;

	mode (0);
	if (child > 0)
	{
		/* make sure catch_child does not snap it up */
		(void) signal (SIGCHLD, SIG_DFL);
		if (kill (child, SIGKILL) >= 0)
			while ((w = wait (&wstatus)) > 0 && w != child);
	}
	exit (status);
}

/*
 * This is called when the reader process gets the out-of-band (urgent)
 * request to turn on the window-changing protocol.
 */
void writeroob (int sig)
{
	if (dosigwinch == 0)
	{
		sendwindow ();
		(void) signal (SIGWINCH, sigwinch);
	}
	dosigwinch = 1;
}

void catch_child (int sig)
{
	union wait status;
	int pid;

	for (;;)
	{
		pid = wait3 (&status,
					 WNOHANG | WUNTRACED, (struct rusage *) 0);
		if (pid == 0)
			return;
		/* if the child (reader) dies, just quit */
		if ((pid < 0) || (pid == child && !WIFSTOPPED (status)))
			done ((int) (status.w_termsig | status.w_retcode));
	}
	/* NOTREACHED */
}

/*
 * writer: write to remote: 0 -> line.
 * ~.               terminate
 * ~^Z              suspend rmdlogin process.
 * ~<delayed-suspend char>  suspend rmdlogin process, but leave reader alone.
 */
void writer (void)
{
	register int bol, local, n;
	char c;

	bol = 1;					/* beginning of line */
	local = 0;
	for (;;)
	{
		n = read (STDIN_FILENO, &c, 1);
		if (n <= 0)
		{
			if (n < 0 && errno == EINTR)
				continue;
			break;
		}
		/*
		 * If we're at the beginning of the line and recognize a
		 * command character, then we echo locally.  Otherwise,
		 * characters are echo'd remotely.  If the command character
		 * is doubled, this acts as a force and local echo is
		 * suppressed.
		 */
		if (bol)
		{
			bol = 0;
			if (!noescape && c == escapechar)
			{
				local = 1;
				continue;
			}
		}
		else if (local)
		{
			local = 0;
			if (c == '.' || c == deftc.t_eofc)
			{
				echo (c);
				break;
			}
			if (c == defltc.t_suspc || c == defltc.t_dsuspc)
			{
				bol = 1;
				echo (c);
				stop (c);
				continue;
			}
			if (c != escapechar)
#ifdef CRYPT
#ifdef KERBEROS
				if (doencrypt)
					(void) des_write (rem, &escapechar, 1);
				else
#endif
#endif
					(void) write (rem, &escapechar, 1);
		}

#ifdef CRYPT
#ifdef KERBEROS
		if (doencrypt)
		{
			if (des_write (rem, &c, 1) == 0)
			{
				msg ("line gone");
				break;
			}
		}
		else
#endif
#endif
		if (write (rem, &c, 1) == 0)
		{
			msg ("line gone");
			break;
		}
		bol = c == defkill || c == deftc.t_eofc ||
			c == deftc.t_intrc || c == defltc.t_suspc ||
			c == '\r' || c == '\n';
	}
}


void echo (register char c)
{
	register char *p;
	char buf[8];

	p = buf;
	c &= 0177;
	*p++ = escapechar;
	if (c < ' ')
	{
		*p++ = '^';
		*p++ = c + '@';
	}
	else if (c == 0177)
	{
		*p++ = '^';
		*p++ = '?';
	}
	else
		*p++ = c;
	*p++ = '\r';
	*p++ = '\n';
	(void) write (STDOUT_FILENO, buf, p - buf);
}


void stop (char cmdc)
{
	mode (0);
	(void) signal (SIGCHLD, SIG_IGN);
	(void) kill (cmdc == defltc.t_suspc ? 0 : getpid (), SIGTSTP);
	(void) signal (SIGCHLD, catch_child);
	mode (1);
	sigwinch (SIGWINCH);		/* check for size changes */
}

void sigwinch (int sig)
{
	struct winsize ws;

	if (dosigwinch && get_window_size (0, &ws) == 0 &&
		bcmp (&ws, &winsize, sizeof (ws)))
	{
		winsize = ws;
		sendwindow ();
	}
#ifdef SUN_KLUDGE
	signal (SIGWINCH, sigwinch);
#endif
}

/*
 * Send the window size to the server via the magic escape
 */
void sendwindow (void)
{
	struct winsize *wp;
	char obuf[4 + sizeof (struct winsize)];

	wp = (struct winsize *) (obuf + 4);
	obuf[0] = 0377;
	obuf[1] = 0377;
	obuf[2] = 's';
	obuf[3] = 's';
	wp->ws_row = htons (winsize.ws_row);
	wp->ws_col = htons (winsize.ws_col);
	wp->ws_xpixel = htons (winsize.ws_xpixel);
	wp->ws_ypixel = htons (winsize.ws_ypixel);

#ifdef CRYPT
#ifdef KERBEROS
	if (doencrypt)
		(void) des_write (rem, obuf, sizeof (obuf));
	else
#endif
#endif
		(void) write (rem, obuf, sizeof (obuf));
}

/*
 * reader: read from remote: line -> 1
 */
#define	READING	1
#define	WRITING	2

jmp_buf rcvtop;
int ppid, rcvcnt, rcvstate;
char rcvbuf[8 * 1024];


void oob (int sig)
{
	oob_real ();
#ifdef SUN_KLUDGE
	signal (SIGURG, oob);
#endif
}


void oob_real (void)
{
#ifdef	USE_TERMIO
	struct termios sb;

#else
	struct sgttyb sb;

#endif
	int atmark, n, out, rcvd;
	unsigned char waste[BUFSIZ], mark;

#ifdef	USE_TERMIO
	out = TCOFLUSH;
#else
	out = O_RDWR;
#endif
	rcvd = 0;
	while (recv (rem, &mark, 1, MSG_OOB) < 0)
	{
		sleep (1);
		switch (errno)
		{
		case EWOULDBLOCK:
			/*
			 * Urgent data not here yet.  It may not be possible
			 * to send it yet if we are blocked for output and
			 * our input buffer is full.
			 */
			if (rcvcnt < sizeof (rcvbuf))
			{
				n = read (rem, rcvbuf + rcvcnt,
						  sizeof (rcvbuf) - rcvcnt);
				if (n <= 0)
					return;
				rcvd += n;
			}
			else
			{
				n = read (rem, waste, sizeof (waste));
				if (n <= 0)
					return;
			}
			continue;
		default:
			return;
		}
	}
	if (mark & TIOCPKT_WINDOW)
	{
		/* Let server know about window size changes */
		(void) kill (ppid, SIGUSR1);
	}
	if (!eight && (mark & TIOCPKT_NOSTOP))
	{
		(void) ioctl (0, TIOCGETP, (char *) &sb);
#ifdef	USE_TERMIO
		sb.c_iflag &= ~IXON;
/*      sb.sg_flags &= ~ICANON; */
#else
		sb.sg_flags &= ~CBREAK;
		sb.sg_flags |= RAW;
#ifndef SUN_KLUDGE
		(void) ioctl (0, TIOCSETN, (char *) &sb);
#endif
		notc.t_stopc = -1;
		notc.t_startc = -1;
		(void) ioctl (0, TIOCSETC, (char *) &notc);
#endif
		(void) ioctl (0, TIOCSETN, (char *) &sb);
	}
	if (!eight && (mark & TIOCPKT_DOSTOP))
	{
		(void) ioctl (0, TIOCGETP, (char *) &sb);
#ifdef USE_TERMIO
/*      sb.sg_flags  |= ICANON; */
		sb.c_iflag |= IXON;
#else
		sb.sg_flags &= ~RAW;
		sb.sg_flags |= CBREAK;
		notc.t_stopc = deftc.t_stopc;
		notc.t_startc = deftc.t_startc;
		(void) ioctl (0, TIOCSETC, (char *) &notc);
#endif
		(void) ioctl (0, TIOCSETN, (char *) &sb);
	}
	if (mark & TIOCPKT_FLUSHWRITE)
	{
#ifdef	USE_TERMIO
		(void) ioctl (1, TCFLSH, (char *) out);
#else
		(void) ioctl (1, TIOCFLUSH, (char *) &out);
#endif
		for (;;)
		{
			if (ioctl (rem, SIOCATMARK, &atmark) < 0)
			{
				(void) fprintf (stderr, "rmdlogin: ioctl: %s.\n",
								strerror (errno));
				break;
			}
			if (atmark)
				break;
			n = read (rem, waste, sizeof (waste));
			if (n <= 0)
				break;
		}
		/*
		 * Don't want any pending data to be output, so clear the recv
		 * buffer.  If we were hanging on a write when interrupted,
		 * don't want it to restart.  If we were reading, restart
		 * anyway.
		 */
		rcvcnt = 0;
		longjmp (rcvtop, 1);
	}

	/* oob does not do FLUSHREAD (alas!) */

	/*
	 * If we filled the receive buffer while a read was pending, longjmp
	 * to the top to restart appropriately.  Don't abort a pending write,
	 * however, or we won't know how much was written.
	 */
	if (rcvd && rcvstate == READING)
	{
		longjmp (rcvtop, 1);
	}
}

/* reader: read from remote: line -> 1 */
int reader (int omask)
{
#if !defined(BSD) || BSD < 43
	int pid = -getpid ();

#else
	int pid = getpid ();

#endif
	int n, remaining;
	char *bufp;

#ifdef MDLOGIN
	void mdpass (char *mdhost, char *mduser, char *mdkey, char *rcvbuf, int *rcvcnt);
	int first = 1;
	int first_ofs = 0;
	int i, eol;
	char first_line[256], mdhost[256];
	char mdkey[20];

#endif

	(void) signal (SIGTTOU, SIG_IGN);
	(void) signal (SIGURG, oob);
	ppid = getppid ();
/*  (void)fcntl(rem, F_SETOWN, pid); */
	ioctl (rem, SIOCSPGRP, &pid);	/* @@@ */
	(void) setjmp (rcvtop);
	(void) sigsetmask (omask);

	bufp = rcvbuf;
#ifdef MDLOGIN
	first = 1;
	first_ofs = 0;
#endif

	for (;;)
	{
		while ((remaining = rcvcnt - (bufp - rcvbuf)) > 0)
		{
			rcvstate = WRITING;
			n = write (STDOUT_FILENO, bufp, remaining);
			if (n < 0)
			{
				if (errno != EINTR)
					return (-1);
				continue;
			}
			bufp += n;
		}
		bufp = rcvbuf;
		rcvcnt = 0;
		rcvstate = READING;

#ifdef MDLOGIN
		if (first)
		{
			for (eol = -1, i = 0; i < first_ofs; i++)
				if (first_line[i] == '\r' || first_line[i] == '\n')
				{
					eol = i;
					first = 0;
					break;
				}

			/* Is there a MD key in the line */
			if (eol >= 0 && first_ofs > 12 && first_line[eol - 12] == '[' && first_line[eol - 1] == ']')
			{
				/* Host name */
				for (i = 0; i < first_ofs; i++)
				{
					if (first_line[i] == '>')
					{
						break;
					}
					mdhost[i] = first_line[i];
				}
				mdhost[i] = '\0';

				if (i == first_ofs)
				{
					/* format error */
					printf ("MD-key : host format error\r\n");
					return -1;
				}

				else
				{
					/* MD key */
					memcpy (mdkey, rcvbuf + eol - 11, 10);
					mdkey[10] = '\0';
					mdpass (mdhost, user, mdkey, rcvbuf, &rcvcnt);
					write (rem, rcvbuf, rcvcnt);
					continue;
				}
			}
		}
#endif

#ifdef CRYPT
#ifdef KERBEROS
		if (doencrypt)
			rcvcnt = des_read (rem, rcvbuf, sizeof (rcvbuf));
		else
#endif
#endif
			rcvcnt = read (rem, rcvbuf, sizeof (rcvbuf));

/*
   * If we get a EIO from a read then it may mean that we have unread ungent data
   * waiting that is getting in the way. We probably have got more then one lot of
   * urgent data but we only got one SIGURG due to a problem in the kernel tcp.
   * We can try and fix this by sending ourself a SIGURG and pretending the error
   * never occurred. This might be a problem if we really _should_ be getting
   * a EIO for some unrelated reason. (AJT 3/93)
   *
   * Hmm, I just checked this with the current (NET-2e BETA-1) kernel, and
   * it seems that this patch isn't needed anymore.  FvK 09/20/93
 */
#ifdef XX_SUN_KLUDGE
		if (rcvcnt < 0 && errno == EIO)
		{
			errno = 0;
			kill (getpid (), SIGURG);
			continue;
		}
#endif
		if (rcvcnt == 0)
			return (0);
		if (rcvcnt < 0)
		{
			if (errno == EINTR)
				continue;
			(void) fprintf (stderr, "rmdlogin: read: %s.\n",
							strerror (errno));
			return (-1);
		}

#ifdef MDLOGIN
		if (first)
		{
			/* build the first line */
			if ((first_ofs + rcvcnt) > sizeof (first_line))
			{
				memcpy (first_line + first_ofs, rcvbuf, sizeof (first_line) - first_ofs);
				first = 0;
			}
			else
				memcpy (first_line + first_ofs, rcvbuf, rcvcnt);
			first_ofs += rcvcnt;
		}
#endif

	}
}

void mode (int f)
{
#ifdef	USE_TERMIO
	struct termios sb;

#else
	struct ltchars *ltc;
	struct sgttyb sb;
	struct tchars *tc;
	int lflags;

	(void) ioctl (0, TIOCLGET, (char *) &lflags);
#endif

	(void) ioctl (0, TIOCGETP, (char *) &sb);
	switch (f)
	{
	case 0:
#ifdef USE_TERMIO
		/*
		   **      remember whether IXON was set, so it can be restored
		   **      when mode(1) is next done
		 */
		(void) ioctl (fileno (stdin), TIOCGETP, &ixon_state);
		/*
		   **      copy the initial modes we saved into sb; this is
		   **      for restoring to the initial state
		 */
		(void) memcpy (&sb, &defmodes, sizeof (defmodes));

#else
		sb.sg_flags &= ~(CBREAK | RAW | TBDELAY);
		sb.sg_flags |= defflags | tabflag;
		sb.sg_kill = defkill;
		sb.sg_erase = deferase;
		lflags = deflflags;
		tc = &deftc;
		ltc = &defltc;
#endif
		break;
	case 1:
#ifdef USE_TERMIO
		/*
		   **      turn off output mappings
		 */
		sb.c_oflag &= ~(ONLCR | OCRNL);
		/*
		   **      turn off canonical processing and character echo;
		   **      also turn off signal checking -- ICANON might be
		   **      enough to do this, but we're being careful
		 */
		sb.c_lflag &= ~(ECHO | ICANON | ISIG);
		sb.c_iflag &= ~(ICRNL);
		sb.c_cc[VTIME] = 1;
		sb.c_cc[VMIN] = 1;
		if (eight)
			sb.c_iflag &= ~(ISTRIP);
		/* preserve tab delays, but turn off tab-to-space expansion */
		if ((sb.c_oflag & TABDLY) == TAB3)
			sb.c_oflag &= ~TAB3;
		/*
		   **  restore current flow control state
		 */
		if ((ixon_state.c_iflag & IXON) && !eight)
		{
			sb.c_iflag |= IXON;
		}
		else
		{
			sb.c_iflag &= ~IXON;
		}
		sb.c_cc[VSUSP] = 255;
		sb.c_cc[VEOL] = 255;
		sb.c_cc[VREPRINT] = 255;
		sb.c_cc[VDISCARD] = 255;
		sb.c_cc[VWERASE] = 255;
		sb.c_cc[VLNEXT] = 255;
		sb.c_cc[VEOL2] = 255;
#else /* ! USE_TERMIO */
		sb.sg_flags |= (eight ? RAW : CBREAK);
		sb.sg_flags &= ~defflags;
		/* preserve tab delays, but turn off XTABS */
		if ((sb.sg_flags & TBDELAY) == XTABS)
			sb.sg_flags &= ~TBDELAY;
		tc = &notc;
		sb.sg_kill = sb.sg_erase = -1;
		if (litout)
			lflags |= LLITOUT;
		ltc = &noltc;
#endif
		break;
	default:
		return;
	}
#ifndef	USE_TERMIO
	(void) ioctl (0, TIOCSLTC, (char *) ltc);
	(void) ioctl (0, TIOCSETC, (char *) tc);
	(void) ioctl (0, TIOCLSET, (char *) &lflags);
#endif
	(void) ioctl (0, TIOCSETN, (char *) &sb);
}

void lostpeer (int sig)
{
	(void) signal (SIGPIPE, SIG_IGN);
	msg ("\007connection closed.");
	done (1);
}

/* copy SIGURGs to the child process. */
void copytochild (int sig)
{
	(void) kill (child, SIGURG);
#ifdef SUN_KLUDGE
	signal (SIGCHLD, copytochild);
#endif
}

void msg (char *str)
{
	(void) fprintf (stderr, "rmdlogin: %s\r\n", str);
}

#ifdef KERBEROS
/* VARARGS */
warning (va_alist)
	 va_dcl
{
	va_list ap;
	char *fmt;

	(void) fprintf (stderr, "rmdlogin: warning, using standard rmdlogin: ");
	va_start (ap);
	fmt = va_arg (ap, char *);

	vfprintf (stderr, fmt, ap);
	va_end (ap);
	(void) fprintf (stderr, ".\n");
}
#endif

void usage (void)
{
	(void) fprintf (stderr,
				 "usage: rmdlogin [ -%s]%s[-e char] [ -l username ] host\n",
#ifdef KERBEROS
#ifdef CRYPT
					"8ELx", " [-k realm] ");
#else
					"8EL", " [-k realm] ");
#endif
#else
					"8EL", " ");
#endif
	exit (1);
}

/*
 * The following routine provides compatibility (such as it is) between 4.2BSD
 * Suns and others.  Suns have only a `ttysize', so we convert it to a winsize.
 */
#ifdef sun
get_window_size (int fd, struct winsize *wp)
{
	struct ttysize ts;
	int error;

	if ((error = ioctl (0, TIOCGSIZE, &ts)) != 0)
		return (error);
	wp->ws_row = ts.ts_lines;
	wp->ws_col = ts.ts_cols;
	wp->ws_xpixel = 0;
	wp->ws_ypixel = 0;
	return (0);
}
#endif

u_char getescape (register char *p)
{
	long val;
	int len;

	if ((len = strlen (p)) == 1)	/* use any single char, including '\' */
		return ((u_char) * p);
	/* otherwise, \nnn */
	if (*p == '\\' && len >= 2 && len <= 4)
	{
		val = strtol (++p, (char **) NULL, 8);
		for (;;)
		{
			if (!*++p)
				return ((u_char) val);
			if (*p < '0' || *p > '8')
				break;
		}
	}
	msg ("illegal option value -- e");
	usage ();
	
	/* NOTREACHED */
	return 0;
}
