/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.util.BytesRef;

public class LateInteractionField
extends BinaryDocValuesField {
    public LateInteractionField(String name, float[][] value) {
        super(name, LateInteractionField.encode(value));
    }

    public void setValue(float[][] value) {
        this.fieldsData = LateInteractionField.encode(value);
    }

    public float[][] getValue() {
        return LateInteractionField.decode((BytesRef)this.fieldsData);
    }

    public static BytesRef encode(float[][] value) {
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException("Value should not be null or empty");
        }
        if (value[0] == null || value[0].length == 0) {
            throw new IllegalArgumentException("Composing token vectors should not be null or empty");
        }
        int tokenVectorDimension = value[0].length;
        ByteBuffer buffer = ByteBuffer.allocate(4 + value.length * tokenVectorDimension * 4).order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(tokenVectorDimension);
        FloatBuffer floatBuffer = buffer.asFloatBuffer();
        for (int i = 0; i < value.length; ++i) {
            if (value[i].length != tokenVectorDimension) {
                throw new IllegalArgumentException("Composing token vectors should have the same dimension. Mismatching dimensions detected between token[0] and token[" + i + "], " + value[0].length + " != " + value[i].length);
            }
            floatBuffer.put(value[i]);
        }
        return new BytesRef(buffer.array());
    }

    public static float[][] decode(BytesRef payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload.bytes, payload.offset, payload.length);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int tokenVectorDimension = buffer.getInt();
        int numVectors = (payload.length - 4) / (tokenVectorDimension * 4);
        if (numVectors * tokenVectorDimension * 4 + 4 != payload.length) {
            throw new IllegalArgumentException("Provided payload does not appear to have been encoded via LateInteractionField.encode. Payload length should be equal to 4 + numVectors * tokenVectorDimension, got " + payload.length + " != 4 + " + numVectors + " * " + tokenVectorDimension);
        }
        FloatBuffer floatBuffer = buffer.asFloatBuffer();
        float[][] value = new float[numVectors][];
        for (int i = 0; i < numVectors; ++i) {
            value[i] = new float[tokenVectorDimension];
            floatBuffer.get(value[i]);
        }
        return value;
    }
}

