/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit6.runner;

import java.util.Set;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.IVisitsTestTrees;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.TestExecution;
import org.eclipse.jdt.internal.junit6.runner.JUnit6Identifier;
import org.eclipse.jdt.internal.junit6.runner.JUnit6TestListener;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherExecutionRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherExecutionRequestBuilder;

public class JUnit6TestReference
implements ITestReference {
    private final CancellationToken fCancellationToken = CancellationToken.create();
    private LauncherDiscoveryRequest fRequest;
    private Launcher fLauncher;
    private TestPlan fTestPlan;
    private RemoteTestRunner fRemoteTestRunner;

    public JUnit6TestReference(LauncherDiscoveryRequest request, Launcher launcher, RemoteTestRunner remoteTestRunner) {
        this.fRequest = request;
        this.fLauncher = launcher;
        this.fRemoteTestRunner = remoteTestRunner;
        this.fTestPlan = this.fLauncher.discover(this.fRequest);
    }

    public int countTestCases() {
        return (int)this.fTestPlan.countTestIdentifiers(TestIdentifier::isTest);
    }

    public void sendTree(IVisitsTestTrees notified) {
        for (TestIdentifier root : this.fTestPlan.getRoots()) {
            for (TestIdentifier child : this.fTestPlan.getChildren(root)) {
                this.sendTree(notified, child);
            }
        }
    }

    private void sendTree(IVisitsTestTrees notified, TestIdentifier testIdentifier) {
        JUnit6Identifier identifier = new JUnit6Identifier(testIdentifier);
        String parentId = this.getParentId(testIdentifier, this.fTestPlan);
        if (testIdentifier.isTest()) {
            notified.visitTreeEntry((ITestIdentifier)identifier, false, 1, false, parentId);
        } else {
            Set children = this.fTestPlan.getChildren(testIdentifier);
            notified.visitTreeEntry((ITestIdentifier)identifier, true, children.size(), false, parentId);
            for (TestIdentifier child : children) {
                this.sendTree(notified, child);
            }
        }
    }

    private String getParentId(TestIdentifier testIdentifier, TestPlan testPlan) {
        return testPlan.getParent(testIdentifier).map(parent -> this.fRemoteTestRunner.getTestId((ITestIdentifier)new JUnit6Identifier((TestIdentifier)parent))).orElse("-1");
    }

    public void run(TestExecution execution) {
        JUnit6TestListener listener = new JUnit6TestListener(execution.getListener(), this.fRemoteTestRunner);
        execution.addStopListener(() -> {
            listener.executionStopped();
            this.fCancellationToken.cancel();
        });
        LauncherExecutionRequest request = LauncherExecutionRequestBuilder.request((TestPlan)this.fTestPlan).cancellationToken(this.fCancellationToken).listeners(new TestExecutionListener[]{listener}).build();
        this.fLauncher.execute(request);
    }

    public ITestIdentifier getIdentifier() {
        return new JUnit6Identifier((TestIdentifier)this.fTestPlan.getRoots().iterator().next());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JUnit6TestReference)) {
            return false;
        }
        JUnit6TestReference ref = (JUnit6TestReference)obj;
        return ref.fRequest.equals(this.fRequest);
    }

    public int hashCode() {
        return this.fRequest.hashCode();
    }

    public String toString() {
        return this.fRequest.toString();
    }
}

