/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.resolution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRangeResult {
    private final VersionRangeRequest request;
    private final List<Exception> exceptions;
    private List<Version> versions;
    private final Map<Version, ArtifactRepository> repositories;
    private VersionConstraint versionConstraint;

    public VersionRangeResult(VersionRangeRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("version range request has not been specified");
        }
        this.request = request;
        this.exceptions = new ArrayList<Exception>(4);
        this.versions = new ArrayList<Version>();
        this.repositories = new HashMap<Version, ArtifactRepository>();
    }

    public VersionRangeRequest getRequest() {
        return this.request;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public VersionRangeResult addException(Exception exception) {
        if (exception != null) {
            this.exceptions.add(exception);
        }
        return this;
    }

    public List<Version> getVersions() {
        return this.versions;
    }

    public VersionRangeResult addVersion(Version version) {
        this.versions.add(version);
        return this;
    }

    public VersionRangeResult setVersions(List<Version> versions) {
        this.versions = versions != null ? versions : new ArrayList();
        return this;
    }

    public ArtifactRepository getRepository(Version version) {
        return this.repositories.get(version);
    }

    public VersionRangeResult setRepository(Version version, ArtifactRepository repository) {
        if (repository != null) {
            this.repositories.put(version, repository);
        }
        return this;
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public VersionRangeResult setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
        return this;
    }

    public String toString() {
        return String.valueOf(this.repositories);
    }
}

