/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.BaseFilter;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.sonatype.plexus.build.incremental.BuildContext;

@Singleton
@Named
public class DefaultMavenFileFilter
extends BaseFilter
implements MavenFileFilter {
    private final BuildContext buildContext;

    @Inject
    public DefaultMavenFileFilter(BuildContext buildContext) {
        this.buildContext = Objects.requireNonNull(buildContext);
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, MavenProject mavenProject, List<String> filters, boolean escapedBackslashesInFilePath, String encoding, MavenSession mavenSession) throws MavenFilteringException {
        MavenResourcesExecution mre = new MavenResourcesExecution();
        mre.setMavenProject(mavenProject);
        mre.setFileFilters(filters);
        mre.setEscapeWindowsPaths(escapedBackslashesInFilePath);
        mre.setMavenSession(mavenSession);
        mre.setInjectProjectBuildFilters(true);
        List filterWrappers = this.getDefaultFilterWrappers(mre);
        this.copyFile(from, to, filtering, filterWrappers, encoding);
    }

    @Override
    public void copyFile(MavenFileFilterRequest mavenFileFilterRequest) throws MavenFilteringException {
        List filterWrappers = this.getDefaultFilterWrappers(mavenFileFilterRequest);
        this.copyFile(mavenFileFilterRequest.getFrom(), mavenFileFilterRequest.getTo(), mavenFileFilterRequest.isFiltering(), filterWrappers, mavenFileFilterRequest.getEncoding());
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FilterWrapper> filterWrappers, String encoding) throws MavenFilteringException {
        this.copyFile(from, to, filtering, filterWrappers, encoding, false);
    }

    @Override
    public void copyFile(File from, File to, boolean filtering, List<FilterWrapper> filterWrappers, String encoding, boolean overwrite) throws MavenFilteringException {
        try {
            if (filtering) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("filtering " + from.getPath() + " to " + to.getPath());
                }
                FilterWrapper[] array = filterWrappers.toArray(new FilterWrapper[0]);
                FilteringUtils.copyFile(from, to, encoding, array, false);
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("copy " + from.getPath() + " to " + to.getPath());
                }
                FilteringUtils.copyFile(from, to, encoding, new FilterWrapper[0], overwrite);
            }
            this.buildContext.refresh(to);
        }
        catch (IOException e) {
            throw new MavenFilteringException((filtering ? "filtering " : "copying ") + from.getPath() + " to " + to.getPath() + " failed with " + e.getClass().getSimpleName() + ": " + e.getMessage(), e);
        }
    }
}

